/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.lang.reflect.Field;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class EnumClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Enum.class;
    }

    @Replacement(type=ReplacementType.TRACKER, replacingStatic=true, category=ReplacementCategory.EXT_0)
    public static <T extends Enum<T>> T valueOf(Class<T> enumType, String name) {
        if (enumType != null && name != null && ExecutionTracer.isTaintInput(name)) {
            try {
                Object[] entries;
                Field values = enumType.getDeclaredField("$VALUES");
                values.setAccessible(true);
                for (Object obj : entries = (Object[])values.get(null)) {
                    ExecutionTracer.handleTaintForStringEquals(name, obj.toString(), false);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("BUG in EvoMaster", e);
            }
        }
        T x = Enum.valueOf(enumType, name);
        return x;
    }
}

