/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.net.URI;
import java.net.URISyntaxException;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class URIClassReplacement
implements MethodReplacementClass {
    private static ThreadLocal<URI> instance = new ThreadLocal();

    @Override
    public Class<?> getTargetClass() {
        return URI.class;
    }

    public static URI consumeInstance() {
        URI uri = instance.get();
        if (uri == null) {
            throw new IllegalStateException("No instance to consume");
        }
        instance.set(null);
        return uri;
    }

    private static void addInstance(URI x) {
        URI uri = instance.get();
        if (uri != null) {
            throw new IllegalStateException("Previous instance was not consumed");
        }
        instance.set(x);
    }

    @Replacement(type=ReplacementType.EXCEPTION, category=ReplacementCategory.EXT_0, replacingConstructor=true)
    public static void URI(String s, String idTemplate) throws URISyntaxException {
        URI uri;
        if (ExecutionTracer.isTaintInput(s)) {
            ExecutionTracer.addStringSpecialization(s, new StringSpecializationInfo(StringSpecialization.URI, null));
        }
        if (idTemplate == null) {
            uri = new URI(s);
        } else {
            try {
                URI res = new URI(s);
                ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(1.0, 0.1));
                uri = res;
            }
            catch (RuntimeException e) {
                double h = s == null ? 0.05 : 0.1;
                ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(h, 1.0));
                throw e;
            }
        }
        URIClassReplacement.addInstance(uri);
    }

    @Replacement(type=ReplacementType.EXCEPTION, replacingStatic=true, category=ReplacementCategory.EXT_0)
    public static URI create(String s, String idTemplate) {
        if (ExecutionTracer.isTaintInput(s)) {
            ExecutionTracer.addStringSpecialization(s, new StringSpecializationInfo(StringSpecialization.URI, null));
        }
        if (idTemplate == null) {
            return URI.create(s);
        }
        try {
            URI res = URI.create(s);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(1.0, 0.1));
            return res;
        }
        catch (RuntimeException e) {
            double h = s == null ? 0.05 : 0.1;
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(h, 1.0));
            throw e;
        }
    }

    @Replacement(type=ReplacementType.EXCEPTION, replacingStatic=false, category=ReplacementCategory.EXT_0)
    public static URI resolve(URI caller, String s, String idTemplate) {
        if (ExecutionTracer.isTaintInput(s)) {
            ExecutionTracer.addStringSpecialization(s, new StringSpecializationInfo(StringSpecialization.URI, null));
        }
        if (idTemplate == null) {
            return caller.resolve(s);
        }
        try {
            URI res = caller.resolve(s);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(1.0, 0.1));
            return res;
        }
        catch (RuntimeException e) {
            double h = s == null ? 0.05 : 0.1;
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(h, 1.0));
            throw e;
        }
    }
}

