/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.evomaster.client.java.instrumentation.ExternalServiceInfo;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ExternalServiceInfoUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyCast;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyMethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.shared.PreDefinedSSLInfo;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class OkHttpClientClassReplacement
extends ThirdPartyMethodReplacementClass {
    private static ThreadLocal<Object> instance = new ThreadLocal();
    private static final OkHttpClientClassReplacement singleton = new OkHttpClientClassReplacement();

    @Override
    protected String getNameOfThirdPartyTargetClass() {
        return "com.squareup.okhttp.OkHttpClient";
    }

    public static Object consumeInstance() {
        Object client = instance.get();
        if (client == null) {
            throw new IllegalStateException("No instance to consume");
        }
        instance.set(null);
        return client;
    }

    private static void addInstance(Object x) {
        Object client = instance.get();
        if (client != null) {
            throw new IllegalStateException("Previous instance was not consumed");
        }
        instance.set(x);
    }

    @Replacement(replacingStatic=false, type=ReplacementType.TRACKER, id="okhttpclient_constructor", usageFilter=UsageFilter.ANY, category=ReplacementCategory.NET, replacingConstructor=true, castTo="com.squareup.okhttp.OkHttpClient")
    public static void OkHttpClient() throws Exception {
        Constructor original = OkHttpClientClassReplacement.getOriginalConstructor(singleton, "okhttpclient_constructor");
        try {
            Object client = original.newInstance(new Object[0]);
            client.getClass().getMethod("setSslSocketFactory", SSLSocketFactory.class).invoke(client, PreDefinedSSLInfo.getTrustAllSSLSocketFactory());
            client.getClass().getMethod("setHostnameVerifier", HostnameVerifier.class).invoke(client, PreDefinedSSLInfo.allowAllHostNames());
            OkHttpClientClassReplacement.addInstance(client);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    @Replacement(replacingStatic=false, type=ReplacementType.TRACKER, id="okhttpclient_setSslSocketFactory", usageFilter=UsageFilter.ANY, category=ReplacementCategory.NET, castTo="com.squareup.okhttp.OkHttpClient")
    public static Object setSslSocketFactory(Object caller, @ThirdPartyCast(actualType="javax.net.ssl.SSLSocketFactory") Object sslSocketFactory) throws Exception {
        if (caller == null) {
            throw new NullPointerException();
        }
        Method original = OkHttpClientClassReplacement.getOriginal(singleton, "okhttpclient_setSslSocketFactory", caller);
        try {
            return original.invoke(caller, PreDefinedSSLInfo.getTrustAllSSLSocketFactory());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getCause();
        }
    }

    @Replacement(replacingStatic=false, type=ReplacementType.TRACKER, id="okhttpclient_setHostnameVerifier", usageFilter=UsageFilter.ANY, category=ReplacementCategory.NET, castTo="com.squareup.okhttp.OkHttpClient")
    public static Object setHostnameVerifier(Object caller, @ThirdPartyCast(actualType="javax.net.ssl.HostnameVerifier") Object hostnameVerifier) throws Exception {
        if (caller == null) {
            throw new NullPointerException();
        }
        Method original = OkHttpClientClassReplacement.getOriginal(singleton, "okhttpclient_setHostnameVerifier", caller);
        try {
            return original.invoke(caller, PreDefinedSSLInfo.allowAllHostNames());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getCause();
        }
    }

    @Replacement(replacingStatic=false, type=ReplacementType.TRACKER, id="okhttpclient_newCall", usageFilter=UsageFilter.ANY, category=ReplacementCategory.NET, castTo="com.squareup.okhttp.Call")
    public static Object newCall(Object caller, @ThirdPartyCast(actualType="com.squareup.okhttp.Request") Object request) throws Exception {
        if (caller == null) {
            throw new NullPointerException();
        }
        Method original = OkHttpClientClassReplacement.getOriginal(singleton, "okhttpclient_newCall", caller);
        Object replaced = request;
        Object url = request.getClass().getMethod("httpUrl", new Class[0]).invoke(request, new Object[0]);
        String urlScheme = (String)url.getClass().getMethod("scheme", new Class[0]).invoke(url, new Object[0]);
        String urlHost = (String)url.getClass().getMethod("host", new Class[0]).invoke(url, new Object[0]);
        int urlPort = (Integer)url.getClass().getMethod("port", new Class[0]).invoke(url, new Object[0]);
        String urlEncodedPath = (String)url.getClass().getMethod("encodedPath", new Class[0]).invoke(url, new Object[0]);
        if ((urlScheme.equalsIgnoreCase("https") || urlScheme.equalsIgnoreCase("http")) && !ExternalServiceInfoUtils.skipHostnameOrIp(urlHost) && !ExecutionTracer.skipHostname(urlHost)) {
            ExternalServiceInfo remoteHostInfo = new ExternalServiceInfo(urlScheme, urlHost, urlPort);
            String[] ipAndPort = ExternalServiceInfoUtils.collectExternalServiceInfo(remoteHostInfo, urlPort);
            String replacedUrl = urlScheme + "://" + ipAndPort[0] + ":" + ipAndPort[1] + urlEncodedPath;
            Object encodedQuery = url.getClass().getMethod("encodedQuery", new Class[0]).invoke(url, new Object[0]);
            if (encodedQuery != null && !((String)encodedQuery).isEmpty()) {
                replacedUrl = replacedUrl + "?" + (String)encodedQuery;
            }
            ClassLoader loader = ExecutionTracer.getLastCallerClassLoader();
            Object builder = loader.loadClass("com.squareup.okhttp.Request$Builder").newInstance();
            builder = builder.getClass().getMethod("url", String.class).invoke(builder, replacedUrl);
            replaced = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
        }
        try {
            return original.invoke(caller, replaced);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getCause();
        }
    }
}

