/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyMethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.heuristic.ValidatorHeuristics;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class ValidatorClassReplacement
extends ThirdPartyMethodReplacementClass {
    private static final ValidatorClassReplacement singleton = new ValidatorClassReplacement();

    @Override
    protected String getNameOfThirdPartyTargetClass() {
        return "javax.validation.Validator";
    }

    @Replacement(replacingStatic=false, type=ReplacementType.TRACKER, id="validate", usageFilter=UsageFilter.ANY, category=ReplacementCategory.EXT_0, castTo="java.util.Set")
    public static Object validate(Object caller, Object object, Class<?> ... groups) throws Exception {
        if (caller == null) {
            throw new NullPointerException();
        }
        Method original = ValidatorClassReplacement.getOriginal(singleton, "validate", caller);
        Object result = null;
        try {
            result = original.invoke(caller, object, groups);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getCause();
        }
        if (object != null) {
            Class<?> validatorClass = caller.getClass();
            Class<?> objectClass = object.getClass();
            Object beanDescriptor = validatorClass.getMethod("getConstraintsForClass", Class.class).invoke(caller, objectClass);
            boolean isConstrained = (Boolean)beanDescriptor.getClass().getMethod("isBeanConstrained", new Class[0]).invoke(beanDescriptor, new Object[0]);
            if (isConstrained) {
                String actionName = ExecutionTracer.getActionName();
                String lastLine = ExecutionTracer.getLastExecutedStatement();
                String idTemplate = "MethodReplacement__" + objectClass.getName() + "__" + actionName + "__" + lastLine;
                ReplacementType type = ReplacementType.BOOLEAN;
                Truthness t = ValidatorHeuristics.computeTruthness(caller, object);
                ExecutionTracer.executedReplacedMethod(idTemplate, type, t);
            }
        }
        return result;
    }
}

