/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.shared;

public class RegexSharedUtils {
    public static String removeParentheses(String regex) {
        String s = regex.trim();
        if (!s.startsWith("(") || s.endsWith(")")) {
            // empty if block
        }
        return s;
    }

    public static String forceFullMatch(String regex) {
        String s = RegexSharedUtils.removeParentheses(regex);
        if (s.startsWith("^") && s.endsWith("$")) {
            return s;
        }
        if (s.startsWith("^")) {
            return s + "$";
        }
        if (s.endsWith("$")) {
            return "^" + s;
        }
        return "^(" + s + ")$";
    }

    public static String handlePartialMatch(String regex) {
        String s = RegexSharedUtils.removeParentheses(regex);
        if (s.startsWith("^") && s.endsWith("$")) {
            return s;
        }
        if (s.startsWith("^")) {
            return s + "([\\s\\S]*)";
        }
        if (s.endsWith("$")) {
            return "([\\s\\S]*)" + s;
        }
        return String.format("([\\s\\S]*)(%s)([\\s\\S]*)", regex);
    }
}

