/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.expression;

import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.ExpressionVisitor;
import shaded.net.sf.jsqlparser.expression.RowConstructor;
import shaded.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import shaded.net.sf.jsqlparser.statement.create.table.ColDataType;

public class CastExpression
extends ASTNodeAccessImpl
implements Expression {
    private Expression leftExpression;
    private ColDataType type;
    private RowConstructor rowConstructor;
    private boolean useCastKeyword = true;

    public RowConstructor getRowConstructor() {
        return this.rowConstructor;
    }

    public void setRowConstructor(RowConstructor rowConstructor) {
        this.rowConstructor = rowConstructor;
        this.type = null;
    }

    public CastExpression withRowConstructor(RowConstructor rowConstructor) {
        this.setRowConstructor(rowConstructor);
        return this;
    }

    public ColDataType getType() {
        return this.type;
    }

    public void setType(ColDataType type) {
        this.type = type;
        this.rowConstructor = null;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public boolean isUseCastKeyword() {
        return this.useCastKeyword;
    }

    public void setUseCastKeyword(boolean useCastKeyword) {
        this.useCastKeyword = useCastKeyword;
    }

    public String toString() {
        if (this.useCastKeyword) {
            return this.rowConstructor != null ? "CAST(" + this.leftExpression + " AS " + this.rowConstructor.toString() + ")" : "CAST(" + this.leftExpression + " AS " + this.type.toString() + ")";
        }
        return this.leftExpression + "::" + this.type.toString();
    }

    public CastExpression withType(ColDataType type) {
        this.setType(type);
        return this;
    }

    public CastExpression withUseCastKeyword(boolean useCastKeyword) {
        this.setUseCastKeyword(useCastKeyword);
        return this;
    }

    public CastExpression withLeftExpression(Expression leftExpression) {
        this.setLeftExpression(leftExpression);
        return this;
    }

    public <E extends Expression> E getLeftExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getLeftExpression()));
    }
}

