/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.util.validation.validator;

import java.util.List;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.MySQLIndexHint;
import shaded.net.sf.jsqlparser.expression.SQLServerHints;
import shaded.net.sf.jsqlparser.parser.feature.Feature;
import shaded.net.sf.jsqlparser.schema.Table;
import shaded.net.sf.jsqlparser.statement.select.AllColumns;
import shaded.net.sf.jsqlparser.statement.select.AllTableColumns;
import shaded.net.sf.jsqlparser.statement.select.ExceptOp;
import shaded.net.sf.jsqlparser.statement.select.Fetch;
import shaded.net.sf.jsqlparser.statement.select.FromItemVisitor;
import shaded.net.sf.jsqlparser.statement.select.IntersectOp;
import shaded.net.sf.jsqlparser.statement.select.Join;
import shaded.net.sf.jsqlparser.statement.select.LateralSubSelect;
import shaded.net.sf.jsqlparser.statement.select.MinusOp;
import shaded.net.sf.jsqlparser.statement.select.Offset;
import shaded.net.sf.jsqlparser.statement.select.ParenthesisFromItem;
import shaded.net.sf.jsqlparser.statement.select.Pivot;
import shaded.net.sf.jsqlparser.statement.select.PivotVisitor;
import shaded.net.sf.jsqlparser.statement.select.PivotXml;
import shaded.net.sf.jsqlparser.statement.select.PlainSelect;
import shaded.net.sf.jsqlparser.statement.select.SelectExpressionItem;
import shaded.net.sf.jsqlparser.statement.select.SelectItem;
import shaded.net.sf.jsqlparser.statement.select.SelectItemVisitor;
import shaded.net.sf.jsqlparser.statement.select.SelectVisitor;
import shaded.net.sf.jsqlparser.statement.select.SetOperationList;
import shaded.net.sf.jsqlparser.statement.select.SubJoin;
import shaded.net.sf.jsqlparser.statement.select.SubSelect;
import shaded.net.sf.jsqlparser.statement.select.TableFunction;
import shaded.net.sf.jsqlparser.statement.select.UnPivot;
import shaded.net.sf.jsqlparser.statement.select.UnionOp;
import shaded.net.sf.jsqlparser.statement.select.ValuesList;
import shaded.net.sf.jsqlparser.statement.select.WithItem;
import shaded.net.sf.jsqlparser.statement.values.ValuesStatement;
import shaded.net.sf.jsqlparser.util.validation.ValidationCapability;
import shaded.net.sf.jsqlparser.util.validation.ValidationUtil;
import shaded.net.sf.jsqlparser.util.validation.metadata.NamedObject;
import shaded.net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import shaded.net.sf.jsqlparser.util.validation.validator.ExpressionValidator;
import shaded.net.sf.jsqlparser.util.validation.validator.GroupByValidator;
import shaded.net.sf.jsqlparser.util.validation.validator.LimitValidator;
import shaded.net.sf.jsqlparser.util.validation.validator.ValuesStatementValidator;

public class SelectValidator
extends AbstractValidator<SelectItem>
implements SelectVisitor,
SelectItemVisitor,
FromItemVisitor,
PivotVisitor {
    @Override
    public void visit(PlainSelect plainSelect) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.select);
            this.validateFeature(c, plainSelect.getMySqlHintStraightJoin(), Feature.mySqlHintStraightJoin);
            this.validateOptionalFeature(c, plainSelect.getOracleHint(), Feature.oracleHint);
            this.validateOptionalFeature(c, plainSelect.getSkip(), Feature.skip);
            this.validateOptionalFeature(c, plainSelect.getFirst(), Feature.first);
            if (plainSelect.getDistinct() != null) {
                if (plainSelect.getDistinct().isUseUnique()) {
                    this.validateFeature(c, Feature.selectUnique);
                } else {
                    this.validateFeature(c, Feature.distinct);
                }
                this.validateOptionalFeature(c, plainSelect.getDistinct().getOnSelectItems(), Feature.distinctOn);
            }
            this.validateOptionalFeature(c, plainSelect.getTop(), Feature.top);
            this.validateFeature(c, plainSelect.getMySqlSqlCacheFlag() != null, Feature.mysqlSqlCacheFlag);
            this.validateFeature(c, plainSelect.getMySqlSqlCalcFoundRows(), Feature.mysqlCalcFoundRows);
            this.validateOptionalFeature(c, plainSelect.getIntoTables(), Feature.selectInto);
            this.validateOptionalFeature(c, plainSelect.getKsqlWindow(), Feature.kSqlWindow);
            this.validateFeature(c, this.isNotEmpty(plainSelect.getOrderByElements()) && plainSelect.isOracleSiblings(), Feature.oracleOrderBySiblings);
            if (plainSelect.isForUpdate()) {
                this.validateFeature(c, Feature.selectForUpdate);
                this.validateOptionalFeature(c, plainSelect.getForUpdateTable(), Feature.selectForUpdateOfTable);
                this.validateOptionalFeature(c, plainSelect.getWait(), Feature.selectForUpdateWait);
                this.validateFeature(c, plainSelect.isNoWait(), Feature.selectForUpdateNoWait);
            }
            this.validateOptionalFeature(c, plainSelect.getForXmlPath(), Feature.selectForXmlPath);
            this.validateOptionalFeature(c, plainSelect.getOptimizeFor(), Feature.optimizeFor);
        }
        this.validateOptionalFromItem(plainSelect.getFromItem());
        this.validateOptionalFromItems(plainSelect.getIntoTables());
        this.validateOptionalJoins(plainSelect.getJoins());
        this.validateOptionalList(plainSelect.getSelectItems(), () -> this, (e, v) -> e.accept((SelectItemVisitor)v));
        this.validateOptionalExpression(plainSelect.getWhere());
        this.validateOptionalExpression(plainSelect.getOracleHierarchical());
        if (plainSelect.getGroupBy() != null) {
            plainSelect.getGroupBy().accept(this.getValidator(GroupByValidator.class));
        }
        this.validateOptionalExpression(plainSelect.getHaving());
        this.validateOptionalOrderByElements(plainSelect.getOrderByElements());
        if (plainSelect.getLimit() != null) {
            this.getValidator(LimitValidator.class).validate(plainSelect.getLimit());
        }
        if (plainSelect.getOffset() != null) {
            this.validateOffset(plainSelect.getOffset());
        }
        if (plainSelect.getFetch() != null) {
            this.validateFetch(plainSelect.getFetch());
        }
    }

    @Override
    public void visit(AllTableColumns allTableColumns) {
    }

    @Override
    public void visit(AllColumns allColumns) {
    }

    @Override
    public void visit(SelectExpressionItem selectExpressionItem) {
        selectExpressionItem.getExpression().accept(this.getValidator(ExpressionValidator.class));
    }

    @Override
    public void visit(SubSelect subSelect) {
        if (this.isNotEmpty(subSelect.getWithItemsList())) {
            subSelect.getWithItemsList().forEach(withItem -> withItem.accept(this));
        }
        subSelect.getSelectBody().accept(this);
        this.validateOptional(subSelect.getPivot(), p -> p.accept(this));
    }

    @Override
    public void visit(Table table) {
        SQLServerHints sqlServerHints;
        this.validateNameWithAlias(NamedObject.table, table.getFullyQualifiedName(), ValidationUtil.getAlias(table.getAlias()));
        this.validateOptional(table.getPivot(), p -> p.accept(this));
        this.validateOptional(table.getUnPivot(), up -> up.accept(this));
        MySQLIndexHint indexHint = table.getIndexHint();
        if (indexHint != null && this.isNotEmpty(indexHint.getIndexNames())) {
            indexHint.getIndexNames().forEach(i -> this.validateName(NamedObject.index, (String)i));
        }
        if ((sqlServerHints = table.getSqlServerHints()) != null) {
            this.validateName(NamedObject.index, sqlServerHints.getIndexName());
        }
    }

    @Override
    public void visit(Pivot pivot) {
        this.validateFeature(Feature.pivot);
        this.validateOptionalExpressions(pivot.getForColumns());
    }

    @Override
    public void visit(UnPivot unpivot) {
        this.validateFeature(Feature.unpivot);
        this.validateOptionalExpressions(unpivot.getUnPivotForClause());
        this.validateOptionalExpressions(unpivot.getUnPivotClause());
    }

    @Override
    public void visit(PivotXml pivot) {
        this.validateFeature(Feature.pivotXml);
        this.validateOptionalExpressions(pivot.getForColumns());
        if (this.isNotEmpty(pivot.getFunctionItems())) {
            ExpressionValidator v = this.getValidator(ExpressionValidator.class);
            pivot.getFunctionItems().forEach(f -> f.getFunction().accept(v));
        }
        if (pivot.getInSelect() != null) {
            pivot.getInSelect().accept(this);
        }
    }

    public void validateOffset(Offset offset) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.offset);
            this.validateOptionalFeature(c, offset.getOffsetParam(), Feature.offsetParam);
        }
    }

    public void validateFetch(Fetch fetch) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.fetch);
            this.validateFeature(c, fetch.isFetchParamFirst(), Feature.fetchFirst);
            this.validateFeature(c, !fetch.isFetchParamFirst(), Feature.fetchNext);
        }
        this.validateOptionalExpression(fetch.getFetchJdbcParameter());
    }

    @Override
    public void visit(SubJoin subjoin) {
        this.validateOptionalFromItem(subjoin.getLeft());
        this.validateOptionalJoins(subjoin.getJoinList());
        this.validateOptional(subjoin.getPivot(), e -> e.accept(this));
    }

    public void validateOptionalJoins(List<Join> joins) {
        if (joins != null) {
            for (Join join : joins) {
                this.validateOptionalJoin(join);
            }
        }
    }

    public void validateOptionalJoin(Join join) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.join);
            this.validateFeature(c, join.isSimple() && join.isOuter(), Feature.joinOuterSimple);
            this.validateFeature(c, join.isSimple(), Feature.joinSimple);
            this.validateFeature(c, join.isRight(), Feature.joinRight);
            this.validateFeature(c, join.isNatural(), Feature.joinNatural);
            this.validateFeature(c, join.isFull(), Feature.joinFull);
            this.validateFeature(c, join.isLeft(), Feature.joinLeft);
            this.validateFeature(c, join.isCross(), Feature.joinCross);
            this.validateFeature(c, join.isOuter(), Feature.joinOuter);
            this.validateFeature(c, join.isInner(), Feature.joinInner);
            this.validateFeature(c, join.isSemi(), Feature.joinSemi);
            this.validateFeature(c, join.isStraight(), Feature.joinStraight);
            this.validateFeature(c, join.isApply(), Feature.joinApply);
            this.validateFeature(c, join.isWindowJoin(), Feature.joinWindow);
            this.validateOptionalFeature(c, join.getUsingColumns(), Feature.joinUsingColumns);
        }
        this.validateOptionalFromItem(join.getRightItem());
        for (Expression onExpression : join.getOnExpressions()) {
            this.validateOptionalExpression(onExpression);
        }
        this.validateOptionalExpressions(join.getUsingColumns());
    }

    @Override
    public void visit(SetOperationList setOperation) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.setOperation);
            this.validateFeature(c, setOperation.getOperations().stream().anyMatch(o -> o instanceof UnionOp), Feature.setOperationUnion);
            this.validateFeature(c, setOperation.getOperations().stream().anyMatch(o -> o instanceof IntersectOp), Feature.setOperationIntersect);
            this.validateFeature(c, setOperation.getOperations().stream().anyMatch(o -> o instanceof ExceptOp), Feature.setOperationExcept);
            this.validateFeature(c, setOperation.getOperations().stream().anyMatch(o -> o instanceof MinusOp), Feature.setOperationMinus);
        }
        if (this.isNotEmpty(setOperation.getSelects())) {
            setOperation.getSelects().forEach(s -> s.accept(this));
        }
        this.validateOptionalOrderByElements(setOperation.getOrderByElements());
        if (setOperation.getLimit() != null) {
            this.getValidator(LimitValidator.class).validate(setOperation.getLimit());
        }
        if (setOperation.getOffset() != null) {
            this.validateOffset(setOperation.getOffset());
        }
        if (setOperation.getFetch() != null) {
            this.validateFetch(setOperation.getFetch());
        }
    }

    @Override
    public void visit(WithItem withItem) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.withItem);
            this.validateFeature(c, withItem.isRecursive(), Feature.withItemRecursive);
        }
        if (this.isNotEmpty(withItem.getWithItemList())) {
            withItem.getWithItemList().forEach(wi -> wi.accept(this));
        }
        withItem.getSubSelect().accept(this);
    }

    @Override
    public void visit(LateralSubSelect lateralSubSelect) {
        this.validateFeature(Feature.lateralSubSelect);
        this.validateOptional(lateralSubSelect.getPivot(), p -> p.accept(this));
        this.validateOptional(lateralSubSelect.getUnPivot(), up -> up.accept(this));
        this.validateOptional(lateralSubSelect.getSubSelect(), e -> e.accept(this));
    }

    @Override
    public void visit(ValuesList valuesList) {
        this.validateFeature(Feature.valuesList);
        this.validateOptionalMultiExpressionList(valuesList.getMultiExpressionList());
    }

    @Override
    public void visit(TableFunction tableFunction) {
        this.validateFeature(Feature.tableFunction);
        this.validateOptional(tableFunction.getPivot(), p -> p.accept(this));
        this.validateOptional(tableFunction.getUnPivot(), up -> up.accept(this));
    }

    @Override
    public void visit(ParenthesisFromItem parenthesis) {
        this.validateOptional(parenthesis.getFromItem(), e -> e.accept(this));
    }

    @Override
    public void visit(ValuesStatement values) {
        this.getValidator(ValuesStatementValidator.class).validate(values);
    }

    @Override
    public void validate(SelectItem statement) {
        statement.accept(this);
    }
}

