/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jgrapht.alg;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shaded.org.jgrapht.DirectedGraph;
import shaded.org.jgrapht.Graphs;
import shaded.org.jgrapht.alg.NeighborIndex;
import shaded.org.jgrapht.event.GraphEdgeChangeEvent;
import shaded.org.jgrapht.event.GraphListener;
import shaded.org.jgrapht.event.GraphVertexChangeEvent;

public class DirectedNeighborIndex<V, E>
implements GraphListener<V, E> {
    Map<V, NeighborIndex.Neighbors<V, E>> predecessorMap = new HashMap<V, NeighborIndex.Neighbors<V, E>>();
    Map<V, NeighborIndex.Neighbors<V, E>> successorMap = new HashMap<V, NeighborIndex.Neighbors<V, E>>();
    private DirectedGraph<V, E> graph;

    public DirectedNeighborIndex(DirectedGraph<V, E> directedGraph) {
        this.graph = directedGraph;
    }

    public Set<V> predecessorsOf(V v) {
        return this.getPredecessors(v).getNeighbors();
    }

    public List<V> predecessorListOf(V v) {
        return this.getPredecessors(v).getNeighborList();
    }

    public Set<V> successorsOf(V v) {
        return this.getSuccessors(v).getNeighbors();
    }

    public List<V> successorListOf(V v) {
        return this.getSuccessors(v).getNeighborList();
    }

    @Override
    public void edgeAdded(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
        E e = graphEdgeChangeEvent.getEdge();
        Object v = this.graph.getEdgeSource(e);
        Object v2 = this.graph.getEdgeTarget(e);
        if (this.successorMap.containsKey(v)) {
            this.getSuccessors(v).addNeighbor(v2);
        } else {
            this.getSuccessors(v);
        }
        if (this.predecessorMap.containsKey(v2)) {
            this.getPredecessors(v2).addNeighbor(v);
        } else {
            this.getPredecessors(v2);
        }
    }

    @Override
    public void edgeRemoved(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
        E e = graphEdgeChangeEvent.getEdge();
        Object v = this.graph.getEdgeSource(e);
        Object v2 = this.graph.getEdgeTarget(e);
        if (this.successorMap.containsKey(v)) {
            this.successorMap.get(v).removeNeighbor(v2);
        }
        if (this.predecessorMap.containsKey(v2)) {
            this.predecessorMap.get(v2).removeNeighbor(v);
        }
    }

    @Override
    public void vertexAdded(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
    }

    @Override
    public void vertexRemoved(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
        this.predecessorMap.remove(graphVertexChangeEvent.getVertex());
        this.successorMap.remove(graphVertexChangeEvent.getVertex());
    }

    private NeighborIndex.Neighbors<V, E> getPredecessors(V v) {
        NeighborIndex.Neighbors<V, E> neighbors = this.predecessorMap.get(v);
        if (neighbors == null) {
            neighbors = new NeighborIndex.Neighbors(v, Graphs.predecessorListOf(this.graph, v));
            this.predecessorMap.put((NeighborIndex.Neighbors<V, E>)v, (NeighborIndex.Neighbors<NeighborIndex.Neighbors<V, E>, E>)neighbors);
        }
        return neighbors;
    }

    private NeighborIndex.Neighbors<V, E> getSuccessors(V v) {
        NeighborIndex.Neighbors<V, E> neighbors = this.successorMap.get(v);
        if (neighbors == null) {
            neighbors = new NeighborIndex.Neighbors(v, Graphs.successorListOf(this.graph, v));
            this.successorMap.put((NeighborIndex.Neighbors<V, E>)v, (NeighborIndex.Neighbors<NeighborIndex.Neighbors<V, E>, E>)neighbors);
        }
        return neighbors;
    }
}

