/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import shaded.org.jgrapht.Graph;
import shaded.org.jgrapht.alg.util.UnionFind;

public class KruskalMinimumSpanningTree<V, E> {
    private double spanningTreeCost;
    private Set<E> edgeList;

    public KruskalMinimumSpanningTree(final Graph<V, E> graph) {
        UnionFind<V> unionFind = new UnionFind<V>(graph.vertexSet());
        ArrayList<E> arrayList = new ArrayList<E>(graph.edgeSet());
        Collections.sort(arrayList, new Comparator<E>(){

            @Override
            public int compare(E e, E e2) {
                return Double.valueOf(graph.getEdgeWeight(e)).compareTo(graph.getEdgeWeight(e2));
            }
        });
        this.spanningTreeCost = 0.0;
        this.edgeList = new HashSet();
        for (E e : arrayList) {
            V v = graph.getEdgeSource(e);
            V v2 = graph.getEdgeTarget(e);
            if (unionFind.find(v).equals(unionFind.find(v2))) continue;
            unionFind.union(v, v2);
            this.edgeList.add(e);
            this.spanningTreeCost += graph.getEdgeWeight(e);
        }
    }

    public Set<E> getEdgeSet() {
        return this.edgeList;
    }

    public double getSpanningTreeCost() {
        return this.spanningTreeCost;
    }
}

