/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jgrapht.graph;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import shaded.org.jgrapht.Graph;
import shaded.org.jgrapht.graph.MaskFunctor;
import shaded.org.jgrapht.util.PrefetchIterator;
import shaded.org.jgrapht.util.TypeUtil;

class MaskEdgeSet<V, E>
extends AbstractSet<E> {
    private Set<E> edgeSet;
    private Graph<V, E> graph;
    private MaskFunctor<V, E> mask;
    private transient TypeUtil<E> edgeTypeDecl = null;
    private int size;

    public MaskEdgeSet(Graph<V, E> graph, Set<E> set, MaskFunctor<V, E> maskFunctor) {
        this.graph = graph;
        this.edgeSet = set;
        this.mask = maskFunctor;
        this.size = -1;
    }

    @Override
    public boolean contains(Object object) {
        return this.edgeSet.contains(object) && !this.mask.isEdgeMasked(TypeUtil.uncheckedCast(object, this.edgeTypeDecl));
    }

    @Override
    public Iterator<E> iterator() {
        return new PrefetchIterator(new MaskEdgeSetNextElementFunctor());
    }

    @Override
    public int size() {
        if (this.size == -1) {
            this.size = 0;
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++this.size;
            }
        }
        return this.size;
    }

    private class MaskEdgeSetNextElementFunctor
    implements PrefetchIterator.NextElementFunctor<E> {
        private Iterator<E> iter;

        public MaskEdgeSetNextElementFunctor() {
            this.iter = MaskEdgeSet.this.edgeSet.iterator();
        }

        @Override
        public E nextElement() throws NoSuchElementException {
            Object e = this.iter.next();
            while (this.isMasked(e)) {
                e = this.iter.next();
            }
            return e;
        }

        private boolean isMasked(E e) {
            return MaskEdgeSet.this.mask.isEdgeMasked(e) || MaskEdgeSet.this.mask.isVertexMasked(MaskEdgeSet.this.graph.getEdgeSource(e)) || MaskEdgeSet.this.mask.isVertexMasked(MaskEdgeSet.this.graph.getEdgeTarget(e));
        }
    }
}

