/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller;

import org.evomaster.client.java.controller.EmbeddedSutController;
import org.evomaster.client.java.controller.ExternalSutController;
import org.evomaster.client.java.controller.internal.SutController;
import org.evomaster.client.java.instrumentation.InstrumentingAgent;
import shaded.com.ea.agentloader.AgentLoader;

public class InstrumentedSutStarter {
    private static boolean alreadyLoaded = false;
    private final SutController sutController;

    public static void loadAgent() {
        if (!alreadyLoaded) {
            alreadyLoaded = true;
            AgentLoader.loadAgentClass(InstrumentingAgent.class.getName(), "foobar_packagenameshouldnotexist.");
        }
    }

    public InstrumentedSutStarter(SutController sutController) {
        String toSkip = sutController.packagesToSkipInstrumentation();
        if (toSkip != null && !toSkip.isEmpty()) {
            System.setProperty("em.skipClasses", toSkip);
        }
        this.sutController = sutController;
        if (sutController instanceof EmbeddedSutController) {
            InstrumentedSutStarter.loadAgent();
            InstrumentingAgent.changePackagesToInstrument(sutController.getPackagePrefixesToCover());
        } else if (sutController instanceof ExternalSutController) {
            ((ExternalSutController)sutController).setInstrumentation(true);
            System.setProperty("shaded.org.eclipse.jetty.util.log.class", "shaded.org.eclipse.jetty.util.log.StdErrLog");
            System.setProperty("shaded.org.eclipse.jetty.LEVEL", "WARN");
        } else {
            throw new IllegalArgumentException("Invalid SUT controller type");
        }
    }

    public boolean start() {
        return this.sutController.startTheControllerServer();
    }

    public boolean stop() {
        return this.sutController.stopTheControllerServer();
    }

    public int getControllerServerPort() {
        return this.sutController.getControllerServerPort();
    }
}

