/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.api;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.testcontainers.Testcontainers;

public class SeleniumEMUtils {
    public static final String TESTCONTAINERS_HOST = "host.testcontainers.internal";

    public static String validateAndGetUrlOfStartingPageForDocker(String url, boolean modifyLocalHost) {
        if (url.isEmpty()) {
            throw new IllegalArgumentException("Starting page is not defined");
        }
        URI uri = null;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Provided Home Page link is not a valid URL: " + e.getMessage());
        }
        Testcontainers.exposeHostPorts((int[])new int[]{uri.getPort()});
        if (modifyLocalHost && uri.getHost().equalsIgnoreCase("localhost")) {
            try {
                uri = new URI(uri.getScheme().toLowerCase(Locale.US), uri.getUserInfo(), TESTCONTAINERS_HOST, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return uri.toString();
    }

    public static boolean waitForPageToLoad(WebDriver driver, int timeoutSecond) {
        JavascriptExecutor jsExecutor = (JavascriptExecutor)driver;
        WebDriverWait wait = new WebDriverWait(driver, Duration.of(timeoutSecond, ChronoUnit.SECONDS));
        try {
            return (Boolean)wait.until((Function)((ExpectedCondition)input -> {
                String res = jsExecutor.executeScript("return document.readyState === 'complete';", new Object[0]).toString();
                return Boolean.parseBoolean(res);
            }));
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public static void clickAndWaitPageLoad(WebDriver driver, String cssSelector) {
        WebElement element;
        try {
            element = driver.findElement(By.cssSelector((String)cssSelector));
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Cannot locate element with '" + cssSelector + "'.\nCurrent URL is: " + driver.getCurrentUrl() + "\nCurrent page is: " + driver.getPageSource());
        }
        element.click();
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SeleniumEMUtils.waitForPageToLoad(driver, 2);
    }

    public static void goToPage(WebDriver driver, String pageURL, int timeoutSeconds) {
        driver.get(pageURL);
        SeleniumEMUtils.waitForPageToLoad(driver, timeoutSeconds);
    }
}

