/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.internal.db.constraint;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.database.schema.DbSchemaDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableDto;
import org.evomaster.client.java.controller.db.h2.H2VersionUtils;
import org.evomaster.client.java.controller.internal.db.constraint.DbTableCheckExpression;
import org.evomaster.client.java.controller.internal.db.constraint.DbTableConstraint;
import org.evomaster.client.java.controller.internal.db.constraint.DbTableUniqueConstraint;
import org.evomaster.client.java.controller.internal.db.constraint.TableConstraintExtractor;
import org.evomaster.client.java.utils.SimpleLogger;

public class H2ConstraintExtractor
extends TableConstraintExtractor {
    private static final String CONSTRAINT_TYPE = "CONSTRAINT_TYPE";
    private static final String CHECK_EXPRESSION = "CHECK_EXPRESSION";
    private static final String COLUMN_LIST = "COLUMN_LIST";
    private static final String UNIQUE = "UNIQUE";
    private static final String REFERENTIAL = "REFERENTIAL";
    private static final String PRIMARY_KEY = "PRIMARY_KEY";
    private static final String PRIMARY_KEY_BLANK = "PRIMARY KEY";
    private static final String CHECK = "CHECK";
    private static final String CHECK_CONSTRAINT = "CHECK_CONSTRAINT";
    private static final String CONSTRAINT_CATALOG = "CONSTRAINT_CATALOG";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String CONSTRAINT_SCHEMA = "CONSTRAINT_SCHEMA";
    private static final String CONSTRAINT_NAME = "CONSTRAINT_NAME";

    @Override
    public List<DbTableConstraint> extract(Connection connectionToH2, DbSchemaDto schemaDto) throws SQLException {
        String h2DatabaseVersion = H2VersionUtils.getH2Version(connectionToH2);
        List<DbTableConstraint> columnConstraints = this.extractColumnConstraints(connectionToH2, schemaDto, h2DatabaseVersion);
        List<DbTableConstraint> tableCheckExpressions = this.extractTableConstraints(connectionToH2, schemaDto, h2DatabaseVersion);
        ArrayList<DbTableConstraint> allConstraints = new ArrayList<DbTableConstraint>();
        allConstraints.addAll(columnConstraints);
        allConstraints.addAll(tableCheckExpressions);
        return allConstraints;
    }

    private static void cannotHandle(String constraintType) {
        SimpleLogger.uniqueWarn("WARNING, EvoMaster cannot extract H2 constraints with type '" + constraintType);
    }

    private List<DbTableConstraint> extractColumnConstraints(Connection connectionToH2, DbSchemaDto schemaDto, String h2DatabaseVersion) throws SQLException {
        if (H2VersionUtils.isVersionGreaterOrEqual(h2DatabaseVersion, "2.0.0")) {
            return new ArrayList<DbTableConstraint>();
        }
        return this.extractColumnConstraintsVersion1OrLower(connectionToH2, schemaDto, h2DatabaseVersion);
    }

    private List<DbTableConstraint> extractTableConstraints(Connection connectionToH2, DbSchemaDto schemaDto, String h2DatabaseVersion) throws SQLException {
        if (H2VersionUtils.isVersionGreaterOrEqual(h2DatabaseVersion, "2.0.0")) {
            return this.extractTableConstraintsVersionTwoOrHigher(connectionToH2, schemaDto);
        }
        return this.extractTableConstraintsVersionOneOrLower(connectionToH2, schemaDto);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<DbTableConstraint> extractTableConstraintsVersionTwoOrHigher(Connection connectionToH2, DbSchemaDto schemaDto) throws SQLException {
        ArrayList<DbTableConstraint> tableCheckExpressions = new ArrayList<DbTableConstraint>();
        String tableSchema = schemaDto.name;
        Iterator<TableDto> iterator = schemaDto.tables.iterator();
        block30: while (iterator.hasNext()) {
            TableDto tableDto = iterator.next();
            String tableName = tableDto.name;
            Statement statement = connectionToH2.createStatement();
            Throwable throwable = null;
            try {
                String query = String.format("Select CONSTRAINT_CATALOG,CONSTRAINT_SCHEMA,CONSTRAINT_NAME,CONSTRAINT_TYPE From INFORMATION_SCHEMA.TABLE_CONSTRAINTS\n where TABLE_CONSTRAINTS.TABLE_SCHEMA='%s' \n and TABLE_CONSTRAINTS.TABLE_NAME='%s' ", tableSchema, tableName);
                ResultSet constraints = statement.executeQuery(query);
                Throwable throwable2 = null;
                try {
                    block31: while (true) {
                        String constraintType;
                        if (!constraints.next()) continue block30;
                        String constraintCatalog = constraints.getString(CONSTRAINT_CATALOG);
                        String constraintSchema = constraints.getString(CONSTRAINT_SCHEMA);
                        String constraintName = constraints.getString(CONSTRAINT_NAME);
                        switch (constraintType = constraints.getString(CONSTRAINT_TYPE)) {
                            case "UNIQUE": {
                                DbTableConstraint constraint = this.getTableUniqueConstraint(connectionToH2, tableName, constraintCatalog, constraintSchema, constraintName);
                                tableCheckExpressions.add(constraint);
                                continue block31;
                            }
                            case "CHECK": {
                                DbTableConstraint constraint = this.getTableCheckExpression(connectionToH2, tableName, constraintCatalog, constraintSchema, constraintName);
                                tableCheckExpressions.add(constraint);
                                continue block31;
                            }
                            case "PRIMARY_KEY": 
                            case "PRIMARY KEY": 
                            case "REFERENTIAL": {
                                continue block31;
                            }
                        }
                        H2ConstraintExtractor.cannotHandle(constraintType);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (constraints == null) continue;
                    if (throwable2 != null) {
                        try {
                            constraints.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    constraints.close();
                    continue;
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                statement.close();
                continue;
            }
            break;
        }
        return tableCheckExpressions;
    }

    /*
     * Exception decompiling
     */
    private DbTableUniqueConstraint getTableUniqueConstraint(Connection connectionToH2, String tableName, String constraintCatalog, String constraintSchema, String constraintName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private DbTableCheckExpression getTableCheckExpression(Connection connectionToH2, String tableName, String constraintCatalog, String constraintSchema, String constraintName) throws SQLException {
        Throwable throwable = null;
        try (Statement checkClauseStatement = connectionToH2.createStatement();){
            Throwable throwable2;
            ResultSet checkClauseResultSet;
            block25: {
                DbTableCheckExpression dbTableCheckExpression;
                block26: {
                    block27: {
                        String checkClauseQuery = String.format("SELECT CHECK_CLAUSE FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS WHERE CONSTRAINT_CATALOG='%s' AND CONSTRAINT_SCHEMA='%s' AND CONSTRAINT_NAME='%s' ", constraintCatalog, constraintSchema, constraintName);
                        checkClauseResultSet = checkClauseStatement.executeQuery(checkClauseQuery);
                        throwable2 = null;
                        if (!checkClauseResultSet.next()) break block25;
                        String sqlCheckExpression = checkClauseResultSet.getString("CHECK_CLAUSE");
                        dbTableCheckExpression = new DbTableCheckExpression(tableName, "(" + sqlCheckExpression + ")");
                        if (checkClauseResultSet == null) break block26;
                        if (throwable2 == null) break block27;
                        try {
                            checkClauseResultSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block26;
                    }
                    checkClauseResultSet.close();
                }
                return dbTableCheckExpression;
            }
            try {
                try {
                    try {
                        throw new IllegalArgumentException(String.format("Cannot find constraint such that CONSTRAINT_CATALOG='%s' AND CONSTRAINT_SCHEMA='%s' AND CONSTRAINT_NAME='%s' ", constraintCatalog, constraintSchema, constraintName));
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (checkClauseResultSet != null) {
                        if (throwable2 != null) {
                            try {
                                checkClauseResultSet.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            checkClauseResultSet.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<DbTableConstraint> extractTableConstraintsVersionOneOrLower(Connection connectionToH2, DbSchemaDto schemaDto) throws SQLException {
        ArrayList<DbTableConstraint> tableCheckExpressions = new ArrayList<DbTableConstraint>();
        String tableSchema = schemaDto.name;
        Iterator<TableDto> iterator = schemaDto.tables.iterator();
        block30: while (iterator.hasNext()) {
            TableDto tableDto = iterator.next();
            String tableName = tableDto.name;
            Statement statement = connectionToH2.createStatement();
            Throwable throwable = null;
            try {
                String query = String.format("Select CONSTRAINT_TYPE, CHECK_EXPRESSION, COLUMN_LIST From INFORMATION_SCHEMA.CONSTRAINTS\n where CONSTRAINTS.TABLE_SCHEMA='%s' \n and CONSTRAINTS.TABLE_NAME='%s' ", tableSchema, tableName);
                ResultSet constraints = statement.executeQuery(query);
                Throwable throwable2 = null;
                try {
                    block31: while (true) {
                        String constraintType;
                        if (!constraints.next()) continue block30;
                        switch (constraintType = constraints.getString(CONSTRAINT_TYPE)) {
                            case "UNIQUE": {
                                String columnList = constraints.getString(COLUMN_LIST);
                                List<String> uniqueColumnNames = Arrays.stream(columnList.split(",")).map(String::trim).collect(Collectors.toList());
                                DbTableConstraint constraint = new DbTableUniqueConstraint(tableName, uniqueColumnNames);
                                tableCheckExpressions.add(constraint);
                                continue block31;
                            }
                            case "PRIMARY_KEY": 
                            case "PRIMARY KEY": 
                            case "REFERENTIAL": {
                                continue block31;
                            }
                            case "CHECK": {
                                String sqlCheckExpression = constraints.getString(CHECK_EXPRESSION);
                                DbTableConstraint constraint = new DbTableCheckExpression(tableName, sqlCheckExpression);
                                tableCheckExpressions.add(constraint);
                                continue block31;
                            }
                        }
                        H2ConstraintExtractor.cannotHandle(constraintType);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (constraints == null) continue;
                    if (throwable2 != null) {
                        try {
                            constraints.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    constraints.close();
                    continue;
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                statement.close();
                continue;
            }
            break;
        }
        return tableCheckExpressions;
    }

    private List<DbTableConstraint> extractColumnConstraintsVersion1OrLower(Connection connectionToH2, DbSchemaDto schemaDto, String h2DatabaseVersion) throws SQLException {
        if (H2VersionUtils.isVersionGreaterOrEqual(h2DatabaseVersion, "2.0.0")) {
            throw new IllegalArgumentException("Cannot extract column constraints for H2 version 2 or higher with H2 database version  " + h2DatabaseVersion);
        }
        String tableSchema = schemaDto.name;
        ArrayList<DbTableConstraint> columnConstraints = new ArrayList<DbTableConstraint>();
        for (TableDto tableDto : schemaDto.tables) {
            String tableName = tableDto.name;
            Statement statement = connectionToH2.createStatement();
            Throwable throwable = null;
            try {
                String query = String.format("Select * From INFORMATION_SCHEMA.COLUMNS where COLUMNS.TABLE_SCHEMA='%s' and COLUMNS.TABLE_NAME='%s' ", tableSchema, tableName);
                ResultSet columns = statement.executeQuery(query);
                Throwable throwable2 = null;
                try {
                    while (columns.next()) {
                        String sqlCheckExpression = columns.getString(CHECK_CONSTRAINT);
                        if (sqlCheckExpression == null || sqlCheckExpression.equals("")) continue;
                        DbTableCheckExpression constraint = new DbTableCheckExpression(tableName, sqlCheckExpression);
                        columnConstraints.add(constraint);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (columns == null) continue;
                    if (throwable2 != null) {
                        try {
                            columns.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    columns.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                statement.close();
            }
        }
        return columnConstraints;
    }
}

