/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.BooleanParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.ByteParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.CharParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.DoubleParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.FloatParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.IntParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.LongParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NumericConstraintBase;
import org.evomaster.client.java.controller.problem.rpc.schema.params.ShortParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PrimitiveOrWrapperType;

public abstract class PrimitiveOrWrapperParam<V>
extends NamedTypedValue<PrimitiveOrWrapperType, V>
implements NumericConstraintBase<BigDecimal> {
    private BigDecimal min;
    private BigDecimal max;
    private boolean minInclusive = true;
    private boolean maxInclusive = true;
    private Integer precision;
    private Integer scale;

    public PrimitiveOrWrapperParam(String name, String type, String fullTypeName, Class<?> clazz, AccessibleSchema accessibleSchema) {
        this(name, new PrimitiveOrWrapperType(type, fullTypeName, clazz), accessibleSchema);
    }

    public PrimitiveOrWrapperParam(String name, PrimitiveOrWrapperType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
        this.setNullable(((PrimitiveOrWrapperType)this.getType()).isWrapper);
    }

    public static PrimitiveOrWrapperParam build(String name, Class<?> clazz, AccessibleSchema accessibleSchema) {
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return new IntParam(name, clazz.getSimpleName(), clazz.getName(), clazz, accessibleSchema);
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return new BooleanParam(name, clazz.getSimpleName(), clazz.getName(), clazz, accessibleSchema);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return new DoubleParam(name, clazz.getSimpleName(), clazz.getName(), clazz, accessibleSchema);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return new FloatParam(name, clazz.getSimpleName(), clazz.getName(), clazz, accessibleSchema);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return new LongParam(name, clazz.getSimpleName(), clazz.getName(), clazz, accessibleSchema);
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return new CharParam(name, clazz.getSimpleName(), clazz.getName(), clazz, accessibleSchema);
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return new ByteParam(name, clazz.getSimpleName(), clazz.getName(), clazz, accessibleSchema);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return new ShortParam(name, clazz.getSimpleName(), clazz.getName(), clazz, accessibleSchema);
        }
        throw new RuntimeException("PrimitiveOrWrapperParam: unhandled type " + clazz.getName());
    }

    public static Type getPrimitiveOrWrapper(Type type) {
        if (Integer.class.equals((Object)type)) {
            return Integer.TYPE;
        }
        if (Integer.TYPE.equals(type)) {
            return Integer.class;
        }
        if (Boolean.class.equals((Object)type)) {
            return Boolean.TYPE;
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.class;
        }
        if (Double.class.equals((Object)type)) {
            return Double.TYPE;
        }
        if (Double.TYPE.equals(type)) {
            return Double.class;
        }
        if (Float.class.equals((Object)type)) {
            return Float.TYPE;
        }
        if (Float.TYPE.equals(type)) {
            return Float.class;
        }
        if (Long.class.equals((Object)type)) {
            return Long.TYPE;
        }
        if (Long.TYPE.equals(type)) {
            return Long.class;
        }
        if (Character.class.equals((Object)type)) {
            return Character.TYPE;
        }
        if (Character.TYPE.equals(type)) {
            return Character.class;
        }
        if (Byte.class.equals((Object)type)) {
            return Byte.TYPE;
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.class;
        }
        if (Short.class.equals((Object)type)) {
            return Short.TYPE;
        }
        if (Short.TYPE.equals(type)) {
            return Short.class;
        }
        return type;
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        this.handleConstraintsInCopyDto(dto);
        return dto;
    }

    @Override
    public BigDecimal getMin() {
        return this.min;
    }

    @Override
    public void setMin(BigDecimal min) {
        if (this.min == null || min != null && this.min.compareTo(min) < 0) {
            this.min = min;
        }
    }

    @Override
    public BigDecimal getMax() {
        return this.max;
    }

    @Override
    public void setMax(BigDecimal max) {
        if (this.max == null || max != null && this.max.compareTo(max) > 0) {
            this.max = max;
        }
    }

    @Override
    public Object newInstance() {
        return this.getValue();
    }

    @Override
    public List<String> newInstanceWithJava(boolean isDeclaration, boolean doesIncludeName, String variableName, int indent) {
        String code;
        if (!((PrimitiveOrWrapperType)this.getType()).isWrapper && this.getValue() == null) {
            return Collections.emptyList();
        }
        if (this.accessibleSchema != null && this.accessibleSchema.setterMethodName != null) {
            code = CodeJavaGenerator.oneLineSetterInstance(this.accessibleSchema.setterMethodName, this.getCastType(), variableName, this.getValueAsJavaString());
        } else {
            if (this.accessibleSchema != null && !this.accessibleSchema.isAccessible) {
                throw new IllegalStateException("Error: private field, but there is no setter method");
            }
            code = CodeJavaGenerator.oneLineInstance(isDeclaration, doesIncludeName, ((PrimitiveOrWrapperType)this.getType()).getFullTypeName(), variableName, this.getValueAsJavaString());
        }
        return Collections.singletonList(CodeJavaGenerator.getIndent(indent) + code);
    }

    @Override
    public List<String> newAssertionWithJava(int indent, String responseVarName, int maxAssertionForDataInCollection) {
        StringBuilder sb = new StringBuilder();
        sb.append(CodeJavaGenerator.getIndent(indent));
        if (this.getValue() == null) {
            sb.append(CodeJavaGenerator.junitAssertNull(responseVarName));
        } else {
            sb.append(CodeJavaGenerator.junitAssertEquals(this.getValueAsJavaString(), this.getPrimitiveValue(responseVarName)));
        }
        return Collections.singletonList(sb.toString());
    }

    @Override
    public void setValueBasedOnDto(ParamDto dto) {
        this.setValueBasedOnStringValue(dto.stringValue);
    }

    public Object convertValueTo(Object value) {
        Class<?> type = ((PrimitiveOrWrapperType)this.getType()).getClazz();
        String s = value.toString();
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return Integer.valueOf(s);
        }
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            return Boolean.valueOf(s);
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return Double.valueOf(s);
        }
        if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            return Float.valueOf(s);
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return Long.valueOf(value.toString());
        }
        if (Character.class.equals(type) || Character.TYPE.equals(type)) {
            if (s.length() != 1) {
                throw new IllegalArgumentException("it cannot be recognized as a char:" + s);
            }
            return Character.valueOf(s.charAt(0));
        }
        if (Byte.class.equals(type) || Byte.TYPE.equals(type)) {
            return Byte.valueOf(s);
        }
        if (Short.class.equals(type) || Short.TYPE.equals(type)) {
            return Short.valueOf(s);
        }
        throw new RuntimeException("cannot find the type:" + type);
    }

    public abstract void setValueBasedOnStringValue(String var1);

    public abstract String getPrimitiveValue(String var1);

    @Override
    public void copyProperties(NamedTypedValue copy) {
        super.copyProperties(copy);
        if (copy instanceof PrimitiveOrWrapperParam) {
            ((PrimitiveOrWrapperParam)copy).setMin(this.min);
            ((PrimitiveOrWrapperParam)copy).setMax(this.max);
        }
        this.handleConstraintsInCopy(copy);
    }

    public String getCastType() {
        return null;
    }

    @Override
    public boolean getMinInclusive() {
        return this.minInclusive;
    }

    @Override
    public void setMinInclusive(boolean inclusive) {
        this.minInclusive = inclusive;
    }

    @Override
    public boolean getMaxInclusive() {
        return this.maxInclusive;
    }

    @Override
    public void setMaxInclusive(boolean inclusive) {
        this.maxInclusive = inclusive;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public void setScale(Integer scale) {
        this.scale = scale;
    }
}

