/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCSupportedDataType;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.CollectionParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.CollectionType;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;

public class SetParam
extends CollectionParam<Set<NamedTypedValue>> {
    public SetParam(String name, CollectionType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    @Override
    public Object newInstance() throws ClassNotFoundException {
        if (this.getValue() == null) {
            return null;
        }
        return ((Set)this.getValue()).stream().map(v -> {
            try {
                return v.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("ArrayParam: could not create new instance for value:" + v.getType());
            }
        }).collect(Collectors.toSet());
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        dto.type.type = RPCSupportedDataType.SET;
        if (this.getValue() != null) {
            dto.innerContent = ((Set)this.getValue()).stream().map(s -> s.getDto()).collect(Collectors.toList());
        }
        return dto;
    }

    public SetParam copyStructure() {
        return new SetParam(this.getName(), (CollectionType)this.getType(), this.accessibleSchema);
    }

    @Override
    public void setValueBasedOnDto(ParamDto dto) {
        if (dto.innerContent != null && !dto.innerContent.isEmpty()) {
            NamedTypedValue t = ((CollectionType)this.getType()).getTemplate();
            Set values = dto.innerContent.stream().map(s -> {
                NamedTypedValue v = t.copyStructureWithProperties();
                v.setValueBasedOnDto((ParamDto)s);
                return v;
            }).collect(Collectors.toSet());
            this.setValue(values);
        }
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        NamedTypedValue t = ((CollectionType)this.getType()).getTemplate();
        LinkedHashSet values = new LinkedHashSet();
        for (Object e : (Set)instance) {
            NamedTypedValue copy = t.copyStructureWithProperties();
            copy.setValueBasedOnInstance(e);
            values.add(copy);
        }
        this.setValue(values);
    }

    @Override
    public void setValueBasedOnInstanceOrJson(Object json) throws JsonProcessingException {
        Object instance = json;
        if (json instanceof String) {
            instance = this.parseValueWithJson((String)json);
        }
        if (instance == null) {
            this.setValue(null);
            return;
        }
        if (!this.isValidInstance(instance)) {
            throw new RuntimeException("cannot parse Set param " + this.getName() + " with the type " + json.getClass().getName());
        }
        NamedTypedValue t = ((CollectionType)this.getType()).getTemplate();
        LinkedHashSet values = new LinkedHashSet();
        for (Object e : (Set)instance) {
            NamedTypedValue copy = t.copyStructureWithProperties();
            copy.setValueBasedOnInstanceOrJson(e);
            values.add(copy);
        }
        this.setValue(values);
    }

    @Override
    public List<String> newInstanceWithJava(boolean isDeclaration, boolean doesIncludeName, String variableName, int indent) {
        String fullName = ((CollectionType)this.getType()).getTypeNameForInstance();
        ArrayList<String> codes = new ArrayList<String>();
        String var = CodeJavaGenerator.oneLineInstance(isDeclaration, doesIncludeName, fullName, variableName, null);
        CodeJavaGenerator.addCode(codes, var, indent);
        if (this.getValue() == null) {
            return codes;
        }
        CodeJavaGenerator.addCode(codes, "{", indent);
        CodeJavaGenerator.addCode(codes, CodeJavaGenerator.setInstance(variableName, CodeJavaGenerator.newSet()), indent + 1);
        int index = 0;
        for (NamedTypedValue e : (Set)this.getValue()) {
            String eVarName = CodeJavaGenerator.handleVariableName(variableName + "_e_" + index);
            codes.addAll(e.newInstanceWithJava(true, true, eVarName, indent + 1));
            CodeJavaGenerator.addCode(codes, variableName + ".add(" + eVarName + ");", indent + 1);
            ++index;
        }
        CodeJavaGenerator.addCode(codes, "}", indent);
        return codes;
    }

    @Override
    public List<String> newAssertionWithJava(int indent, String responseVarName, int maxAssertionForDataInCollection) {
        ArrayList<String> codes = new ArrayList<String>();
        if (this.getValue() == null) {
            CodeJavaGenerator.addCode(codes, CodeJavaGenerator.junitAssertNull(responseVarName), indent);
            return codes;
        }
        CodeJavaGenerator.addCode(codes, CodeJavaGenerator.junitAssertEquals("" + ((Set)this.getValue()).size(), CodeJavaGenerator.withSize(responseVarName)), indent);
        return codes;
    }

    @Override
    public String getValueAsJavaString() {
        return null;
    }
}

