/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.evomaster.client.java.instrumentation.JpaConstraint;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;
import org.evomaster.client.java.utils.SimpleLogger;

public class ClassAnalyzer {
    public static void doAnalyze(Collection<String> classNames) {
        boolean jpa = ClassAnalyzer.canUseJavaxJPA();
        for (String name : classNames) {
            Class<?> klass;
            try {
                ClassLoader loader = UnitsInfoRecorder.getInstance().getFirstClassLoader(name);
                if (loader == null) {
                    loader = ClassAnalyzer.class.getClassLoader();
                    SimpleLogger.warn("No class loader registered for " + name);
                }
                klass = loader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                SimpleLogger.error("Failed to load class " + name, e);
                continue;
            }
            try {
                if (!jpa) continue;
                ClassAnalyzer.analyzeJpaConstraints(klass);
            }
            catch (Exception e) {
                SimpleLogger.error("Failed to analyze " + name, e);
            }
        }
    }

    private static boolean canUseJavaxJPA() {
        try {
            ClassLoader loader = UnitsInfoRecorder.getInstance().getSutClassLoader();
            if (loader == null) {
                SimpleLogger.warn("No identified ClassLoader for SUT");
                loader = ClassAnalyzer.class.getClassLoader();
            }
            loader.loadClass("javax.persistence.Entity");
            loader.loadClass("javax.validation.constraints.NotNull");
            return true;
        }
        catch (ClassNotFoundException e) {
            SimpleLogger.info("Not analyzing JPA using javax package");
            return false;
        }
    }

    private static Annotation getAnnotationByName(Class<?> klass, String name) {
        return ClassAnalyzer.getAnnotationByName(klass.getAnnotations(), name);
    }

    private static Annotation getAnnotationByName(Field field, String name) {
        return ClassAnalyzer.getAnnotationByName(field.getAnnotations(), name);
    }

    private static Annotation getAnnotationByName(Annotation[] annotations, String name) {
        return Arrays.stream(annotations).filter(a -> a.annotationType().getName().equals(name)).findFirst().orElse(null);
    }

    private static String convertToSnakeCase(String s) {
        String regex = "([a-z])([A-Z]+)";
        String replacement = "$1_$2";
        return s.replaceAll(regex, replacement).toLowerCase();
    }

    private static void analyzeJpaConstraints(Class<?> klass) throws Exception {
        Annotation entity = ClassAnalyzer.getAnnotationByName(klass, "javax.persistence.Entity");
        if (entity == null) {
            return;
        }
        String entityName = (String)entity.getClass().getMethod("name", new Class[0]).invoke((Object)entity, new Object[0]);
        Annotation table = ClassAnalyzer.getAnnotationByName(klass, "javax.persistence.Table");
        String tableName = table != null ? (String)table.getClass().getMethod("name", new Class[0]).invoke((Object)table, new Object[0]) : (entityName != null && !entityName.isEmpty() ? entityName : klass.getSimpleName());
        tableName = ClassAnalyzer.convertToSnakeCase(tableName);
        for (Field f : klass.getDeclaredFields()) {
            String maxValue;
            String minValue;
            Boolean isOptional;
            JpaConstraint jpaConstraint;
            if (Modifier.isStatic(f.getModifiers()) || ClassAnalyzer.getAnnotationByName(f, "javax.persistence.Transient") != null) continue;
            String columnName = null;
            Annotation column = ClassAnalyzer.getAnnotationByName(f, "javax.persistence.Column");
            if (column != null) {
                columnName = (String)column.getClass().getMethod("name", new Class[0]).invoke((Object)column, new Object[0]);
            }
            if (columnName == null || columnName.isEmpty()) {
                columnName = f.getName();
            }
            columnName = ClassAnalyzer.convertToSnakeCase(columnName);
            Boolean isNullable = null;
            if (f.getType().isPrimitive() || ClassAnalyzer.getAnnotationByName(f, "javax.validation.constraints.NotNull") != null) {
                isNullable = false;
            }
            List enumValuesAsStrings = null;
            if (f.getType().isEnum()) {
                Annotation enumerated = ClassAnalyzer.getAnnotationByName(f, "javax.persistence.Enumerated");
                Object enumeratedValue = enumerated.getClass().getMethod("value", new Class[0]).invoke((Object)enumerated, new Object[0]);
                String enumTypeString = "STRING".toLowerCase();
                if (enumerated != null && enumeratedValue.toString().toLowerCase().equals(enumTypeString)) {
                    enumValuesAsStrings = Arrays.stream(f.getType().getEnumConstants()).map(e -> e.toString()).collect(Collectors.toList());
                }
            }
            if (!(jpaConstraint = new JpaConstraint(tableName, columnName, isNullable, isOptional = null, minValue = null, maxValue = null, enumValuesAsStrings)).isMeaningful()) continue;
            UnitsInfoRecorder.registerNewJpaConstraint(jpaConstraint);
        }
    }
}

