/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.evomaster.client.java.instrumentation.object.ClassToSchema;
import org.evomaster.client.java.utils.SimpleLogger;

public class ExtractJvmClass {
    public static Map<String, String> extractAsSchema(List<String> jvmDtoNames) {
        LinkedHashMap<String, String> schemas = new LinkedHashMap<String, String>();
        for (String dtoName : jvmDtoNames) {
            try {
                if (schemas.containsKey(dtoName)) {
                    SimpleLogger.uniqueWarn("duplicated dto name:" + dtoName);
                    continue;
                }
                Class<?> clazz = Class.forName(dtoName);
                schemas.putAll(ClassToSchema.getOrDeriveSchemaAndNestedClasses(clazz));
            }
            catch (ClassNotFoundException e) {
                SimpleLogger.uniqueWarn("Fail to extract Jvm DTO as schema:" + e.getMessage());
            }
        }
        return schemas;
    }
}

