/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage;

import org.evomaster.client.java.instrumentation.Constants;
import org.evomaster.client.java.instrumentation.coverage.MethodReplacementMethodVisitor;
import org.evomaster.client.java.instrumentation.shared.ClassName;
import shaded.org.objectweb.asm.ClassVisitor;
import shaded.org.objectweb.asm.MethodVisitor;
import shaded.org.objectweb.asm.commons.JSRInlinerAdapter;

public class ThirdPartyClassVisitor
extends ClassVisitor {
    private final String bytecodeClassName;

    public ThirdPartyClassVisitor(ClassVisitor cv, ClassName className) {
        super(458752, cv);
        this.bytecodeClassName = className.getBytecodeName();
    }

    @Override
    public MethodVisitor visitMethod(int methodAccess, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(methodAccess, name, descriptor, signature, exceptions);
        mv = new JSRInlinerAdapter(mv, methodAccess, name, descriptor, signature, exceptions);
        if (Constants.isMethodSyntheticOrBridge(methodAccess)) {
            return mv;
        }
        if (name.equals("<clinit>")) {
            return mv;
        }
        mv = new MethodReplacementMethodVisitor(false, false, mv, this.bytecodeClassName, name, descriptor);
        return mv;
    }
}

