/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import org.evomaster.client.java.instrumentation.ExternalServiceInfo;
import org.evomaster.client.java.instrumentation.shared.ExternalServiceSharedUtils;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class ExternalServiceInfoUtils {
    public static String[] collectExternalServiceInfo(ExternalServiceInfo remoteHostInfo, int remotePort) {
        ExecutionTracer.addExternalServiceHost(remoteHostInfo);
        if (!ExecutionTracer.hasMockServer(remoteHostInfo.getHostname())) {
            String signature = remoteHostInfo.signature();
            int connectPort = remotePort;
            if (!ExecutionTracer.hasExternalMapping(remoteHostInfo.signature())) {
                ExecutionTracer.addEmployedDefaultWMHost(remoteHostInfo);
                signature = ExternalServiceSharedUtils.getWMDefaultSignature(remoteHostInfo.getProtocol(), remotePort);
                connectPort = ExternalServiceSharedUtils.getDefaultWMPort(signature);
            }
            return new String[]{ExecutionTracer.getExternalMapping(signature), "" + connectPort};
        }
        return new String[]{remoteHostInfo.getHostname(), "" + remotePort};
    }

    public static boolean skipHostnameOrIp(String hostname) {
        return hostname.isEmpty() || hostname.startsWith("localhost") || hostname.startsWith("0.0.0") || hostname.startsWith("10.") || hostname.startsWith("docker.socket") || hostname.startsWith("127.") && !ExecutionTracer.hasLocalAddressReplacement(hostname);
    }

    public static int inferPort(int port, String protocol) {
        if (port >= 0) {
            return port;
        }
        switch (protocol) {
            case "https": {
                return 443;
            }
            case "http": {
                return 80;
            }
        }
        return port;
    }
}

