/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Pattern;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.regex.CostMatrix;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.regex.RegexGraph;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.regex.RegexUtils;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.utils.SimpleLogger;

public class RegexDistanceUtils {
    private static final Map<String, Pattern> patternCache = new ConcurrentHashMap<String, Pattern>();
    private static final Set<String> notSupported = new CopyOnWriteArraySet<String>();
    private static final Map<String, Map<String, RegexGraph>> graphCache = new ConcurrentHashMap<String, Map<String, RegexGraph>>();

    public static int getStandardDistance(String arg, String regex) {
        if (!RegexUtils.isSupportedRegex(regex) || notSupported.contains(regex) || ExecutionTracer.isTooManyExpensiveOperations()) {
            return RegexDistanceUtils.getDefaultDistance(arg, regex);
        }
        RegexGraph graph = null;
        Map<String, RegexGraph> graphs = graphCache.get(regex);
        if (graphs != null) {
            graph = graphs.get(arg);
        }
        try {
            if (graph == null) {
                graph = new RegexGraph(arg, regex);
                if (graphs == null) {
                    graphs = new ConcurrentHashMap<String, RegexGraph>();
                    graphs.put(regex, graph);
                }
                graphs.put(arg, graph);
            }
        }
        catch (Exception e) {
            SimpleLogger.uniqueWarn("Failed to build graph for regex: " + regex);
            notSupported.add(regex);
            return RegexDistanceUtils.getDefaultDistance(arg, regex);
        }
        try {
            ExecutionTracer.increaseExpensiveOperationCount();
            return CostMatrix.calculateStandardCost(graph);
        }
        catch (Exception e) {
            SimpleLogger.uniqueWarn("Failed to compute distance cost for regex: " + regex);
            notSupported.add(regex);
            return RegexDistanceUtils.getDefaultDistance(arg, regex);
        }
    }

    private static int getDefaultDistance(String arg, String regex) {
        Pattern p = patternCache.get(regex);
        if (p == null) {
            p = Pattern.compile(regex);
            patternCache.put(regex, p);
        }
        if (p.matcher(arg).matches()) {
            return 0;
        }
        return 1;
    }
}

