/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.evomaster.client.java.instrumentation.ExternalServiceInfo;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ExternalServiceInfoUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class InetAddressClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return InetAddress.class;
    }

    @Replacement(type=ReplacementType.TRACKER, category=ReplacementCategory.NET, replacingStatic=true, usageFilter=UsageFilter.ANY)
    public static InetAddress getByName(String host) throws UnknownHostException {
        if (ExternalServiceInfoUtils.skipHostnameOrIp(host) || ExecutionTracer.skipHostname(host)) {
            return InetAddress.getByName(host);
        }
        try {
            if (ExecutionTracer.hasLocalAddress(host)) {
                String ip = ExecutionTracer.getLocalAddress(host);
                return InetAddress.getByName(ip);
            }
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            ExternalServiceInfo remoteHostInfo = new ExternalServiceInfo("TCP", host, -1);
            ExecutionTracer.addExternalServiceHost(remoteHostInfo);
            throw e;
        }
    }

    @Replacement(type=ReplacementType.TRACKER, category=ReplacementCategory.NET, replacingStatic=true, usageFilter=UsageFilter.ANY)
    public static InetAddress[] getAllByName(String host) throws UnknownHostException {
        if (ExternalServiceInfoUtils.skipHostnameOrIp(host) || ExecutionTracer.skipHostname(host)) {
            return InetAddress.getAllByName(host);
        }
        try {
            if (ExecutionTracer.hasLocalAddress(host)) {
                String ip = ExecutionTracer.getLocalAddress(host);
                return new InetAddress[]{InetAddress.getByName(ip)};
            }
            return InetAddress.getAllByName(host);
        }
        catch (UnknownHostException e) {
            ExternalServiceInfo remoteHostInfo = new ExternalServiceInfo("TCP", host, -1);
            ExecutionTracer.addExternalServiceHost(remoteHostInfo);
            throw e;
        }
    }
}

