/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ReplacementList;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ReplacementUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;

public class MethodClassReplacement
implements MethodReplacementClass {
    private static final Set<String> toSkipCache = new CopyOnWriteArraySet<String>();
    private static final Map<String, Method> methodCache = Collections.synchronizedMap(new HashMap());

    @Override
    public Class<?> getTargetClass() {
        return Method.class;
    }

    @Replacement(type=ReplacementType.TRACKER, category=ReplacementCategory.EXT_0, usageFilter=UsageFilter.ONLY_SUT, packagesToSkip={".fasterxml.jackson.", "org.springframework.", "ch.qos.logback.", "org.apache.tomcat.util.", "org.jboss.logging", "net.sf.ehcache.config"}, extraPackagesToConsider={"org.apache.tomcat.jdbc."})
    public static Object invoke(Method caller, Object obj, Object ... args) throws InvocationTargetException, IllegalAccessException {
        if (caller == null) {
            return caller.invoke(obj, args);
        }
        caller.setAccessible(true);
        String targetClassName = caller.getDeclaringClass().getName();
        if (toSkipCache.contains(targetClassName)) {
            return caller.invoke(obj, args);
        }
        List<MethodReplacementClass> candidateClasses = ReplacementList.getReplacements(targetClassName, true);
        if (candidateClasses.isEmpty()) {
            toSkipCache.add(targetClassName);
            return caller.invoke(obj, args);
        }
        String name = caller.getName();
        String desc = ReplacementUtils.getDescriptor(caller, 0, 0);
        String id = targetClassName + "." + name + desc;
        Method replacement = null;
        if (methodCache.containsKey(id)) {
            replacement = methodCache.get(id);
        } else {
            boolean isInSUT = false;
            String contextClassName = null;
            Optional<Method> r = ReplacementUtils.chooseMethodFromCandidateReplacement(isInSUT, name, desc, candidateClasses, false, contextClassName);
            replacement = r.orElse(null);
            methodCache.put(id, replacement);
        }
        if (replacement == null) {
            return caller.invoke(obj, args);
        }
        Replacement br = replacement.getAnnotation(Replacement.class);
        LinkedList<Object> tmp = new LinkedList<Object>();
        if (args != null) {
            tmp.addAll(Arrays.asList(args));
        }
        if (!br.replacingStatic()) {
            tmp.add(0, obj);
        }
        if (br.type() != ReplacementType.TRACKER) {
            tmp.add(null);
        }
        return replacement.invoke(null, tmp.toArray());
    }
}

