/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.object;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;
import org.evomaster.client.java.utils.SimpleLogger;

public class ClassToSchema {
    private static final Map<Type, String> cacheSchema = new ConcurrentHashMap<Type, String>();
    private static final Map<Type, String> cacheSchemaWithItsRef = new ConcurrentHashMap<Type, String>();
    private static final Map<Type, Map<String, String>> cacheMapOfDtoAndItsRefToSchemas = new ConcurrentHashMap<Type, Map<String, String>>();
    private static final String fieldRefPrefix = "{\"$ref\":\"";
    private static final String fieldRefPostfix = "\"}";

    public static void registerSchemaIfNeeded(Class<?> valueType) {
        if (valueType == null) {
            return;
        }
        if (valueType.getName().startsWith("io.swagger.")) {
            return;
        }
        try {
            String name = valueType.getName();
            if (!UnitsInfoRecorder.isDtoSchemaRegister(name).booleanValue()) {
                ArrayList embedded = new ArrayList();
                String schema = ClassToSchema.getOrDeriveSchema(valueType, embedded);
                UnitsInfoRecorder.registerNewParsedDto(name, schema);
                ExecutionTracer.addParsedDtoName(name);
                if (!embedded.isEmpty()) {
                    embedded.forEach(ClassToSchema::registerSchemaIfNeeded);
                }
            }
        }
        catch (Exception e) {
            SimpleLogger.warn("Fail to get schema for Class:" + valueType.getName(), e);
        }
    }

    public static String getOrDeriveSchemaWithItsRef(Class<?> klass) {
        if (!cacheSchemaWithItsRef.containsKey(klass)) {
            StringBuilder sb = new StringBuilder();
            Map<String, String> map = ClassToSchema.getOrDeriveSchemaAndNestedClasses(klass);
            sb.append("{");
            sb.append(map.get(klass.getName()));
            map.keySet().stream().filter(s -> !s.equals(klass.getName())).forEach(s -> sb.append(",").append((String)map.get(s)));
            sb.append("}");
            cacheSchemaWithItsRef.put(klass, ClassToSchema.named(klass.getName(), sb.toString()));
        }
        return cacheSchemaWithItsRef.get(klass);
    }

    public static String getOrDeriveNonNestedSchema(Class<?> klass) {
        return ClassToSchema.getOrDeriveSchema(klass, Collections.emptyList());
    }

    public static String getOrDeriveSchema(Class<?> klass, List<Class<?>> nested) {
        if (!cacheSchema.containsKey(klass)) {
            cacheSchema.put(klass, ClassToSchema.getOrDeriveSchema(klass.getName(), klass, false, nested));
        }
        return cacheSchema.get(klass);
    }

    private static String getOrDeriveSchema(String name, Type type, Boolean useRefObject, List<Class<?>> nested) {
        if (cacheSchema.containsKey(type) && !useRefObject.booleanValue() && !ClassToSchema.isCollectionOrMap(type)) {
            return cacheSchema.get(type);
        }
        String schema = ClassToSchema.getSchema(type, useRefObject, nested, false);
        String namedSchema = ClassToSchema.named(name, schema);
        if (!schema.startsWith(fieldRefPrefix) && !ClassToSchema.isCollectionOrMap(type)) {
            cacheSchema.put(type, namedSchema);
        }
        return namedSchema;
    }

    private static boolean isCollectionOrMap(Type type) {
        if (!(type instanceof Class)) {
            return false;
        }
        Class kclazz = (Class)type;
        return kclazz.isArray() || List.class.isAssignableFrom(kclazz) || Set.class.isAssignableFrom(kclazz) || Map.class.isAssignableFrom(kclazz);
    }

    public static Map<String, String> getOrDeriveSchemaAndNestedClasses(Class<?> klass) {
        if (!cacheMapOfDtoAndItsRefToSchemas.containsKey(klass)) {
            ArrayList nested = new ArrayList();
            ClassToSchema.registerSchemaIfNeeded(klass);
            ClassToSchema.findAllNestedClassAndRegisterThemIfNeeded(klass, nested);
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (Class clazz : nested) {
                map.putIfAbsent(clazz.getName(), ClassToSchema.getOrDeriveNonNestedSchema(clazz));
            }
            cacheMapOfDtoAndItsRefToSchemas.put(klass, map);
        }
        return cacheMapOfDtoAndItsRefToSchemas.get(klass);
    }

    private static void findAllNestedClassAndRegisterThemIfNeeded(Class<?> klass, List<Class<?>> nested) {
        if (!nested.contains(klass)) {
            ArrayList innerNested = new ArrayList();
            ClassToSchema.getSchema(klass, false, innerNested, true);
            nested.add(klass);
            List<Class> toAdd = innerNested.stream().filter(s -> !nested.contains(s)).collect(Collectors.toList());
            if (toAdd.isEmpty()) {
                return;
            }
            toAdd.forEach(a -> ClassToSchema.findAllNestedClassAndRegisterThemIfNeeded(a, nested));
        }
    }

    private static String named(String name, String jsonObject) {
        return "\"" + name + "\":" + jsonObject;
    }

    private static String getSchema(Type type, Boolean useRefObject, List<Class<?>> nested, boolean allNested) {
        Class klass = null;
        if (type instanceof Class) {
            klass = (Class)type;
        }
        ParameterizedType pType = null;
        if (type instanceof ParameterizedType) {
            pType = (ParameterizedType)type;
        }
        if (klass != null) {
            if (klass.isEnum()) {
                String[] items = (String[])Arrays.stream(klass.getEnumConstants()).map(e -> ClassToSchema.getNameEnumConstant(e)).toArray(String[]::new);
                return ClassToSchema.fieldEnumSchema(items);
            }
            if (String.class.isAssignableFrom(klass)) {
                return ClassToSchema.fieldSchema("string");
            }
            if (Byte.class.isAssignableFrom(klass) || Byte.TYPE == klass) {
                return ClassToSchema.fieldSchema("integer", "int8");
            }
            if (Short.class.isAssignableFrom(klass) || Short.TYPE == klass) {
                return ClassToSchema.fieldSchema("integer", "int16");
            }
            if (Integer.class.isAssignableFrom(klass) || Integer.TYPE == klass) {
                return ClassToSchema.fieldSchema("integer", "int32");
            }
            if (Long.class.isAssignableFrom(klass) || Long.TYPE == klass) {
                return ClassToSchema.fieldSchema("integer", "int64");
            }
            if (Float.class.isAssignableFrom(klass) || Float.TYPE == klass) {
                return ClassToSchema.fieldSchema("number", "float");
            }
            if (Double.class.isAssignableFrom(klass) || Double.TYPE == klass) {
                return ClassToSchema.fieldSchema("number", "double");
            }
            if (Boolean.class.isAssignableFrom(klass) || Boolean.TYPE == klass) {
                return ClassToSchema.fieldSchema("boolean");
            }
            if (BigDecimal.class.isAssignableFrom(klass)) {
                return ClassToSchema.fieldSchema("integer", "int64");
            }
        }
        if (klass != null && (klass.isArray() || List.class.isAssignableFrom(klass) || Set.class.isAssignableFrom(klass)) || pType != null && (List.class.isAssignableFrom((Class)pType.getRawType()) || Set.class.isAssignableFrom((Class)pType.getRawType()))) {
            return ClassToSchema.fieldArraySchema(klass, pType, nested, allNested);
        }
        if (klass != null && Map.class.isAssignableFrom(klass) || pType != null && Map.class.isAssignableFrom((Class)pType.getRawType())) {
            Type keyType;
            if (pType != null && pType.getActualTypeArguments().length > 0 && (keyType = pType.getActualTypeArguments()[0]) != String.class) {
                throw new IllegalStateException("only support Map with String key");
            }
            return ClassToSchema.fieldStringKeyMapSchema(klass, pType, nested, allNested);
        }
        if (useRefObject.booleanValue()) {
            if (!(!allNested && UnitsInfoRecorder.isDtoSchemaRegister(klass.getName()).booleanValue() || nested.contains(klass))) {
                nested.add(klass);
            }
            return ClassToSchema.fieldObjectRefSchema(klass.getName());
        }
        ArrayList<String> properties = new ArrayList<String>();
        for (Class target = klass; target != null; target = target.getSuperclass()) {
            for (Field f : target.getDeclaredFields()) {
                if (!ClassToSchema.shouldAddToSchema(f)) continue;
                String fieldName = ClassToSchema.getName(f);
                String fieldSchema = null;
                fieldSchema = allNested ? ClassToSchema.named(fieldName, ClassToSchema.getSchema(f.getGenericType(), true, nested, true)) : ClassToSchema.getOrDeriveSchema(fieldName, f.getGenericType(), true, nested);
                properties.add(fieldSchema);
            }
        }
        return ClassToSchema.fieldObjectSchema(properties);
    }

    private static boolean shouldAddToSchema(Field field) {
        if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) {
            return false;
        }
        for (Annotation a : field.getAnnotations()) {
            String name = a.annotationType().getSimpleName();
            if (!name.equalsIgnoreCase("Ignore") && !name.equalsIgnoreCase("Ignored") && !name.equalsIgnoreCase("Exclude") && !name.equalsIgnoreCase("Excluded") && !name.equalsIgnoreCase("JsonIgnore") && !name.equalsIgnoreCase("Skip") && !name.equalsIgnoreCase("Transient")) continue;
            return false;
        }
        return true;
    }

    private static String getName(Field field) {
        for (Annotation a : field.getAnnotations()) {
            String name = a.annotationType().getName();
            if (!name.equals("shaded.com.fasterxml.jackson.annotation.JsonProperty") && !name.equals("com.google.gson.annotations.SerializedName")) continue;
            try {
                Method m = a.annotationType().getMethod("value", new Class[0]);
                String value = (String)m.invoke((Object)a, new Object[0]);
                if (value == null || value.isEmpty()) continue;
                return value;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return field.getName();
    }

    private static String fieldArraySchema(Class<?> klass, ParameterizedType pType, List<Class<?>> embedded, boolean allEmbedded) {
        String item;
        if (klass != null) {
            item = klass.isArray() ? ClassToSchema.getSchema(klass.getComponentType(), true, embedded, allEmbedded) : ClassToSchema.getSchema(String.class, true, embedded, allEmbedded);
        } else {
            Type generic = pType.getActualTypeArguments()[0];
            item = ClassToSchema.getSchema(generic, true, embedded, allEmbedded);
        }
        return "{\"type\":\"array\", \"items\":" + item + "}";
    }

    private static String fieldStringKeyMapSchema(Class<?> klass, ParameterizedType pType, List<Class<?>> embedded, boolean allEmbedded) {
        String value;
        if (klass != null) {
            value = ClassToSchema.getSchema(String.class, true, embedded, allEmbedded);
        } else {
            Type generic = pType.getActualTypeArguments()[1];
            value = ClassToSchema.getSchema(generic, true, embedded, allEmbedded);
        }
        return "{\"type\":\"object\", \"additionalProperties\":" + value + "}";
    }

    private static String fieldObjectSchema(List<String> properties) {
        String p = properties.stream().collect(Collectors.joining(","));
        return "{\"type\":\"object\", \"properties\": {" + p + "}}";
    }

    private static String fieldObjectRefSchema(String name) {
        return "{\"$ref\":\"#/components/schemas/" + name + fieldRefPostfix;
    }

    private static String fieldSchema(String type) {
        return "{\"type\":\"" + type + fieldRefPostfix;
    }

    private static String fieldSchema(String type, String format) {
        return "{\"type\":\"" + type + "\", \"format\":\"" + format + fieldRefPostfix;
    }

    private static String fieldEnumSchema(String[] items) {
        return "{\"type\":\"string\", \"enum\":[" + Arrays.stream(items).map(s -> "\"" + s + "\"").collect(Collectors.joining(",")) + "]}";
    }

    private static String getNameEnumConstant(Object object) {
        try {
            Method name = object.getClass().getMethod("name", new Class[0]);
            name.setAccessible(true);
            return (String)name.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            SimpleLogger.warn("Driver Error: fail to extract name for enum constant", e);
            return object.toString();
        }
    }
}

