/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.shared;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class PreDefinedSSLInfo {
    private static final PreDefinedSSLInfo singleton = new PreDefinedSSLInfo();
    private final SSLContext sslContext = this.sslContext();

    public static HostnameVerifier allowAllHostNames() {
        return (hostname, sslSession) -> true;
    }

    private SSLContext sslContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{TrustAllX509TrustManager.singleton}, null);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static SSLContext getSSLContext() {
        return PreDefinedSSLInfo.singleton.sslContext;
    }

    public static SSLSocketFactory getTrustAllSSLSocketFactory() {
        return PreDefinedSSLInfo.singleton.sslContext.getSocketFactory();
    }

    public static X509TrustManager getTrustAllX509TrustManager() {
        return TrustAllX509TrustManager.singleton;
    }

    public static void setTrustAllForHttpsURLConnection() {
        HttpsURLConnection.setDefaultSSLSocketFactory(PreDefinedSSLInfo.getTrustAllSSLSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(PreDefinedSSLInfo.allowAllHostNames());
    }

    private static class TrustAllX509TrustManager
    implements X509TrustManager {
        public static final X509TrustManager singleton = new TrustAllX509TrustManager();

        private TrustAllX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

