/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.expression.operators.relational;

import java.util.Objects;
import shaded.net.sf.jsqlparser.expression.BinaryExpression;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.ExpressionVisitor;
import shaded.net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperatorType;

public class RegExpMySQLOperator
extends BinaryExpression {
    private RegExpMatchOperatorType operatorType;
    private boolean useRLike = false;
    private boolean not = false;

    public RegExpMySQLOperator(RegExpMatchOperatorType operatorType) {
        this(false, operatorType);
    }

    public RegExpMySQLOperator(boolean not, RegExpMatchOperatorType operatorType) {
        this.operatorType = Objects.requireNonNull(operatorType, "The provided RegExpMatchOperatorType must not be NULL.");
        this.not = not;
    }

    public boolean isNot() {
        return this.not;
    }

    public void setNot(boolean not) {
        this.not = not;
    }

    public RegExpMatchOperatorType getOperatorType() {
        return this.operatorType;
    }

    public boolean isUseRLike() {
        return this.useRLike;
    }

    public RegExpMySQLOperator useRLike() {
        this.useRLike = true;
        return this;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    @Override
    public String getStringExpression() {
        return (this.not ? "NOT " : "") + (this.useRLike ? "RLIKE" : "REGEXP") + (this.operatorType == RegExpMatchOperatorType.MATCH_CASESENSITIVE ? " BINARY" : "");
    }

    @Override
    public RegExpMySQLOperator withLeftExpression(Expression arg0) {
        return (RegExpMySQLOperator)super.withLeftExpression(arg0);
    }

    @Override
    public RegExpMySQLOperator withRightExpression(Expression arg0) {
        return (RegExpMySQLOperator)super.withRightExpression(arg0);
    }
}

