/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import shaded.net.sf.jsqlparser.expression.Alias;
import shaded.net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import shaded.net.sf.jsqlparser.statement.select.FromItem;
import shaded.net.sf.jsqlparser.statement.select.FromItemVisitor;
import shaded.net.sf.jsqlparser.statement.select.Pivot;
import shaded.net.sf.jsqlparser.statement.select.PlainSelect;
import shaded.net.sf.jsqlparser.statement.select.UnPivot;

public class ValuesList
implements FromItem {
    private Alias alias;
    private MultiExpressionList multiExpressionList;
    private boolean noBrackets = false;
    private List<String> columnNames;

    public ValuesList() {
    }

    public ValuesList(MultiExpressionList multiExpressionList) {
        this.multiExpressionList = multiExpressionList;
    }

    @Override
    public void accept(FromItemVisitor fromItemVisitor) {
        fromItemVisitor.visit(this);
    }

    @Override
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    @Override
    public Pivot getPivot() {
        return null;
    }

    @Override
    public void setPivot(Pivot pivot) {
    }

    @Override
    public UnPivot getUnPivot() {
        return null;
    }

    @Override
    public void setUnPivot(UnPivot unpivot) {
    }

    public MultiExpressionList getMultiExpressionList() {
        return this.multiExpressionList;
    }

    public void setMultiExpressionList(MultiExpressionList multiExpressionList) {
        this.multiExpressionList = multiExpressionList;
    }

    public boolean isNoBrackets() {
        return this.noBrackets;
    }

    public void setNoBrackets(boolean noBrackets) {
        this.noBrackets = noBrackets;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("(VALUES ");
        Iterator<Object> it = this.getMultiExpressionList().getExprList().iterator();
        while (it.hasNext()) {
            b.append(PlainSelect.getStringList(it.next().getExpressions(), true, !this.isNoBrackets()));
            if (!it.hasNext()) continue;
            b.append(", ");
        }
        b.append(")");
        if (this.alias != null) {
            b.append(this.alias.toString());
            if (this.columnNames != null) {
                b.append("(");
                it = this.columnNames.iterator();
                while (it.hasNext()) {
                    b.append((String)it.next());
                    if (!it.hasNext()) continue;
                    b.append(", ");
                }
                b.append(")");
            }
        }
        return b.toString();
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public ValuesList withAlias(Alias alias) {
        return (ValuesList)FromItem.super.withAlias(alias);
    }

    @Override
    public ValuesList withPivot(Pivot pivot) {
        return (ValuesList)FromItem.super.withPivot(pivot);
    }

    @Override
    public ValuesList withUnPivot(UnPivot unpivot) {
        return (ValuesList)FromItem.super.withUnPivot(unpivot);
    }

    public ValuesList withMultiExpressionList(MultiExpressionList multiExpressionList) {
        this.setMultiExpressionList(multiExpressionList);
        return this;
    }

    public ValuesList withNoBrackets(boolean noBrackets) {
        this.setNoBrackets(noBrackets);
        return this;
    }

    public ValuesList withColumnNames(List<String> columnNames) {
        this.setColumnNames(columnNames);
        return this;
    }

    public ValuesList addColumnNames(String ... columnNames) {
        List collection = Optional.ofNullable(this.getColumnNames()).orElseGet(ArrayList::new);
        Collections.addAll(collection, columnNames);
        return this.withColumnNames(collection);
    }

    public ValuesList addColumnNames(Collection<String> columnNames) {
        List collection = Optional.ofNullable(this.getColumnNames()).orElseGet(ArrayList::new);
        collection.addAll(columnNames);
        return this.withColumnNames(collection);
    }
}

