/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.util.validation.validator;

import shaded.net.sf.jsqlparser.parser.feature.Feature;
import shaded.net.sf.jsqlparser.statement.insert.Insert;
import shaded.net.sf.jsqlparser.util.validation.ValidationCapability;
import shaded.net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import shaded.net.sf.jsqlparser.util.validation.validator.ExpressionValidator;
import shaded.net.sf.jsqlparser.util.validation.validator.StatementValidator;

public class InsertValidator
extends AbstractValidator<Insert> {
    @Override
    public void validate(Insert insert) {
        ExpressionValidator v;
        for (ValidationCapability c2 : this.getCapabilities()) {
            this.validateFeature(c2, Feature.insert);
            this.validateOptionalFeature(c2, insert.getItemsList(), Feature.insertValues);
            this.validateOptionalFeature(c2, (Object)insert.getModifierPriority(), Feature.insertModifierPriority);
            this.validateFeature(c2, insert.isModifierIgnore(), Feature.insertModifierIgnore);
            this.validateOptionalFeature(c2, insert.getSelect(), Feature.insertFromSelect);
            this.validateFeature(c2, insert.isUseSet(), Feature.insertUseSet);
            this.validateFeature(c2, insert.isUseDuplicate(), Feature.insertUseDuplicateKeyUpdate);
            this.validateFeature(c2, insert.isReturningAllColumns(), Feature.insertReturningAll);
            this.validateOptionalFeature(c2, insert.getReturningExpressionList(), Feature.insertReturningExpressionList);
        }
        this.validateOptionalFromItem(insert.getTable());
        this.validateOptionalExpressions(insert.getColumns());
        this.validateOptionalItemsList(insert.getItemsList());
        if (insert.getSelect() != null) {
            insert.getSelect().accept(this.getValidator(StatementValidator.class));
        }
        if (insert.isUseSet()) {
            v = this.getValidator(ExpressionValidator.class);
            insert.getSetColumns().forEach(c -> c.accept(v));
            insert.getSetExpressionList().forEach(c -> c.accept(v));
        }
        if (insert.isUseDuplicate()) {
            v = this.getValidator(ExpressionValidator.class);
            insert.getDuplicateUpdateColumns().forEach(c -> c.accept(v));
            insert.getDuplicateUpdateExpressionList().forEach(c -> c.accept(v));
        }
        if (this.isNotEmpty(insert.getReturningExpressionList())) {
            v = this.getValidator(ExpressionValidator.class);
            insert.getReturningExpressionList().forEach(c -> c.getExpression().accept(v));
        }
    }
}

