/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.attach;

import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.AttachOperationFailedException;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import sun.tools.attach.HotSpotVirtualMachine;
import sun.tools.attach.SolarisVirtualMachine;

/*
 * Exception performing whole class analysis ignored.
 */
public class SolarisVirtualMachine
extends HotSpotVirtualMachine {
    private static final String tmpdir = "/tmp";
    private int fd = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SolarisVirtualMachine(AttachProvider attachProvider, String string) throws AttachNotSupportedException, IOException {
        super(attachProvider, string);
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AttachNotSupportedException("invalid process identifier");
        }
        try {
            this.fd = this.openDoor(n);
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file = this.createAttachFile(n);
            try {
                SolarisVirtualMachine.sigquit((int)n);
                int n2 = 0;
                long l = 200L;
                int n3 = (int)(this.attachTimeout() / l);
                do {
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        this.fd = this.openDoor(n);
                    }
                    catch (FileNotFoundException fileNotFoundException2) {
                        // empty catch block
                    }
                } while (++n2 <= n3 && this.fd == -1);
                if (this.fd == -1) {
                    throw new AttachNotSupportedException("Unable to open door: target process not responding or HotSpot VM not loaded");
                }
            }
            finally {
                file.delete();
            }
        }
        assert (this.fd >= 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach() throws IOException {
        SolarisVirtualMachine solarisVirtualMachine = this;
        synchronized (solarisVirtualMachine) {
            if (this.fd != -1) {
                SolarisVirtualMachine.close((int)this.fd);
                this.fd = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputStream execute(String string, Object ... objectArray) throws AgentLoadException, IOException {
        int n;
        int n2;
        assert (objectArray.length <= 3);
        SolarisVirtualMachine solarisVirtualMachine = this;
        synchronized (solarisVirtualMachine) {
            if (this.fd == -1) {
                throw new IOException("Detached from target VM");
            }
            n2 = this.fd;
        }
        int n3 = SolarisVirtualMachine.enqueue((int)n2, (String)string, (Object[])objectArray);
        assert (n3 >= 0);
        SocketInputStream socketInputStream = new SocketInputStream(this, n3);
        try {
            n = this.readInt((InputStream)socketInputStream);
        }
        catch (IOException iOException) {
            socketInputStream.close();
            throw iOException;
        }
        if (n != 0) {
            String string2 = this.readErrorMessage((InputStream)socketInputStream);
            socketInputStream.close();
            if (string.equals("load")) {
                throw new AgentLoadException("Failed to load agent library");
            }
            if (string2 == null) {
                throw new AttachOperationFailedException("Command failed in target VM");
            }
            throw new AttachOperationFailedException(string2);
        }
        return socketInputStream;
    }

    private int openDoor(int n) throws IOException {
        String string = "/tmp/.java_pid" + n;
        this.fd = SolarisVirtualMachine.open((String)string);
        try {
            SolarisVirtualMachine.checkPermissions((String)string);
        }
        catch (IOException iOException) {
            SolarisVirtualMachine.close((int)this.fd);
            throw iOException;
        }
        return this.fd;
    }

    private File createAttachFile(int n) throws IOException {
        String string = ".attach_pid" + n;
        String string2 = "/proc/" + n + "/cwd/" + string;
        File file = new File(string2);
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            file = new File("/tmp", string);
            file.createNewFile();
        }
        return file;
    }

    static native int open(String var0) throws IOException;

    static native void close(int var0) throws IOException;

    static native int read(int var0, byte[] var1, int var2, int var3) throws IOException;

    static native void checkPermissions(String var0) throws IOException;

    static native void sigquit(int var0) throws IOException;

    static native int enqueue(int var0, String var1, Object ... var2) throws IOException;

    static {
        System.loadLibrary("attach");
    }
}

