/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.api.dto;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.database.operations.InsertionDto;
import org.evomaster.client.java.controller.api.dto.database.schema.ColumnDto;
import org.evomaster.client.java.controller.api.dto.database.schema.DbInfoDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableDto;

public class SqlDtoUtils {
    public static String getId(TableDto dto) {
        if (dto.id.schema == null) {
            return dto.id.name;
        }
        return dto.id.schema + "." + dto.id.name;
    }

    public static TableDto getTable(DbInfoDto schema, String tableName) {
        return schema.tables.stream().filter(t -> SqlDtoUtils.matchByName(t, tableName)).findFirst().orElse(null);
    }

    public static boolean matchByName(TableDto dto, String name) {
        Objects.requireNonNull(dto);
        Objects.requireNonNull(name);
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Empty table name");
        }
        String[] tokens = name.split("\\.");
        if (tokens.length > 3) {
            throw new IllegalArgumentException("Invalid table name identifier. Too many '.': " + name);
        }
        if (tokens.length == 1) {
            return dto.id.name.equalsIgnoreCase(tokens[0]);
        }
        if (tokens.length == 2) {
            boolean mn = dto.id.name.equalsIgnoreCase(tokens[1]);
            if (!mn) {
                return false;
            }
            if (dto.id.catalog == null && dto.id.schema == null) {
                return tokens[0].equalsIgnoreCase("public");
            }
            if (dto.id.catalog != null && dto.id.schema != null) {
                return tokens[0].equalsIgnoreCase(dto.id.schema);
            }
            if (dto.id.schema != null) {
                return tokens[0].equalsIgnoreCase(dto.id.schema);
            }
            return tokens[0].equalsIgnoreCase(dto.id.catalog);
        }
        if (tokens.length == 3) {
            return tokens[0].equalsIgnoreCase(dto.id.catalog) && tokens[1].equalsIgnoreCase(dto.id.schema) && tokens[2].equalsIgnoreCase(dto.id.name);
        }
        return false;
    }

    public static List<String> extractColumnNames(InsertionDto dto, Set<String> filter) {
        return dto.data.stream().filter(i -> filter == null || filter.stream().anyMatch(f -> i.variableName.equalsIgnoreCase((String)f))).map(i -> i.variableName).collect(Collectors.toList());
    }

    public static List<String> extractColumnPrintableValues(InsertionDto dto, Set<String> filter) {
        return dto.data.stream().filter(i -> filter == null || filter.stream().anyMatch(f -> i.variableName.equalsIgnoreCase((String)f))).map(i -> i.printableValue).collect(Collectors.toList());
    }

    public static ColumnDto extractColumnInfo(TableDto dto, String columnName) {
        Optional<ColumnDto> op = dto.columns.stream().filter(c -> columnName.equalsIgnoreCase(c.name)).findAny();
        return op.orElse(null);
    }
}

