/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql;

import java.math.BigInteger;
import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import org.evomaster.client.java.controller.api.dto.database.schema.DatabaseType;
import org.evomaster.client.java.sql.DataRow;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.SqlScriptRunner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class DbCleanerTestBase {
    protected abstract Connection getConnection();

    protected void clearDatabase(List<String> tablesToSkip) {
        this.clearDatabase(tablesToSkip, null);
    }

    protected abstract void clearDatabase(List<String> var1, List<String> var2);

    protected abstract DatabaseType getDbType();

    @Test
    public void testSkipTableMisconfigured() throws Exception {
        String command = "CREATE TABLE Foo(id bigserial not null);";
        if (this.getDbType() == DatabaseType.MYSQL || this.getDbType() == DatabaseType.MARIADB) {
            command = "CREATE TABLE Foo(id serial not null);";
        } else if (this.getDbType() == DatabaseType.MS_SQL_SERVER) {
            command = "CREATE TABLE Foo(id bigint not null IDENTITY);";
        }
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)command);
        Assertions.assertThrows(Exception.class, () -> this.clearDatabase(Arrays.asList("Bar")));
    }

    @Test
    public void testTableToClean() throws Exception {
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE Foo(x int);");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE Bar(y int);");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"INSERT INTO Foo (x) VALUES (42)");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"INSERT INTO Foo (x) VALUES (66)");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"INSERT INTO Bar (y) VALUES (77)");
        QueryResult res = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM Foo;");
        Assertions.assertEquals((int)2, (int)res.seeRows().size());
        res = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM Bar;");
        Assertions.assertEquals((int)1, (int)res.seeRows().size());
        this.clearDatabase(null, Arrays.asList("Foo"));
        res = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM Foo;");
        Assertions.assertEquals((int)0, (int)res.seeRows().size());
        res = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM Bar;");
        Assertions.assertEquals((int)1, (int)res.seeRows().size());
    }

    @Test
    public void testSkipTable() throws Exception {
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE Foo(x int);");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE Bar(y int);");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"INSERT INTO Foo (x) VALUES (42)");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"INSERT INTO Foo (x) VALUES (66)");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"INSERT INTO Bar (y) VALUES (77)");
        QueryResult res = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM Foo;");
        Assertions.assertEquals((int)2, (int)res.seeRows().size());
        res = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM Bar;");
        Assertions.assertEquals((int)1, (int)res.seeRows().size());
        this.clearDatabase(Arrays.asList("Bar"));
        res = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM Foo;");
        Assertions.assertEquals((int)0, (int)res.seeRows().size());
        res = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM Bar;");
        Assertions.assertEquals((int)1, (int)res.seeRows().size());
    }

    @Test
    public void testFKs() throws Exception {
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE Foo(x int, primary key (x));");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE Bar(y int, primary key (y));");
        if (this.getDbType() == DatabaseType.MYSQL || this.getDbType() == DatabaseType.MARIADB) {
            SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"alter table Bar add foreign key (y) references Foo(x);");
        } else {
            SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"alter table Bar add constraint FK foreign key (y) references Foo;");
        }
        Assertions.assertThrows(Exception.class, () -> SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"INSERT INTO Bar (y) VALUES (42)"));
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"INSERT INTO Foo (x) VALUES (42)");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"INSERT INTO Bar (y) VALUES (42)");
        this.clearDatabase(null);
        QueryResult res = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM Foo;");
        Assertions.assertEquals((int)0, (int)res.seeRows().size());
        res = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM Bar;");
        Assertions.assertEquals((int)0, (int)res.seeRows().size());
    }

    @Test
    public void testResetIdentity() throws Exception {
        if (this.getDbType() == DatabaseType.MYSQL || this.getDbType() == DatabaseType.MARIADB) {
            SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE Foo(id serial not null, x int, primary key (id));");
        } else if (this.getDbType() == DatabaseType.MS_SQL_SERVER) {
            SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE Foo(id bigint not null IDENTITY, x int, primary key (id));");
        } else {
            SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE Foo(id bigserial not null, x int, primary key (id));");
        }
        int value = 42;
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)("INSERT INTO Foo (x) VALUES (" + value + ")"));
        QueryResult res = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM Foo;");
        Assertions.assertEquals((int)1, (int)res.seeRows().size());
        Assertions.assertEquals((Object)value, (Object)((DataRow)res.seeRows().get(0)).getValueByName("x"));
        long id = this.getDbType() == DatabaseType.MYSQL || this.getDbType() == DatabaseType.MARIADB ? ((BigInteger)((DataRow)res.seeRows().get(0)).getValueByName("id")).longValue() : ((Long)((DataRow)res.seeRows().get(0)).getValueByName("id")).longValue();
        this.clearDatabase(null);
        res = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM Foo;");
        Assertions.assertEquals((int)0, (int)res.seeRows().size());
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)("INSERT INTO Foo (x) VALUES (" + value + ")"));
        res = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM Foo;");
        Assertions.assertEquals((int)1, (int)res.seeRows().size());
        long regeneratedId = this.getDbType() == DatabaseType.MYSQL || this.getDbType() == DatabaseType.MARIADB ? ((BigInteger)((DataRow)res.seeRows().get(0)).getValueByName("id")).longValue() : ((Long)((DataRow)res.seeRows().get(0)).getValueByName("id")).longValue();
        Assertions.assertEquals((long)id, (long)regeneratedId);
    }

    @Test
    public void testAvoidViews() throws Exception {
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE Foo(x int, y int, primary key (x));");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE VIEW AView AS SELECT y FROM Foo;");
        this.clearDatabase(null);
    }
}

