/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import org.evomaster.client.java.sql.DataRow;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.SqlScriptRunner;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SequenceH2Test {
    private static Connection connection;

    @BeforeAll
    public static void initClass() throws Exception {
        connection = DriverManager.getConnection("jdbc:h2:mem:db_test", "sa", "");
    }

    @AfterAll
    public static void afterClass() throws Exception {
        connection.close();
    }

    @BeforeEach
    public void initTest() throws Exception {
        SqlScriptRunner.execCommand((Connection)connection, (String)"DROP ALL OBJECTS;");
    }

    @Test
    public void testSequence() throws Exception {
        SqlScriptRunner.execCommand((Connection)connection, (String)"CREATE TABLE Foo(id BIGSERIAL, x INT NOT NULL);");
        QueryResult queryResult0 = SqlScriptRunner.execCommand((Connection)connection, (String)"SELECT id,x FROM Foo;");
        Assertions.assertTrue((boolean)queryResult0.isEmpty());
        SqlScriptRunner.execCommand((Connection)connection, (String)"INSERT INTO Foo(x) VALUES (5);");
        QueryResult queryResult1 = SqlScriptRunner.execCommand((Connection)connection, (String)"SELECT id,x FROM Foo ORDER BY id;");
        Assertions.assertEquals((int)1, (int)queryResult1.seeRows().size());
        Assertions.assertEquals((Object)5, (Object)((DataRow)queryResult1.seeRows().get(0)).getValueByName("x", "Foo"));
        Assertions.assertEquals((Object)1L, (Object)((DataRow)queryResult1.seeRows().get(0)).getValueByName("id", "Foo"));
        SqlScriptRunner.execCommand((Connection)connection, (String)"INSERT INTO Foo(x) VALUES (42);");
        QueryResult queryResult2 = SqlScriptRunner.execCommand((Connection)connection, (String)"SELECT id,x FROM Foo ORDER BY id;");
        Assertions.assertEquals((int)2, (int)queryResult2.seeRows().size());
        Assertions.assertEquals((Object)5, (Object)((DataRow)queryResult2.seeRows().get(0)).getValueByName("x", "Foo"));
        Assertions.assertEquals((Object)1L, (Object)((DataRow)queryResult2.seeRows().get(0)).getValueByName("id", "Foo"));
        Assertions.assertEquals((Object)42, (Object)((DataRow)queryResult2.seeRows().get(1)).getValueByName("x", "Foo"));
        Assertions.assertEquals((Object)2L, (Object)((DataRow)queryResult2.seeRows().get(1)).getValueByName("id", "Foo"));
        QueryResult queryResult3 = SqlScriptRunner.execCommand((Connection)connection, (String)"SELECT * FROM INFORMATION_SCHEMA.SEQUENCES;");
        Assertions.assertEquals((int)0, (int)queryResult3.seeRows().size());
        SqlScriptRunner.execCommand((Connection)connection, (String)"TRUNCATE TABLE Foo RESTART IDENTITY");
        SqlScriptRunner.execCommand((Connection)connection, (String)"INSERT INTO Foo(x) VALUES (5);");
        QueryResult queryResult4 = SqlScriptRunner.execCommand((Connection)connection, (String)"SELECT id,x FROM Foo ORDER BY id;");
        Assertions.assertEquals((int)1, (int)queryResult4.seeRows().size());
        Assertions.assertEquals((Object)5, (Object)((DataRow)queryResult4.seeRows().get(0)).getValueByName("x", "Foo"));
        Assertions.assertEquals((Object)1L, (Object)((DataRow)queryResult4.seeRows().get(0)).getValueByName("id", "Foo"));
        SqlScriptRunner.execCommand((Connection)connection, (String)"INSERT INTO Foo(x) VALUES (42);");
        QueryResult queryResult5 = SqlScriptRunner.execCommand((Connection)connection, (String)"SELECT id,x FROM Foo ORDER BY id;");
        Assertions.assertEquals((int)2, (int)queryResult5.seeRows().size());
        Assertions.assertEquals((Object)5, (Object)((DataRow)queryResult5.seeRows().get(0)).getValueByName("x", "Foo"));
        Assertions.assertEquals((Object)1L, (Object)((DataRow)queryResult5.seeRows().get(0)).getValueByName("id", "Foo"));
        Assertions.assertEquals((Object)42, (Object)((DataRow)queryResult5.seeRows().get(1)).getValueByName("x", "Foo"));
        Assertions.assertEquals((Object)2L, (Object)((DataRow)queryResult5.seeRows().get(1)).getValueByName("id", "Foo"));
    }

    @Test
    public void testRestartIdentity() throws Exception {
        SqlScriptRunner.execCommand((Connection)connection, (String)"CREATE TABLE Foo(id BIGINT NOT NULL PRIMARY KEY, x INT NOT NULL);");
        SqlScriptRunner.execCommand((Connection)connection, (String)"TRUNCATE TABLE Foo RESTART IDENTITY");
    }

    @Test
    public void testCreateSequence() throws Exception {
        SqlScriptRunner.execCommand((Connection)connection, (String)"CREATE SEQUENCE SEQ1 AS BIGINT START WITH 1;");
        QueryResult queryResult0 = SqlScriptRunner.execCommand((Connection)connection, (String)"SELECT * FROM INFORMATION_SCHEMA.SEQUENCES WHERE SEQUENCE_NAME='SEQ1';");
        Assertions.assertEquals((int)1, (int)queryResult0.seeRows().size());
        Assertions.assertEquals((Object)1L, (Object)((DataRow)queryResult0.seeRows().get(0)).getValueByName("BASE_VALUE", "SEQUENCES"));
        QueryResult queryResult1 = SqlScriptRunner.execCommand((Connection)connection, (String)"SELECT next value for SEQ1");
        Assertions.assertEquals((int)1, (int)queryResult1.seeRows().size());
        Assertions.assertEquals((Object)1L, (Object)((DataRow)queryResult1.seeRows().get(0)).getValue(0));
        QueryResult queryResult2 = SqlScriptRunner.execCommand((Connection)connection, (String)"SELECT next value for SEQ1");
        Assertions.assertEquals((int)1, (int)queryResult2.seeRows().size());
        Assertions.assertEquals((Object)2L, (Object)((DataRow)queryResult2.seeRows().get(0)).getValue(0));
        QueryResult queryResult3 = SqlScriptRunner.execCommand((Connection)connection, (String)"SELECT next value for SEQ1");
        Assertions.assertEquals((int)1, (int)queryResult3.seeRows().size());
        Assertions.assertEquals((Object)3L, (Object)((DataRow)queryResult3.seeRows().get(0)).getValue(0));
        QueryResult queryResult4 = SqlScriptRunner.execCommand((Connection)connection, (String)"SELECT * FROM INFORMATION_SCHEMA.SEQUENCES WHERE SEQUENCE_NAME='SEQ1';");
        Assertions.assertEquals((int)1, (int)queryResult4.seeRows().size());
        Assertions.assertEquals((Object)4L, (Object)((DataRow)queryResult4.seeRows().get(0)).getValueByName("BASE_VALUE", "SEQUENCES"));
    }
}

