/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.util.Map;
import java.util.Set;
import org.evomaster.client.java.sql.internal.ColumnTableAnalyzer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ColumnTableAnalyzerTest {
    @Test
    public void testInsertInSimpleTable() {
        String sql = "insert into Foo (x) values (42)";
        Map data = ColumnTableAnalyzer.getInsertedDataFields((String)sql);
        Assertions.assertEquals((int)1, (int)data.size());
        Assertions.assertTrue((boolean)data.containsKey("Foo"));
    }

    @Test
    public void testUpdateInSimpleTable() {
        String sql = "update Foo set x=42";
        Map data = ColumnTableAnalyzer.getUpdatedDataFields((String)sql);
        Assertions.assertEquals((int)1, (int)data.size());
        Assertions.assertTrue((boolean)data.containsKey("Foo"));
    }

    @Test
    public void testDeleteSimpleTable() {
        String sql = "delete from Foo";
        Set tables = ColumnTableAnalyzer.getDeletedTables((String)sql);
        Assertions.assertEquals((int)1, (int)tables.size());
        Assertions.assertTrue((boolean)tables.contains("Foo"));
    }

    @Test
    public void testSelectReadAllFromSingleTable() {
        String select = "select *  from Foo";
        Map data = ColumnTableAnalyzer.getSelectReadDataFields((String)select);
        Assertions.assertEquals((int)1, (int)data.size());
        Set columns = (Set)data.get("Foo");
        Assertions.assertEquals((int)1, (int)columns.size());
        Assertions.assertTrue((boolean)columns.contains("*"));
    }

    @Test
    public void testSelectReadFromJoinedTables() {
        String select = "SELECT Orders.OrderID, Customers.CustomerName, Orders.OrderDate FROM Orders  INNER JOIN Customers ON Orders.CustomerID=Customers.CustomerID;";
        Map data = ColumnTableAnalyzer.getSelectReadDataFields((String)select);
        Assertions.assertEquals((int)2, (int)data.size());
        Set columns = (Set)data.get("Orders");
        Assertions.assertEquals((int)1, (int)columns.size());
        Assertions.assertTrue((boolean)columns.contains("*"));
        columns = (Set)data.get("Customers");
        Assertions.assertEquals((int)1, (int)columns.size());
        Assertions.assertTrue((boolean)columns.contains("*"));
    }
}

