/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.database.operations.InsertionDto;
import org.evomaster.client.java.controller.api.dto.database.schema.ColumnDto;
import org.evomaster.client.java.controller.api.dto.database.schema.DbSchemaDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableDto;
import org.evomaster.client.java.sql.DataRow;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.VariableDescriptor;
import org.evomaster.client.java.sql.internal.ColumnTypeParser;
import org.evomaster.client.java.sql.internal.SqlDatabaseDtoUtils;

public class QueryResultTransformer {
    public static QueryResult[] convertInsertionDtosToQueryResults(List<InsertionDto> insertionDtos, Map<String, Set<String>> columns, DbSchemaDto schemaDto) {
        HashMap maps = new HashMap();
        for (String key : columns.keySet()) {
            ArrayList kresults = new ArrayList();
            insertionDtos.stream().filter(d -> d.targetTable.equalsIgnoreCase(key)).forEach(insertionDto -> {
                QueryResult qr = QueryResultTransformer.convertInsertionDtoToQueryResult(insertionDto, key, (Set)columns.get(key), schemaDto, kresults);
                if (qr != null && !qr.isEmpty()) {
                    kresults.add(qr);
                }
            });
            if (kresults.isEmpty()) continue;
            maps.put(key, kresults);
        }
        List qrPerTable = QueryResultTransformer.cartesianProduct(maps.keySet().stream().sorted().map(maps::get).collect(Collectors.toList()));
        if (qrPerTable == null) {
            return null;
        }
        return (QueryResult[])qrPerTable.stream().map(QueryResultTransformer::mergeQueryResultsByCartesianProductDataRows).filter(Objects::nonNull).toArray(QueryResult[]::new);
    }

    private static QueryResult mergeQueryResultsByCartesianProductDataRows(List<QueryResult> queryResults) {
        Objects.requireNonNull(queryResults);
        for (QueryResult qr : queryResults) {
            Objects.requireNonNull(qr);
        }
        if (queryResults.isEmpty()) {
            return null;
        }
        if (queryResults.size() == 1) {
            return queryResults.get(0);
        }
        ArrayList<VariableDescriptor> variableDescriptors = new ArrayList<VariableDescriptor>();
        ArrayList datarowList = new ArrayList();
        for (QueryResult qr : queryResults) {
            if (qr.isEmpty()) continue;
            variableDescriptors.addAll(qr.seeVariableDescriptors());
            datarowList.add(qr.seeRows());
        }
        QueryResult merged = new QueryResult(variableDescriptors);
        List results = QueryResultTransformer.cartesianProduct(datarowList);
        if (results != null && !results.isEmpty()) {
            for (List<DataRow> list : results) {
                ArrayList<Object> mergedValues = new ArrayList<Object>();
                list.forEach(d -> mergedValues.addAll(d.seeValues()));
                DataRow mdatarow = new DataRow(variableDescriptors, mergedValues);
                merged.addRow(mdatarow);
            }
        }
        return merged;
    }

    public static <T> List<List<T>> cartesianProduct(List<List<T>> values) {
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        values.forEach(Objects::requireNonNull);
        int[] counts = values.stream().mapToInt(s -> s.size() - 1).toArray();
        int[] indexes = values.stream().mapToInt(s -> s.isEmpty() ? -1 : 0).toArray();
        ArrayList<List<T>> results = new ArrayList<List<T>>();
        boolean isLast = false;
        block0: while (!isLast) {
            if (Arrays.equals(counts, indexes)) {
                isLast = true;
            }
            ArrayList<T> row = new ArrayList<T>();
            for (int i = 0; i < counts.length; ++i) {
                if (indexes[i] < 0) continue;
                row.add(values.get(i).get(indexes[i]));
            }
            results.add(row);
            for (int j = indexes.length - 1; !isLast && j >= 0; --j) {
                if (indexes[j] < 0 || indexes[j] >= counts[j]) continue;
                indexes[j] = indexes[j] + 1;
                for (int t = j + 1; t < indexes.length; ++t) {
                    if (indexes[t] == -1) continue;
                    indexes[t] = 0;
                }
                continue block0;
            }
        }
        return results;
    }

    private static QueryResult convertInsertionDtoToQueryResult(InsertionDto insertionDto, String tableName, Set<String> relatedColumns, DbSchemaDto dto, List<QueryResult> existingQueryResults) {
        List<String> relatedColumnNames = SqlDatabaseDtoUtils.extractColumnNames(insertionDto, relatedColumns);
        if (!relatedColumnNames.isEmpty()) {
            ArrayList<Object> values;
            Optional<TableDto> foundTableSchema;
            QueryResult found = null;
            if (!existingQueryResults.isEmpty()) {
                found = existingQueryResults.stream().filter(e -> e.sameVariableNames(relatedColumnNames, tableName)).findAny().orElse(null);
            }
            QueryResult qr = found;
            if (found == null) {
                qr = new QueryResult(relatedColumnNames, tableName);
            }
            if ((foundTableSchema = dto.tables.stream().filter(t -> t.name.equalsIgnoreCase(tableName)).findFirst()).isPresent()) {
                TableDto tableDto = foundTableSchema.get();
                List<String> printableValue = SqlDatabaseDtoUtils.extractColumnPrintableValues(insertionDto, relatedColumns);
                assert (printableValue.size() == relatedColumnNames.size());
                values = new ArrayList<Object>();
                for (int i = 0; i < printableValue.size(); ++i) {
                    ColumnDto columnDto = SqlDatabaseDtoUtils.extractColumnInfo(tableDto, relatedColumnNames.get(i));
                    if (columnDto == null) {
                        throw new IllegalArgumentException("Cannot find column schema of " + relatedColumnNames.get(i) + " in Table " + tableName);
                    }
                    values.add(QueryResultTransformer.getColumnValueBasedOnPrintableValue(printableValue.get(i), columnDto));
                }
            } else {
                throw new IllegalArgumentException("Cannot find table schema of " + tableName);
            }
            qr.addRow(relatedColumnNames, tableName, values);
            if (found != null) {
                return null;
            }
            return qr;
        }
        return null;
    }

    private static Object getColumnValueBasedOnPrintableValue(String printableValue, ColumnDto dto) {
        Instant instant;
        if (printableValue == null) {
            return null;
        }
        if (dto.type.equalsIgnoreCase("BOOL") || dto.type.equalsIgnoreCase("BOOLEAN")) {
            return Boolean.valueOf(printableValue);
        }
        if (dto.type.equalsIgnoreCase("INT") || dto.type.equalsIgnoreCase("INTEGER") || dto.type.equalsIgnoreCase("INT4")) {
            return Integer.valueOf(printableValue);
        }
        if (dto.type.equalsIgnoreCase("INT2") || dto.type.equalsIgnoreCase("SMALLINT")) {
            return Short.valueOf(printableValue);
        }
        if (dto.type.equalsIgnoreCase("TINYINT")) {
            return Byte.valueOf(printableValue);
        }
        if (dto.type.equalsIgnoreCase("INT8") || dto.type.equalsIgnoreCase("BIGINT") || dto.type.equalsIgnoreCase("BIGSERIAL")) {
            return Long.valueOf(printableValue);
        }
        if (dto.type.equalsIgnoreCase("DOUBLE") || dto.type.equalsIgnoreCase("DOUBLE_PRECISION") || dto.type.equalsIgnoreCase("FLOAT") || dto.type.equalsIgnoreCase("REAL") || dto.type.equalsIgnoreCase("FLOAT4") || dto.type.equalsIgnoreCase("FLOAT8") || dto.type.equalsIgnoreCase("DEC") || dto.type.equalsIgnoreCase("DECIMAL") || dto.type.equalsIgnoreCase("NUMERIC")) {
            return Double.valueOf(printableValue);
        }
        if ((dto.type.equalsIgnoreCase("TIMESTAMP") || dto.type.equalsIgnoreCase("TIMESTAMPZ") || dto.type.equalsIgnoreCase("TIMETZ") || dto.type.equalsIgnoreCase("DATE") || dto.type.equalsIgnoreCase("DATETIME") || dto.type.equalsIgnoreCase("TIME")) && (instant = ColumnTypeParser.getAsInstant(printableValue)) != null) {
            return instant;
        }
        if (dto.type.equalsIgnoreCase("CHAR") || dto.type.equalsIgnoreCase("CHARACTER") || dto.type.equalsIgnoreCase("CHARACTER_LARGE_OBJECT") || dto.type.equalsIgnoreCase("TINYTEXT") || dto.type.equalsIgnoreCase("TEXT") || dto.type.equalsIgnoreCase("LONGTEXT") || dto.type.equalsIgnoreCase("VARCHAR") || dto.type.equalsIgnoreCase("CHARACTER_VARYING") || dto.type.equalsIgnoreCase("VARCHAR_IGNORECASE") || dto.type.equalsIgnoreCase("CLOB") || dto.type.equalsIgnoreCase("MEDIUMTEXT") || dto.type.equalsIgnoreCase("LONGBLOB") || dto.type.equalsIgnoreCase("MEDIUMBLOB") || dto.type.equalsIgnoreCase("TINYBLOB")) {
            return String.valueOf(printableValue);
        }
        return printableValue;
    }
}

