/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.util.Map;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import org.evomaster.client.java.sql.internal.SqlHandler;
import org.evomaster.client.java.sql.internal.SqlParserUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SqlHandlerTest {
    @Test
    public void testPatioIssue() throws Exception {
        String select = "SELECT v.* FROM voting v, groups g WHERE v.expired = false AND '2021-04-28T16:02:27.426+0200' >= v.created_at + g.voting_duration * INTERVAL '1 hour' AND v.group_id = g.id";
        Statement stmt = CCJSqlParserUtil.parse((String)select);
        Map columns = new SqlHandler(null).extractColumnsInvolvedInWhere(stmt);
        Assertions.assertTrue((boolean)columns.values().stream().flatMap(s -> s.stream()).noneMatch(c -> c.equals("false")));
    }

    @Test
    public void testBooleans() throws Exception {
        String select = "SELECT f.* FROM Foo WHERE f.a = TRUE AND f.b = On AND f.c = false AND f.d = f";
        Statement stmt = CCJSqlParserUtil.parse((String)select);
        Map columns = new SqlHandler(null).extractColumnsInvolvedInWhere(stmt);
        Assertions.assertTrue((boolean)columns.isEmpty());
    }

    @Test
    public void testCreateCachedLocalTemporaryTable() {
        String createSql = "create cached local temporary table if not exists HT_feature_constraint (id bigint not null) on commit drop transactional";
        boolean canParseSqlStatement = SqlParserUtils.canParseSqlStatement((String)createSql);
        Assertions.assertFalse((boolean)canParseSqlStatement);
    }

    @Test
    public void testNoWhere() throws Exception {
        String select = "SELECT * FROM Table v";
        Statement stmt = CCJSqlParserUtil.parse((String)select);
        Map columns = new SqlHandler(null).extractColumnsInvolvedInWhere(stmt);
        Assertions.assertTrue((boolean)columns.isEmpty());
    }

    @Test
    public void testNoFromNoWhere() throws Exception {
        String select = "SELECT 1";
        Statement stmt = CCJSqlParserUtil.parse((String)select);
        Map columns = new SqlHandler(null).extractColumnsInvolvedInWhere(stmt);
        Assertions.assertTrue((boolean)columns.isEmpty());
    }

    @Test
    public void testWhereButNoColumns() throws Exception {
        String select = "SELECT * FROM table WHERE 1 = 1";
        Statement stmt = CCJSqlParserUtil.parse((String)select);
        Map columns = new SqlHandler(null).extractColumnsInvolvedInWhere(stmt);
        Assertions.assertTrue((boolean)columns.isEmpty());
    }
}

