/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.util.Arrays;
import org.evomaster.client.java.distance.heuristics.TruthnessUtils;
import org.evomaster.client.java.sql.DataRow;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.internal.SqlDistanceWithMetrics;
import org.evomaster.client.java.sql.internal.SqlHeuristicsCalculator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SqlHeuristicsCalculatorTest {
    @Test
    public void testNoWhereNoFromTableWithRows() {
        String sqlCommand = "SELECT name FROM Person";
        QueryResult personContents = new QueryResult(Arrays.asList("name"), "Person");
        personContents.addRow(new DataRow("name", (Object)"John", "Person"));
        SqlDistanceWithMetrics distanceWithMetrics = SqlHeuristicsCalculator.computeDistance((String)sqlCommand, null, null, (QueryResult[])new QueryResult[]{personContents});
        Assertions.assertEquals((double)0.0, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testWhereNoFromClause() {
        String sqlCommand = "SELECT 1 AS example_column WHERE 1 = 0";
        QueryResult virtualTableContents = new QueryResult(Arrays.asList("example_column"), null);
        SqlDistanceWithMetrics distanceWithMetrics = SqlHeuristicsCalculator.computeDistance((String)sqlCommand, null, null, (QueryResult[])new QueryResult[]{virtualTableContents});
        double expectedDistance = 1.0 - SqlHeuristicsCalculator.C;
        Assertions.assertEquals((double)expectedDistance, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testNoWhereNoFromClause() {
        String sqlCommand = "SELECT 1 AS example_column";
        QueryResult virtualTableContents = new QueryResult(Arrays.asList("example_column"), null);
        virtualTableContents.addRow(new DataRow("example_column", (Object)1, null));
        SqlDistanceWithMetrics distanceWithMetrics = SqlHeuristicsCalculator.computeDistance((String)sqlCommand, null, null, (QueryResult[])new QueryResult[]{virtualTableContents});
        Assertions.assertEquals((double)0.0, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testNoWhereNoFromTableNoRows() {
        String sqlCommand = "SELECT name FROM Person";
        QueryResult personContents = new QueryResult(Arrays.asList("name"), "Person");
        SqlDistanceWithMetrics distanceWithMetrics = SqlHeuristicsCalculator.computeDistance((String)sqlCommand, null, null, (QueryResult[])new QueryResult[]{personContents});
        double expectedDistance = 1.0 - SqlHeuristicsCalculator.C;
        Assertions.assertEquals((double)expectedDistance, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testLeftJoinNoFromTableWithRows() {
        String sqlCommand = "SELECT name FROM TableA LEFT JOIN TableB";
        QueryResult tableAcontents = new QueryResult(Arrays.asList("name"), "TableA");
        tableAcontents.addRow(new DataRow("name", (Object)"John", "TableA"));
        QueryResult tableBcontents = new QueryResult(Arrays.asList("name"), "TableB");
        SqlDistanceWithMetrics distanceWithMetrics = SqlHeuristicsCalculator.computeDistance((String)sqlCommand, null, null, (QueryResult[])new QueryResult[]{tableAcontents, tableBcontents});
        Assertions.assertEquals((double)0.0, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testRightJoinNoFromTableWithRows() {
        String sqlCommand = "SELECT name FROM TableA RIGHT JOIN TableB";
        QueryResult tableAcontents = new QueryResult(Arrays.asList("name"), "TableA");
        QueryResult tableBcontents = new QueryResult(Arrays.asList("name"), "TableB");
        tableBcontents.addRow(new DataRow("name", (Object)"John", "TableB"));
        SqlDistanceWithMetrics distanceWithMetrics = SqlHeuristicsCalculator.computeDistance((String)sqlCommand, null, null, (QueryResult[])new QueryResult[]{tableAcontents, tableBcontents});
        Assertions.assertEquals((double)0.0, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testRightJoinNoFromTableNoRows() {
        String sqlCommand = "SELECT name FROM TableA RIGHT JOIN TableB";
        QueryResult tableAcontents = new QueryResult(Arrays.asList("name"), "TableA");
        tableAcontents.addRow(new DataRow("name", (Object)"John", "TableA"));
        QueryResult tableBcontents = new QueryResult(Arrays.asList("name"), "TableB");
        SqlDistanceWithMetrics distanceWithMetrics = SqlHeuristicsCalculator.computeDistance((String)sqlCommand, null, null, (QueryResult[])new QueryResult[]{tableAcontents, tableBcontents});
        double expectedDistance = 1.0 - SqlHeuristicsCalculator.C;
        Assertions.assertEquals((double)expectedDistance, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testLeftJoinNoFromTableNoRows() {
        String sqlCommand = "SELECT name FROM TableA LEFT JOIN TableB";
        QueryResult tableAcontents = new QueryResult(Arrays.asList("name"), "TableA");
        QueryResult tableBcontents = new QueryResult(Arrays.asList("name"), "TableB");
        tableBcontents.addRow(new DataRow("name", (Object)"John", "TableB"));
        SqlDistanceWithMetrics distanceWithMetrics = SqlHeuristicsCalculator.computeDistance((String)sqlCommand, null, null, (QueryResult[])new QueryResult[]{tableAcontents, tableBcontents});
        double expectedDistance = 1.0 - SqlHeuristicsCalculator.C;
        Assertions.assertEquals((double)expectedDistance, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testLeftOuterJoinNoFromTableNoRows() {
        String sqlCommand = "SELECT name FROM TableA LEFT OUTER JOIN TableB";
        QueryResult tableAcontents = new QueryResult(Arrays.asList("name"), "TableA");
        QueryResult tableBcontents = new QueryResult(Arrays.asList("name"), "TableB");
        tableBcontents.addRow(new DataRow("name", (Object)"John", "TableB"));
        SqlDistanceWithMetrics distanceWithMetrics = SqlHeuristicsCalculator.computeDistance((String)sqlCommand, null, null, (QueryResult[])new QueryResult[]{tableAcontents, tableBcontents});
        double expectedDistance = 1.0 - SqlHeuristicsCalculator.C;
        Assertions.assertEquals((double)expectedDistance, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testRightOuterJoinNoFromTableNoRows() {
        String sqlCommand = "SELECT name FROM TableA RIGHT OUTER JOIN TableB";
        QueryResult tableAcontents = new QueryResult(Arrays.asList("name"), "TableA");
        tableAcontents.addRow(new DataRow("name", (Object)"John", "TableA"));
        QueryResult tableBcontents = new QueryResult(Arrays.asList("name"), "TableB");
        SqlDistanceWithMetrics distanceWithMetrics = SqlHeuristicsCalculator.computeDistance((String)sqlCommand, null, null, (QueryResult[])new QueryResult[]{tableAcontents, tableBcontents});
        double expectedDistance = 1.0 - SqlHeuristicsCalculator.C;
        Assertions.assertEquals((double)expectedDistance, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testLeftOuterJoinNoFromTableWithRows() {
        String sqlCommand = "SELECT name FROM TableA LEFT OUTER JOIN TableB";
        QueryResult tableAcontents = new QueryResult(Arrays.asList("name"), "TableA");
        tableAcontents.addRow(new DataRow("name", (Object)"John", "TableA"));
        QueryResult tableBcontents = new QueryResult(Arrays.asList("name"), "TableB");
        SqlDistanceWithMetrics distanceWithMetrics = SqlHeuristicsCalculator.computeDistance((String)sqlCommand, null, null, (QueryResult[])new QueryResult[]{tableAcontents, tableBcontents});
        Assertions.assertEquals((double)0.0, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testRightOuterJoinNoFromTableWithRows() {
        String sqlCommand = "SELECT name FROM TableA RIGHT OUTER JOIN TableB";
        QueryResult tableAcontents = new QueryResult(Arrays.asList("name"), "TableA");
        QueryResult tableBcontents = new QueryResult(Arrays.asList("name"), "TableB");
        tableBcontents.addRow(new DataRow("name", (Object)"John", "TableB"));
        SqlDistanceWithMetrics distanceWithMetrics = SqlHeuristicsCalculator.computeDistance((String)sqlCommand, null, null, (QueryResult[])new QueryResult[]{tableAcontents, tableBcontents});
        Assertions.assertEquals((double)0.0, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testCrossJoinNoFromTableNoRows() {
        String sqlCommand = "SELECT name FROM TableA CROSS JOIN TableB";
        QueryResult tableAcontents = new QueryResult(Arrays.asList("name"), "TableA");
        QueryResult tableBcontents = new QueryResult(Arrays.asList("name"), "TableB");
        SqlDistanceWithMetrics distanceWithMetrics = SqlHeuristicsCalculator.computeDistance((String)sqlCommand, null, null, (QueryResult[])new QueryResult[]{tableAcontents, tableBcontents});
        double expectedDistance = 1.0 - SqlHeuristicsCalculator.C;
        Assertions.assertEquals((double)expectedDistance, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testCrossJoinNoFromTableWithRows() {
        String sqlCommand = "SELECT name FROM TableA CROSS JOIN TableB";
        QueryResult tableAcontents = new QueryResult(Arrays.asList("name"), "TableA");
        QueryResult tableBcontents = new QueryResult(Arrays.asList("name"), "TableB");
        tableAcontents.addRow(new DataRow("name", (Object)"John", "TableA"));
        tableBcontents.addRow(new DataRow("name", (Object)"John", "TableB"));
        SqlDistanceWithMetrics distanceWithMetrics = SqlHeuristicsCalculator.computeDistance((String)sqlCommand, null, null, (QueryResult[])new QueryResult[]{tableAcontents, tableBcontents});
        Assertions.assertEquals((double)0.0, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testSelectNotEquals() {
        String sqlCommand = "SELECT name, age FROM Persons WHERE age=18";
        QueryResult personsContents = new QueryResult(Arrays.asList("name", "age"), "Persons");
        personsContents.addRow(Arrays.asList("name", "age"), "Persons", Arrays.asList("John", 18));
        SqlDistanceWithMetrics distanceWithMetrics = SqlHeuristicsCalculator.computeDistance((String)sqlCommand, null, null, (QueryResult[])new QueryResult[]{personsContents});
        Assertions.assertEquals((double)0.0, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testSelectMinorThan() {
        String sqlCommand = "SELECT name, age FROM Persons WHERE age<18";
        QueryResult personsContents = new QueryResult(Arrays.asList("name", "age"), "Persons");
        personsContents.addRow(Arrays.asList("name", "age"), "Persons", Arrays.asList("John", 33));
        SqlDistanceWithMetrics distanceWithMetrics = SqlHeuristicsCalculator.computeDistance((String)sqlCommand, null, null, (QueryResult[])new QueryResult[]{personsContents});
        double equalityTruthness = TruthnessUtils.getLessThanTruthness((double)33.0, (double)18.0).getOfTrue();
        double scaledTruthnessBetter = TruthnessUtils.buildScaledTruthness((double)SqlHeuristicsCalculator.C_BETTER, (double)equalityTruthness).getOfTrue();
        double scaledTruthness = TruthnessUtils.buildScaledTruthness((double)SqlHeuristicsCalculator.C, (double)scaledTruthnessBetter).getOfTrue();
        double expectedDistance = 1.0 - scaledTruthness;
        Assertions.assertEquals((double)expectedDistance, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testSelectMinorThanEquals() {
        String sqlCommand = "SELECT name, age FROM Persons WHERE age<=18";
        QueryResult personsContents = new QueryResult(Arrays.asList("name", "age"), "Persons");
        personsContents.addRow(Arrays.asList("name", "age"), "Persons", Arrays.asList("John", 33));
        SqlDistanceWithMetrics distanceWithMetrics = SqlHeuristicsCalculator.computeDistance((String)sqlCommand, null, null, (QueryResult[])new QueryResult[]{personsContents});
        double equalityTruthness = TruthnessUtils.getLessThanTruthness((double)18.0, (double)33.0).invert().getOfTrue();
        double scaledTruthnessBetter = TruthnessUtils.buildScaledTruthness((double)SqlHeuristicsCalculator.C_BETTER, (double)equalityTruthness).getOfTrue();
        double scaledTruthness = TruthnessUtils.buildScaledTruthness((double)SqlHeuristicsCalculator.C, (double)scaledTruthnessBetter).getOfTrue();
        double expectedDistance = 1.0 - scaledTruthness;
        Assertions.assertEquals((double)expectedDistance, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testSelectGreaterThan() {
        String sqlCommand = "SELECT name, age FROM Persons WHERE 18>age";
        QueryResult personsContents = new QueryResult(Arrays.asList("name", "age"), "Persons");
        personsContents.addRow(Arrays.asList("name", "age"), "Persons", Arrays.asList("John", 33));
        SqlDistanceWithMetrics distanceWithMetrics = SqlHeuristicsCalculator.computeDistance((String)sqlCommand, null, null, (QueryResult[])new QueryResult[]{personsContents});
        double equalityTruthness = TruthnessUtils.getLessThanTruthness((double)33.0, (double)18.0).getOfTrue();
        double scaledTruthnessBetter = TruthnessUtils.buildScaledTruthness((double)SqlHeuristicsCalculator.C_BETTER, (double)equalityTruthness).getOfTrue();
        double scaledTruthness = TruthnessUtils.buildScaledTruthness((double)SqlHeuristicsCalculator.C, (double)scaledTruthnessBetter).getOfTrue();
        double expectedDistance = 1.0 - scaledTruthness;
        Assertions.assertEquals((double)expectedDistance, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testSelectGreaterThanEquals() {
        String sqlCommand = "SELECT name, age FROM Persons WHERE 18>=age";
        QueryResult personsContents = new QueryResult(Arrays.asList("name", "age"), "Persons");
        personsContents.addRow(Arrays.asList("name", "age"), "Persons", Arrays.asList("John", 33));
        SqlDistanceWithMetrics distanceWithMetrics = SqlHeuristicsCalculator.computeDistance((String)sqlCommand, null, null, (QueryResult[])new QueryResult[]{personsContents});
        double equalityTruthness = TruthnessUtils.getLessThanTruthness((double)18.0, (double)33.0).invert().getOfTrue();
        double scaledTruthnessBetter = TruthnessUtils.buildScaledTruthness((double)SqlHeuristicsCalculator.C_BETTER, (double)equalityTruthness).getOfTrue();
        double scaledTruthness = TruthnessUtils.buildScaledTruthness((double)SqlHeuristicsCalculator.C, (double)scaledTruthnessBetter).getOfTrue();
        double expectedDistance = 1.0 - scaledTruthness;
        Assertions.assertEquals((double)expectedDistance, (double)distanceWithMetrics.sqlDistance);
    }
}

