/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql;

import java.util.Map;
import java.util.TreeMap;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.VariableDescriptor;

public class QueryResultSet {
    private final Map<String, QueryResult> queryResults;
    private final boolean isCaseSensitive;
    private QueryResult queryResultForVirtualTable;

    public QueryResultSet() {
        this(true);
    }

    public QueryResultSet(boolean isCaseSensitive) {
        this.queryResults = new TreeMap<String, QueryResult>(isCaseSensitive ? null : String.CASE_INSENSITIVE_ORDER);
        this.isCaseSensitive = isCaseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void addQueryResult(QueryResult queryResult) {
        String tableName = queryResult.seeVariableDescriptors().stream().findFirst().map(VariableDescriptor::getTableName).orElse(null);
        if (tableName == null) {
            this.handleVirtualTable(queryResult);
        } else {
            this.handleNamedTable(tableName, queryResult);
        }
    }

    private void handleNamedTable(String tableName, QueryResult queryResult) {
        if (this.queryResults.containsKey(tableName)) {
            throw new IllegalArgumentException("Duplicate table in QueryResultSet: " + tableName);
        }
        this.queryResults.put(tableName, queryResult);
    }

    private void handleVirtualTable(QueryResult queryResult) {
        if (this.queryResultForVirtualTable != null) {
            throw new IllegalArgumentException("Duplicate values for virtual table");
        }
        this.queryResultForVirtualTable = queryResult;
    }

    public QueryResult getQueryResultForNamedTable(String tableName) {
        return this.queryResults.get(tableName);
    }

    public QueryResult getQueryResultForVirtualTable() {
        return this.queryResultForVirtualTable;
    }
}

