/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import org.evomaster.client.java.controller.api.dto.database.schema.DbInfoDto;
import org.evomaster.client.java.distance.heuristics.Truthness;
import org.evomaster.client.java.distance.heuristics.TruthnessUtils;
import org.evomaster.client.java.sql.DataRow;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.QueryResultSet;
import org.evomaster.client.java.sql.internal.SqlDistanceWithMetrics;
import org.evomaster.client.java.sql.internal.SqlExpressionEvaluator;
import org.evomaster.client.java.sql.internal.SqlNameContext;
import org.evomaster.client.java.sql.internal.SqlParserUtils;
import org.evomaster.client.java.sql.internal.TaintHandler;

public class SqlHeuristicsCalculator {
    public static double C = 0.1;
    public static double C_BETTER = C + C / 2.0;
    public static Truthness TRUE_TRUTHNESS = new Truthness(1.0, C);
    public static Truthness FALSE_TRUTHNESS = TRUE_TRUTHNESS.invert();
    public static Truthness FALSE_TRUTHNESS_BETTER = new Truthness(C_BETTER, 1.0);
    private final QueryResultSet queryResultSet;
    private final SqlNameContext sqlNameContext;

    private SqlHeuristicsCalculator(SqlNameContext sqlNameContext, QueryResult[] data) {
        boolean isCaseSensitive = false;
        this.sqlNameContext = sqlNameContext;
        this.queryResultSet = new QueryResultSet(false);
        for (QueryResult queryResult : data) {
            this.queryResultSet.addQueryResult(queryResult);
        }
    }

    public static SqlDistanceWithMetrics computeDistance(String sqlCommand, DbInfoDto schema, TaintHandler taintHandler, QueryResult ... data) {
        Statement parsedSqlCommand = SqlParserUtils.parseSqlCommand(sqlCommand);
        SqlNameContext sqlNameContext = new SqlNameContext(parsedSqlCommand);
        if (schema != null) {
            sqlNameContext.setSchema(schema);
        }
        SqlHeuristicsCalculator calculator = new SqlHeuristicsCalculator(sqlNameContext, data);
        Truthness t = calculator.computeCommand(parsedSqlCommand);
        double distanceToTrue = 1.0 - t.getOfTrue();
        return new SqlDistanceWithMetrics(distanceToTrue, 0, false);
    }

    private Truthness computeCommand(Statement parsedSqlCommand) {
        Expression whereClause = SqlParserUtils.getWhere(parsedSqlCommand);
        FromItem fromItem = SqlParserUtils.getFrom(parsedSqlCommand);
        List<Join> joins = SqlParserUtils.getJoins(parsedSqlCommand);
        if (fromItem == null && joins == null) {
            return this.getTruthnessForTable(null);
        }
        if (fromItem != null && joins == null && whereClause == null) {
            return this.getTruthnessForTable(fromItem);
        }
        if (fromItem != null && joins == null && whereClause != null) {
            return this.getTruthnessForCondition(whereClause, fromItem);
        }
        if (fromItem != null && joins != null && whereClause == null) {
            Join join = joins.get(0);
            FromItem leftFromItem = fromItem;
            FromItem rightFromItem = join.getRightItem();
            Collection onExpressions = join.getOnExpressions();
            if (join.isLeft()) {
                return this.getTruthnessForTable(leftFromItem);
            }
            if (join.isRight()) {
                return this.getTruthnessForTable(rightFromItem);
            }
            if (join.isCross()) {
                Truthness truthnessLeftTable = this.getTruthnessForTable(leftFromItem);
                Truthness truthnessRightTable = this.getTruthnessForTable(rightFromItem);
                return TruthnessUtils.buildAndAggregationTruthness((Truthness[])new Truthness[]{truthnessLeftTable, truthnessRightTable});
            }
        }
        return null;
    }

    private Truthness getTruthnessForCondition(Expression whereClause, FromItem fromItem) {
        double maxOfTrue = 0.0;
        int rowCount = 0;
        QueryResult queryResult = this.getQueryResultForFromItem(fromItem);
        if (queryResult.isEmpty()) {
            return FALSE_TRUTHNESS;
        }
        for (DataRow row : queryResult.seeRows()) {
            Truthness t = this.getTruthnessForExpression(whereClause, row);
            if (t.isTrue()) {
                return TRUE_TRUTHNESS;
            }
            if (t.getOfTrue() > maxOfTrue) {
                maxOfTrue = t.getOfTrue();
            }
            ++rowCount;
        }
        return TruthnessUtils.buildScaledTruthness((double)C, (double)maxOfTrue);
    }

    private Truthness getTruthnessForExpression(Expression whereClause, DataRow row) {
        SqlExpressionEvaluator expressionEvaluator = new SqlExpressionEvaluator(this.sqlNameContext, row);
        whereClause.accept((ExpressionVisitor)expressionEvaluator);
        return expressionEvaluator.getEvaluatedTruthness();
    }

    private Truthness getTruthnessForTable(FromItem fromItem) {
        QueryResult tableData = this.getQueryResultForFromItem(fromItem);
        int len = tableData.size();
        Truthness t = TruthnessUtils.getTruthnessToEmpty((int)len).invert();
        return t;
    }

    private QueryResult getQueryResultForFromItem(FromItem fromItem) {
        QueryResult tableData;
        if (fromItem == null) {
            tableData = this.queryResultSet.getQueryResultForVirtualTable();
        } else {
            if (!SqlParserUtils.isTable(fromItem)) {
                throw new IllegalArgumentException("Cannot compute Truthness for form item that it is not a table " + fromItem);
            }
            String tableName = SqlParserUtils.getTableName(fromItem);
            tableData = this.queryResultSet.getQueryResultForNamedTable(tableName);
        }
        return tableData;
    }
}

