/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;

public class SqlParserUtils {
    public static boolean isSelect(String sqlCommand) {
        return SqlParserUtils.startsWithIgnoreCase(sqlCommand, "select") && !SqlParserUtils.isASequence(sqlCommand);
    }

    public static boolean isDelete(String sqlCommand) {
        return SqlParserUtils.startsWithIgnoreCase(sqlCommand, "delete");
    }

    public static boolean isUpdate(String sqlCommand) {
        return SqlParserUtils.startsWithIgnoreCase(sqlCommand, "update");
    }

    public static boolean isInsert(String sqlCommand) {
        return SqlParserUtils.startsWithIgnoreCase(sqlCommand, "insert");
    }

    private static boolean startsWithIgnoreCase(String input, String prefix) {
        return input != null && input.trim().toLowerCase().startsWith(prefix);
    }

    private static boolean isASequence(String input) {
        return input != null && input.trim().toLowerCase().matches(".*(currval|nextval).*");
    }

    public static boolean isSelectOne(String sqlCommand) {
        return sqlCommand != null && sqlCommand.trim().toLowerCase().matches("select\\s+-?\\d+\\s*;?");
    }

    public static Expression getWhere(Statement parsedStatement) {
        if (parsedStatement instanceof Select) {
            Select select = (Select)parsedStatement;
            PlainSelect plainSelect = select.getPlainSelect();
            return plainSelect.getWhere();
        }
        if (parsedStatement instanceof Delete) {
            return ((Delete)parsedStatement).getWhere();
        }
        if (parsedStatement instanceof Update) {
            return ((Update)parsedStatement).getWhere();
        }
        throw new IllegalArgumentException("Cannot handle statement: " + parsedStatement.toString());
    }

    public static FromItem getFrom(Statement parsedStatement) {
        if (parsedStatement instanceof Select) {
            Select select = (Select)parsedStatement;
            PlainSelect plainSelect = select.getPlainSelect();
            return plainSelect.getFromItem();
        }
        if (parsedStatement instanceof Delete) {
            return ((Delete)parsedStatement).getTable();
        }
        if (parsedStatement instanceof Update) {
            return ((Update)parsedStatement).getTable();
        }
        throw new IllegalArgumentException("Cannot handle statement: " + parsedStatement.toString());
    }

    public static List<Join> getJoins(Statement parsedStatement) {
        if (parsedStatement instanceof Select) {
            Select select = (Select)parsedStatement;
            PlainSelect plainSelect = select.getPlainSelect();
            return plainSelect.getJoins();
        }
        throw new IllegalArgumentException("Cannot get Joins From: " + parsedStatement.toString());
    }

    public static Statement parseSqlCommand(String sqlCommand) {
        try {
            Statement stmt = CCJSqlParserUtil.parse((String)sqlCommand);
            return stmt;
        }
        catch (JSQLParserException e) {
            throw new IllegalArgumentException("Cannot parse SQL command: " + sqlCommand + "\n" + e.getMessage(), e);
        }
    }

    public static boolean canParseSqlStatement(String sqlCommand) {
        try {
            CCJSqlParserUtil.parse((String)sqlCommand);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isTable(FromItem fromItem) {
        return fromItem instanceof Table;
    }

    public static String getTableName(FromItem fromItem) {
        if (fromItem instanceof Table) {
            Table table = (Table)fromItem;
            return table.getFullyQualifiedName();
        }
        throw new IllegalArgumentException("From item " + fromItem + " is not a table");
    }
}

