/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Collections;
import org.evomaster.client.java.controller.api.dto.database.schema.DatabaseType;
import org.evomaster.client.java.sql.QueryResultTestBase;
import org.evomaster.client.java.sql.SqlScriptRunner;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.testcontainers.containers.GenericContainer;

public class QueryResultPostgresTest
extends QueryResultTestBase {
    private static final String POSTGRES_VERSION = "14";
    private static final GenericContainer<?> postgres = new GenericContainer("postgres:14").withExposedPorts(new Integer[]{5432}).withTmpFs(Collections.singletonMap("/var/lib/postgresql/data", "rw")).withEnv("POSTGRES_HOST_AUTH_METHOD", "trust");
    private static Connection connection;

    @BeforeAll
    public static void initClass() throws Exception {
        postgres.start();
        String host = postgres.getHost();
        int port = postgres.getMappedPort(5432);
        String url = "jdbc:postgresql://" + host + ":" + port + "/postgres";
        connection = DriverManager.getConnection(url, "postgres", "");
    }

    @AfterAll
    public static void afterClass() throws Exception {
        connection.close();
        postgres.stop();
    }

    @BeforeEach
    public void initTest() throws Exception {
        SqlScriptRunner.execCommand((Connection)connection, (String)"DROP SCHEMA public CASCADE;");
        SqlScriptRunner.execCommand((Connection)connection, (String)"CREATE SCHEMA public;");
        SqlScriptRunner.execCommand((Connection)connection, (String)"GRANT ALL ON SCHEMA public TO postgres;");
        SqlScriptRunner.execCommand((Connection)connection, (String)"GRANT ALL ON SCHEMA public TO public;");
    }

    @Override
    protected Connection getConnection() {
        return connection;
    }

    @Override
    protected DatabaseType getDbType() {
        return DatabaseType.POSTGRES;
    }
}

