/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql;

import java.sql.Connection;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.evomaster.client.java.controller.api.dto.database.schema.DatabaseType;
import org.evomaster.client.java.sql.DataRow;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.SqlScriptRunner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public abstract class QueryResultTestBase {
    protected abstract DatabaseType getDbType();

    protected abstract Connection getConnection();

    @Test
    public void testDateColumn() throws Exception {
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE example_table (\n    event_date DATE NOT NULL\n);");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"INSERT INTO example_table (event_date)\nVALUES ('2025-01-22');\n");
        QueryResult queryResult = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM example_table");
        Assertions.assertEquals((int)1, (int)queryResult.seeRows().size());
        DataRow row = (DataRow)queryResult.seeRows().get(0);
        Object actual = row.getValueByName("event_date", "example_table");
        Assertions.assertTrue((boolean)(actual instanceof Date));
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        Date expected = sdf.parse("22/01/2025");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDateTimeColumn() throws Exception {
        Comparable<Date> expected;
        Assumptions.assumeFalse((this.getDbType() == DatabaseType.POSTGRES ? 1 : 0) != 0);
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE example_table (\n    event_date_time DATETIME NOT NULL\n);");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"INSERT INTO example_table (event_date_time)\nVALUES ('2025-01-22 15:30:45');\n");
        QueryResult queryResult = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM example_table");
        Assertions.assertEquals((int)1, (int)queryResult.seeRows().size());
        DataRow row = (DataRow)queryResult.seeRows().get(0);
        Object actual = row.getValueByName("event_date_time", "example_table");
        switch (this.getDbType()) {
            case MYSQL: {
                Assertions.assertTrue((boolean)(actual instanceof LocalDateTime));
                expected = LocalDateTime.of(2025, 1, 22, 15, 30, 45, 0);
                break;
            }
            default: {
                Assertions.assertTrue((boolean)(actual instanceof Timestamp));
                String timestampString = "2025-01-22 15:30:45.0";
                expected = Timestamp.valueOf(timestampString);
            }
        }
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testTimestampColumn() throws Exception {
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE example_table (\n    event_timestamp TIMESTAMP NOT NULL\n);");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"INSERT INTO example_table (event_timestamp)\nVALUES ('2025-01-22 15:30:45');\n");
        QueryResult queryResult = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM example_table");
        Assertions.assertEquals((int)1, (int)queryResult.seeRows().size());
        DataRow row = (DataRow)queryResult.seeRows().get(0);
        Object actual = row.getValueByName("event_timestamp", "example_table");
        Assertions.assertTrue((boolean)(actual instanceof Timestamp));
        String timestampString = "2025-01-22 15:30:45.0";
        Timestamp expected = Timestamp.valueOf(timestampString);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testTimestampWithTimeZoneColumn() throws Exception {
        Comparable<OffsetDateTime> expected;
        Assumptions.assumeFalse((this.getDbType() == DatabaseType.MYSQL ? 1 : 0) != 0);
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE example_table (\n    event_zoned_timestamp TIMESTAMP WITH TIME ZONE NOT NULL\n);");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"INSERT INTO example_table (event_zoned_timestamp)\nVALUES ('2025-01-22 15:30:45+05:30');\n");
        QueryResult queryResult = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM example_table");
        Assertions.assertEquals((int)1, (int)queryResult.seeRows().size());
        DataRow row = (DataRow)queryResult.seeRows().get(0);
        Object actual = row.getValueByName("event_zoned_timestamp", "example_table");
        switch (this.getDbType()) {
            case POSTGRES: {
                LocalDateTime localDateTime = LocalDateTime.of(2025, 1, 22, 15, 30, 45);
                ZoneOffset offset = ZoneOffset.ofHoursMinutes(5, 30);
                ZonedDateTime zonedDateTime = localDateTime.atOffset(offset).toZonedDateTime();
                long epochMilli = zonedDateTime.toInstant().toEpochMilli();
                expected = new Timestamp(epochMilli);
                break;
            }
            default: {
                Assertions.assertTrue((boolean)(actual instanceof OffsetDateTime));
                String dateTimeString = "2025-01-22 15:30:45+05:30";
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ssXXX");
                expected = OffsetDateTime.parse(dateTimeString, formatter);
            }
        }
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testTimeColumn() throws Exception {
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE example_table (\n    time_column TIME NOT NULL\n);");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"INSERT INTO example_table (time_column)\nVALUES ('15:30:45');\n");
        QueryResult queryResult = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM example_table");
        Assertions.assertEquals((int)1, (int)queryResult.seeRows().size());
        DataRow row = (DataRow)queryResult.seeRows().get(0);
        Object actual = row.getValueByName("time_column", "example_table");
        Assertions.assertTrue((boolean)(actual instanceof Time));
        Time expected = Time.valueOf("15:30:45");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testTimeWithTimeZoneColumn() throws Exception {
        Comparable<OffsetTime> expected;
        Assumptions.assumeFalse((this.getDbType() == DatabaseType.MYSQL ? 1 : 0) != 0);
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE example_table (\n    time_column TIME WITH TIME ZONE NOT NULL\n);");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"INSERT INTO example_table (time_column)\nVALUES ('15:30:45+02:00');\n");
        QueryResult queryResult = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT * FROM example_table");
        Assertions.assertEquals((int)1, (int)queryResult.seeRows().size());
        DataRow row = (DataRow)queryResult.seeRows().get(0);
        Object actual = row.getValueByName("time_column", "example_table");
        switch (this.getDbType()) {
            case POSTGRES: {
                OffsetTime offsetTime = OffsetTime.of(15, 30, 45, 0, ZoneOffset.of("+02:00"));
                ZoneId systemZone = ZoneId.systemDefault();
                LocalDate constantDate = LocalDate.of(1970, 1, 1);
                ZonedDateTime zonedDateTime = offsetTime.atDate(constantDate).atZoneSameInstant(systemZone);
                LocalTime systemLocalTime = zonedDateTime.toLocalTime();
                expected = Time.valueOf(systemLocalTime);
                break;
            }
            default: {
                Assertions.assertTrue((boolean)(actual instanceof OffsetTime));
                expected = OffsetTime.of(15, 30, 45, 0, ZoneOffset.ofHours(2));
            }
        }
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testColumnAlias() throws Exception {
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE example_table (\n    first_name VARCHAR(255) NOT NULL,\n    last_name VARCHAR(255) NOT NULL\n);");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"INSERT INTO example_table (first_name, last_name)\nVALUES ('John','Doe');\n");
        QueryResult queryResult = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT first_name AS forename,last_name AS surname FROM example_table");
        Assertions.assertEquals((int)1, (int)queryResult.seeRows().size());
        DataRow row = (DataRow)queryResult.seeRows().get(0);
        Object actual_first_name = row.getValueByName("forename", "example_table");
        Object actual_last_name = row.getValueByName("surname", "example_table");
        Assertions.assertEquals((Object)"John", (Object)actual_first_name);
        Assertions.assertEquals((Object)"Doe", (Object)actual_last_name);
    }

    @Test
    public void testSubqueryNoAlias() throws Exception {
        Assumptions.assumeFalse((this.getDbType() == DatabaseType.MYSQL ? 1 : 0) != 0);
        Assumptions.assumeFalse((this.getDbType() == DatabaseType.POSTGRES ? 1 : 0) != 0);
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE example_table (\n    first_name VARCHAR(255) NOT NULL,\n    last_name VARCHAR(255) NOT NULL\n);");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"INSERT INTO example_table (first_name, last_name)\nVALUES ('John','Doe');\n");
        QueryResult queryResult = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT first_name FROM (SELECT first_name FROM example_table)");
        Assertions.assertEquals((int)1, (int)queryResult.seeRows().size());
        DataRow row = (DataRow)queryResult.seeRows().get(0);
        Object actual_first_name = row.getValueByName("first_name", null);
        Assertions.assertEquals((Object)"John", (Object)actual_first_name);
    }

    @Test
    public void testSubqueryAlias() throws Exception {
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE example_table (\n    first_name VARCHAR(255) NOT NULL,\n    last_name VARCHAR(255) NOT NULL\n);");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"INSERT INTO example_table (first_name, last_name)\nVALUES ('John','Doe');\n");
        QueryResult queryResult = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT 24, 12, first_name FROM (SELECT first_name FROM example_table) subquery");
        Assertions.assertEquals((int)1, (int)queryResult.seeRows().size());
        DataRow row = (DataRow)queryResult.seeRows().get(0);
        Object actual_first_name = row.getValue(2);
        Assertions.assertEquals((Object)"John", (Object)actual_first_name);
    }

    @Test
    public void testSubqueryReference() throws Exception {
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE departments (\n    id INT PRIMARY KEY,\n    name VARCHAR(100) NOT NULL\n);\n");
        SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"CREATE TABLE employees (\n    employee_id INT PRIMARY KEY,\n    name VARCHAR(100) NOT NULL,\n    department_id INT,\n    FOREIGN KEY (department_id) REFERENCES departments(id)\n);\n");
        QueryResult queryResult = SqlScriptRunner.execCommand((Connection)this.getConnection(), (String)"SELECT 1 \nFROM employees e \nWHERE EXISTS (\n    SELECT 1 \n    FROM departments \n    WHERE department_id = employee_id\n);\n");
        Assertions.assertEquals((Object)true, (Object)queryResult.seeRows().isEmpty());
    }
}

