/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.heuristic;

import java.util.Arrays;
import java.util.Collections;
import org.evomaster.client.java.sql.DataRow;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.VariableDescriptor;
import org.evomaster.client.java.sql.heuristic.QueryResultUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class QueryResultUtilsTest {
    QueryResultUtilsTest() {
    }

    @Test
    public void testCreateUnionRowSetWithMultipleQueryResults() {
        QueryResult queryResult1 = new QueryResult(Arrays.asList(new VariableDescriptor("column1", null, null)));
        queryResult1.addRow(Arrays.asList("column1"), null, Arrays.asList("value1"));
        QueryResult queryResult2 = new QueryResult(Arrays.asList(new VariableDescriptor("column1", null, null)));
        queryResult2.addRow(Arrays.asList("column1"), null, Arrays.asList("value2"));
        QueryResult unionResult = QueryResultUtils.createUnionRowSet(Arrays.asList(queryResult1, queryResult2));
        Assertions.assertEquals((int)2, (int)unionResult.seeRows().size());
        Assertions.assertEquals((Object)"value1", ((DataRow)unionResult.seeRows().get(0)).seeValues().get(0));
        Assertions.assertEquals((Object)"value2", ((DataRow)unionResult.seeRows().get(1)).seeValues().get(0));
    }

    @Test
    public void testCreateCartesianProductWithEmptyRightQueryResult() {
        QueryResult left = new QueryResult(Arrays.asList(new VariableDescriptor("leftColumn", null, null)));
        left.addRow(Arrays.asList("leftColumn"), null, Arrays.asList("leftValue"));
        QueryResult right = new QueryResult(Arrays.asList(new VariableDescriptor("rightColumn", null, null)));
        QueryResult result = QueryResultUtils.createCartesianProduct((QueryResult)left, (QueryResult)right);
        Assertions.assertEquals((int)0, (int)result.seeRows().size());
    }

    @Test
    public void testCreateJoinedRowWithDifferentColumnCounts() {
        DataRow leftRow = new DataRow(Arrays.asList(new VariableDescriptor("leftColumn", null, null)), Arrays.asList("leftValue"));
        DataRow rightRow = new DataRow(Arrays.asList(new VariableDescriptor("rightColumn1", null, null), new VariableDescriptor("rightColumn2", null, null)), Arrays.asList("rightValue1", "rightValue2"));
        DataRow joinedRow = QueryResultUtils.createJoinedRow((DataRow)leftRow, (DataRow)rightRow, Arrays.asList(new VariableDescriptor("leftColumn", null, null), new VariableDescriptor("rightColumn1", null, null), new VariableDescriptor("rightColumn2", null, null)));
        Assertions.assertEquals((int)3, (int)joinedRow.seeValues().size());
        Assertions.assertEquals((Object)"leftValue", joinedRow.seeValues().get(0));
        Assertions.assertEquals((Object)"rightValue1", joinedRow.seeValues().get(1));
        Assertions.assertEquals((Object)"rightValue2", joinedRow.seeValues().get(2));
    }

    @Test
    public void testCreateEmptyCartesianProductWithNoColumns() {
        QueryResult left = new QueryResult(Collections.emptyList());
        QueryResult right = new QueryResult(Collections.emptyList());
        QueryResult result = QueryResultUtils.createEmptyCartesianProduct((QueryResult)left, (QueryResult)right);
        Assertions.assertEquals((int)0, (int)result.seeVariableDescriptors().size());
        Assertions.assertEquals((int)0, (int)result.seeRows().size());
    }

    @Test
    public void testCreateDataRowOfNullValuesWithMultipleColumns() {
        QueryResult queryResult = new QueryResult(Arrays.asList(new VariableDescriptor("column1", null, null), new VariableDescriptor("column2", null, null)));
        DataRow nullDataRow = QueryResultUtils.createDataRowOfNullValues((QueryResult)queryResult);
        Assertions.assertEquals((int)2, (int)nullDataRow.seeValues().size());
        Assertions.assertNull(nullDataRow.seeValues().get(0));
        Assertions.assertNull(nullDataRow.seeValues().get(1));
    }
}

