/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.heuristic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;
import org.evomaster.client.java.controller.api.dto.database.schema.ColumnDto;
import org.evomaster.client.java.controller.api.dto.database.schema.DbInfoDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableDto;
import org.evomaster.client.java.distance.heuristics.Truthness;
import org.evomaster.client.java.distance.heuristics.TruthnessUtils;
import org.evomaster.client.java.sql.DataRow;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.QueryResultSet;
import org.evomaster.client.java.sql.VariableDescriptor;
import org.evomaster.client.java.sql.heuristic.SqlColumnReference;
import org.evomaster.client.java.sql.heuristic.SqlDerivedTableReference;
import org.evomaster.client.java.sql.heuristic.SqlHeuristicResult;
import org.evomaster.client.java.sql.heuristic.SqlHeuristicsCalculator;
import org.evomaster.client.java.sql.heuristic.TableColumnResolver;
import org.evomaster.client.java.sql.internal.SqlDistanceWithMetrics;
import org.evomaster.client.java.sql.internal.SqlParserUtils;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SqlHeuristicsCalculatorTest {
    @Test
    public void testSelectFromTableWithRows() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT name FROM Person";
        QueryResult contents = new QueryResult(Collections.singletonList("name"), "Person");
        contents.addRow(new DataRow("name", (Object)"John", "Person"));
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.addQueryResult(contents);
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((Object)true, (Object)heuristicResult.getTruthness().isTrue());
        QueryResult queryResult = heuristicResult.getQueryResult();
        Assertions.assertEquals((int)1, (int)queryResult.seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "person"), queryResult.seeVariableDescriptors().get(0));
    }

    @Test
    public void testSelectWithFalseWhereConditionWithoutFrom() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT 1 AS example_column WHERE 1 = 0";
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        double expectedOfTrue = TruthnessUtils.buildAndAggregationTruthness((Truthness[])new Truthness[]{SqlHeuristicsCalculator.TRUE_TRUTHNESS, new Truthness(SqlHeuristicsCalculator.C, 1.0)}).getOfTrue();
        Assertions.assertEquals((double)expectedOfTrue, (double)heuristicResult.getTruthness().getOfTrue());
        QueryResult queryResult = heuristicResult.getQueryResult();
        Assertions.assertEquals((int)1, (int)queryResult.seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("example_column", "example_column", null), queryResult.seeVariableDescriptors().get(0));
    }

    @Test
    public void testSelectNoFromNeitherWhereClauses() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT 1 AS example_column";
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((Object)true, (Object)heuristicResult.getTruthness().isTrue());
        QueryResult queryResult = heuristicResult.getQueryResult();
        Assertions.assertEquals((int)1, (int)queryResult.seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("example_column", "example_column", null), queryResult.seeVariableDescriptors().get(0));
    }

    @Test
    public void testSelectFromEmptyTable() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT name FROM Person";
        QueryResult contents = new QueryResult(Collections.singletonList("name"), "Person");
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.addQueryResult(contents);
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((Object)false, (Object)heuristicResult.getTruthness().isTrue());
        QueryResult queryResult = heuristicResult.getQueryResult();
        Assertions.assertEquals((int)1, (int)queryResult.seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "person"), queryResult.seeVariableDescriptors().get(0));
        Assertions.assertEquals((int)0, (int)queryResult.seeRows().size());
    }

    @Test
    public void testLeftJoinWithRowsInLeftTable() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT name FROM TableA LEFT JOIN TableB";
        QueryResult leftTable = new QueryResult(Collections.singletonList("name"), "TableA");
        QueryResult rightTable = new QueryResult(Collections.singletonList("name"), "TableB");
        leftTable.addRow(new DataRow("name", (Object)"John", "TableA"));
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.addQueryResult(leftTable);
        queryResultSet.addQueryResult(rightTable);
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((Object)true, (Object)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "tablea"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
    }

    @Test
    public void testRightJoinWithRowsInRightTable() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT name FROM TableA RIGHT JOIN TableB";
        QueryResult leftTable = new QueryResult(Collections.singletonList("name"), "TableA");
        QueryResult rightTable = new QueryResult(Collections.singletonList("name"), "TableB");
        rightTable.addRow(new DataRow("name", (Object)"John", "TableB"));
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.addQueryResult(leftTable);
        queryResultSet.addQueryResult(rightTable);
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((Object)true, (Object)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "tablea"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals(null, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("name"));
    }

    @Test
    public void testRightJoinWithRowsInLeftTable() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT name FROM TableA RIGHT JOIN TableB";
        QueryResult leftTable = new QueryResult(Collections.singletonList("name"), "TableA");
        QueryResult rightTable = new QueryResult(Collections.singletonList("name"), "TableB");
        leftTable.addRow(new DataRow("name", (Object)"John", "TableA"));
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.addQueryResult(leftTable);
        queryResultSet.addQueryResult(rightTable);
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((Object)false, (Object)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "tablea"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((int)0, (int)heuristicResult.getQueryResult().seeRows().size());
    }

    @Test
    public void testLeftJoinWithRowsInRightTable() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT name FROM TableA LEFT JOIN TableB";
        QueryResult leftTable = new QueryResult(Collections.singletonList("name"), "TableA");
        QueryResult rightTable = new QueryResult(Collections.singletonList("name"), "TableB");
        rightTable.addRow(new DataRow("name", (Object)"John", "TableB"));
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.addQueryResult(leftTable);
        queryResultSet.addQueryResult(rightTable);
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((Object)false, (Object)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "tablea"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((int)0, (int)heuristicResult.getQueryResult().seeRows().size());
    }

    @Test
    public void testLeftOuterJoinWithRowsInRightTable() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT name FROM TableA LEFT OUTER JOIN TableB";
        QueryResult leftTable = new QueryResult(Collections.singletonList("name"), "TableA");
        QueryResult rightTable = new QueryResult(Collections.singletonList("name"), "TableB");
        rightTable.addRow(new DataRow("name", (Object)"John", "TableB"));
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.addQueryResult(leftTable);
        queryResultSet.addQueryResult(rightTable);
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        double expectedOfTrue = SqlHeuristicsCalculator.C;
        Assertions.assertEquals((double)expectedOfTrue, (double)heuristicResult.getTruthness().getOfTrue());
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "tablea"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((int)0, (int)heuristicResult.getQueryResult().seeRows().size());
    }

    @Test
    public void testRightOuterJoinWithRowsInLeftTable() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT name FROM TableA RIGHT OUTER JOIN TableB";
        QueryResult leftTable = new QueryResult(Collections.singletonList("name"), "TableA");
        QueryResult rightTable = new QueryResult(Collections.singletonList("name"), "TableB");
        leftTable.addRow(new DataRow("name", (Object)"John", "TableA"));
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.addQueryResult(leftTable);
        queryResultSet.addQueryResult(rightTable);
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        double expectedOfTrue = SqlHeuristicsCalculator.C;
        Assertions.assertEquals((double)expectedOfTrue, (double)heuristicResult.getTruthness().getOfTrue());
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "tablea"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((int)0, (int)heuristicResult.getQueryResult().seeRows().size());
    }

    @Test
    public void testLeftOuterJoinWithRowsInLeftTable() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT name FROM TableA LEFT OUTER JOIN TableB";
        QueryResult leftTable = new QueryResult(Collections.singletonList("name"), "TableA");
        QueryResult rightTable = new QueryResult(Collections.singletonList("name"), "TableB");
        leftTable.addRow(new DataRow("name", (Object)"John", "TableA"));
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.addQueryResult(leftTable);
        queryResultSet.addQueryResult(rightTable);
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((Object)true, (Object)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "tablea"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)"John", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("name"));
    }

    @Test
    public void testRightOuterJoinWithRowsInRightTable() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT name FROM TableA RIGHT OUTER JOIN TableB";
        QueryResult leftTable = new QueryResult(Collections.singletonList("name"), "TableA");
        QueryResult rightTable = new QueryResult(Collections.singletonList("name"), "TableB");
        rightTable.addRow(new DataRow("name", (Object)"John", "TableB"));
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.addQueryResult(leftTable);
        queryResultSet.addQueryResult(rightTable);
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((Object)true, (Object)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "tablea"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals(null, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("name"));
    }

    @Test
    public void testCrossJoinWithEmptyTables() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT name FROM TableA CROSS JOIN TableB";
        QueryResult leftTable = new QueryResult(Collections.singletonList("name"), "TableA");
        QueryResult rightTable = new QueryResult(Collections.singletonList("name"), "TableB");
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{leftTable, rightTable});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        double expectedOfTrue = SqlHeuristicsCalculator.C;
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((double)expectedOfTrue, (double)heuristicResult.getTruthness().getOfTrue());
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "tablea"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((int)0, (int)heuristicResult.getQueryResult().seeRows().size());
    }

    @Test
    public void testCrossJoinWithRows() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT name FROM TableA CROSS JOIN TableB";
        QueryResult leftTable = new QueryResult(Collections.singletonList("name"), "TableA");
        QueryResult rightTable = new QueryResult(Collections.singletonList("name"), "TableB");
        leftTable.addRow(new DataRow("name", (Object)"John", "TableA"));
        rightTable.addRow(new DataRow("name", (Object)"Jack", "TableB"));
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.addQueryResult(leftTable);
        queryResultSet.addQueryResult(rightTable);
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((Object)true, (Object)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "tablea"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)"John", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("name"));
    }

    private static ColumnDto createColumnDto(String columnName) {
        ColumnDto column = new ColumnDto();
        column.name = columnName;
        return column;
    }

    private static TableDto createTableDto(String tableName) {
        TableDto table = new TableDto();
        table.name = tableName;
        return table;
    }

    @Test
    public void testInnerJoin() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT Employees.name, Departments.department_name\nFROM Employees\nJOIN Departments ON Employees.department_id = Departments.department_id";
        QueryResult employees = new QueryResult(Arrays.asList("name", "department_id"), "employees");
        employees.addRow(Arrays.asList("name", "department_id"), "employees", Arrays.asList("John", 1));
        QueryResult departments = new QueryResult(Arrays.asList("department_id", "department_name"), "departments");
        departments.addRow(Arrays.asList("department_id", "department_name"), "departments", Arrays.asList(1, "Sales"));
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.addQueryResult(departments);
        queryResultSet.addQueryResult(employees);
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((Object)true, (Object)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)2, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "employees"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((Object)new VariableDescriptor("department_name", "department_name", "departments"), heuristicResult.getQueryResult().seeVariableDescriptors().get(1));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)"John", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("name"));
        Assertions.assertEquals((Object)"Sales", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("department_name"));
    }

    @Test
    public void testManyInnerJoins() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT Employees.name, Departments.department_name, Projects.project_name\nFROM Employees\nJOIN Departments ON Employees.department_id = Departments.department_id\nJOIN Projects ON Employees.project_id = Projects.project_id";
        QueryResult employees = new QueryResult(Arrays.asList("name", "department_id", "project_id"), "employees");
        employees.addRow(Arrays.asList("name", "department_id", "project_id"), "employees", Arrays.asList("John", 1, 1));
        QueryResult departments = new QueryResult(Arrays.asList("department_id", "department_name"), "departments");
        departments.addRow(Arrays.asList("department_id", "department_name"), "departments", Arrays.asList(1, "Sales"));
        QueryResult projects = new QueryResult(Arrays.asList("project_id", "project_name"), "projects");
        projects.addRow(Arrays.asList("project_id", "project_name"), "projects", Arrays.asList(1, "ProjectX"));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{departments, employees, projects});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((Object)true, (Object)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)3, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "employees"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((Object)new VariableDescriptor("department_name", "department_name", "departments"), heuristicResult.getQueryResult().seeVariableDescriptors().get(1));
        Assertions.assertEquals((Object)new VariableDescriptor("project_name", "project_name", "projects"), heuristicResult.getQueryResult().seeVariableDescriptors().get(2));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)"John", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("name"));
        Assertions.assertEquals((Object)"Sales", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("department_name"));
        Assertions.assertEquals((Object)"ProjectX", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("project_name"));
    }

    @Test
    public void testUnion() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT name FROM Employees UNION SELECT department_name AS name FROM Departments ";
        QueryResult employees = new QueryResult(Collections.singletonList("name"), "Employees");
        employees.addRow(Collections.singletonList("name"), "Employees", Collections.singletonList("John"));
        QueryResult departments = new QueryResult(Collections.singletonList("department_name"), "Departments");
        departments.addRow(Collections.singletonList("department_name"), "Departments", Collections.singletonList("Sales"));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{employees, departments});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((Object)true, (Object)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", null), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((int)2, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)"John", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("name"));
        Assertions.assertEquals((Object)"Sales", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(1)).getValueByName("name"));
    }

    @Test
    public void testCrossJoin() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT Employees.name, Departments.department_name\nFROM Employees\nCROSS JOIN Departments";
        QueryResult employees = new QueryResult(Arrays.asList("name", "department_id"), "employees");
        employees.addRow(Arrays.asList("name", "department_id"), "employees", Arrays.asList("John", 1));
        QueryResult departments = new QueryResult(Arrays.asList("department_id", "department_name"), "departments");
        departments.addRow(Arrays.asList("department_id", "department_name"), "departments", Arrays.asList(1, "Sales"));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{employees, departments});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((Object)true, (Object)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)2, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "employees"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((Object)new VariableDescriptor("department_name", "department_name", "departments"), heuristicResult.getQueryResult().seeVariableDescriptors().get(1));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)"John", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("name"));
        Assertions.assertEquals((Object)"Sales", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("department_name"));
    }

    @NotNull
    private static DbInfoDto buildSchema() {
        DbInfoDto schema = new DbInfoDto();
        TableDto employeesTable = SqlHeuristicsCalculatorTest.createTableDto("Employees");
        employeesTable.columns.add(SqlHeuristicsCalculatorTest.createColumnDto("name"));
        employeesTable.columns.add(SqlHeuristicsCalculatorTest.createColumnDto("first_name"));
        employeesTable.columns.add(SqlHeuristicsCalculatorTest.createColumnDto("department_id"));
        employeesTable.columns.add(SqlHeuristicsCalculatorTest.createColumnDto("project_id"));
        employeesTable.columns.add(SqlHeuristicsCalculatorTest.createColumnDto("salary"));
        TableDto departmentsTable = SqlHeuristicsCalculatorTest.createTableDto("Departments");
        departmentsTable.columns.add(SqlHeuristicsCalculatorTest.createColumnDto("department_id"));
        departmentsTable.columns.add(SqlHeuristicsCalculatorTest.createColumnDto("department_name"));
        TableDto projectsTable = SqlHeuristicsCalculatorTest.createTableDto("Projects");
        projectsTable.columns.add(SqlHeuristicsCalculatorTest.createColumnDto("project_id"));
        projectsTable.columns.add(SqlHeuristicsCalculatorTest.createColumnDto("project_name"));
        TableDto tableA = SqlHeuristicsCalculatorTest.createTableDto("TableA");
        tableA.columns.add(SqlHeuristicsCalculatorTest.createColumnDto("name"));
        TableDto tableB = SqlHeuristicsCalculatorTest.createTableDto("TableB");
        tableA.columns.add(SqlHeuristicsCalculatorTest.createColumnDto("name"));
        TableDto personTable = SqlHeuristicsCalculatorTest.createTableDto("Person");
        personTable.columns.add(SqlHeuristicsCalculatorTest.createColumnDto("name"));
        personTable.columns.add(SqlHeuristicsCalculatorTest.createColumnDto("age"));
        personTable.columns.add(SqlHeuristicsCalculatorTest.createColumnDto("salary"));
        TableDto categoriesTable = SqlHeuristicsCalculatorTest.createTableDto("Categories");
        categoriesTable.columns.add(SqlHeuristicsCalculatorTest.createColumnDto("id"));
        categoriesTable.columns.add(SqlHeuristicsCalculatorTest.createColumnDto("name"));
        categoriesTable.columns.add(SqlHeuristicsCalculatorTest.createColumnDto("parent_id"));
        schema.tables.add(employeesTable);
        schema.tables.add(departmentsTable);
        schema.tables.add(projectsTable);
        schema.tables.add(tableA);
        schema.tables.add(tableB);
        schema.tables.add(personTable);
        schema.tables.add(categoriesTable);
        return schema;
    }

    @Test
    public void testLeftJoin() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT Employees.name, Departments.department_name\nFROM Employees\nLEFT JOIN Departments ON Employees.department_id = Departments.department_id";
        QueryResult employees = new QueryResult(Arrays.asList("name", "department_id"), "employees");
        employees.addRow(Arrays.asList("name", "department_id"), "employees", Arrays.asList("John", 1));
        QueryResult departments = new QueryResult(Arrays.asList("department_id", "department_name"), "departments");
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{employees, departments});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((Object)true, (Object)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)2, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "employees"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((Object)new VariableDescriptor("department_name", "department_name", "departments"), heuristicResult.getQueryResult().seeVariableDescriptors().get(1));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)"John", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("name"));
        Assertions.assertEquals(null, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("department_name"));
    }

    @Test
    public void testRightJoin() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT Employees.name, Departments.department_name\nFROM Employees\nRIGHT JOIN Departments ON Employees.department_id = Departments.department_id";
        QueryResult employees = new QueryResult(Arrays.asList("name", "department_id"), "employees");
        QueryResult departments = new QueryResult(Arrays.asList("department_id", "department_name"), "departments");
        departments.addRow(Arrays.asList("department_id", "department_name"), "departments", Arrays.asList(1, "Sales"));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{employees, departments});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((Object)true, (Object)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)2, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "employees"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((Object)new VariableDescriptor("department_name", "department_name", "departments"), heuristicResult.getQueryResult().seeVariableDescriptors().get(1));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals(null, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("name"));
        Assertions.assertEquals((Object)"Sales", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("department_name"));
    }

    @Test
    public void testSelectFromSubquery() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT name FROM (SELECT name FROM Employees) AS Subquery";
        QueryResult employees = new QueryResult(Collections.singletonList("name"), "Employees");
        employees.addRow(new DataRow("name", (Object)"John", "Employees"));
        Select parsedSqlCommand = (Select)SqlParserUtils.parseSqlCommand((String)sqlCommand);
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{employees});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic(parsedSqlCommand);
        Assertions.assertTrue((boolean)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", null, null), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)"John", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("name"));
    }

    @Test
    public void testSelectWithAlias() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT first_name AS name, salary AS income\n    FROM Employees    WHERE income > 100";
        ArrayList<VariableDescriptor> variableDescriptors = new ArrayList<VariableDescriptor>();
        variableDescriptors.add(new VariableDescriptor("first_name", "name", "employees"));
        variableDescriptors.add(new VariableDescriptor("salary", "income", "employees"));
        QueryResult employees = new QueryResult(variableDescriptors);
        employees.addRow(new DataRow(variableDescriptors, Arrays.asList("John", 10000)));
        Select parsedSqlCommand = (Select)SqlParserUtils.parseSqlCommand((String)sqlCommand);
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{employees});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic(parsedSqlCommand);
        Assertions.assertTrue((boolean)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)2, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("first_name", "name", "employees"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((Object)new VariableDescriptor("salary", "income", "employees"), heuristicResult.getQueryResult().seeVariableDescriptors().get(1));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)"John", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("name"));
        Assertions.assertEquals((Object)10000, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("income"));
    }

    @Test
    public void testSelectFromSubqueryWithAlias() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT name, income\nFROM (\n    SELECT first_name AS name, salary AS income\n    FROM Employees\n) AS subquery\nWHERE income > 100";
        QueryResult employees = new QueryResult(Arrays.asList("first_name", "salary"), "employees");
        employees.addRow(new DataRow("employees", Arrays.asList("first_name", "salary"), Arrays.asList("John", 10000)));
        Select select = (Select)SqlParserUtils.parseSqlCommand((String)sqlCommand);
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.addQueryResult(employees);
        TableColumnResolver tableColumnResolver = new TableColumnResolver(schema);
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(tableColumnResolver).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic(select);
        Assertions.assertTrue((boolean)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)2, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", null), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((Object)new VariableDescriptor("income", "income", null), heuristicResult.getQueryResult().seeVariableDescriptors().get(1));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Table subqueryTable = new Table();
        subqueryTable.setName("subquery");
        Column nameColumn = new Column();
        nameColumn.setTable(subqueryTable);
        nameColumn.setColumnName("name");
        Column incomeColumn = new Column();
        incomeColumn.setTable(subqueryTable);
        incomeColumn.setColumnName("income");
        tableColumnResolver.enterStatementeContext((Statement)select);
        SqlColumnReference nameSqlColumnReference = tableColumnResolver.resolve(nameColumn);
        Assertions.assertTrue((boolean)(nameSqlColumnReference.getTableReference() instanceof SqlDerivedTableReference));
        SqlColumnReference incomeSqlColumnReference = tableColumnResolver.resolve(incomeColumn);
        Assertions.assertTrue((boolean)(incomeSqlColumnReference.getTableReference() instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"John", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName(nameSqlColumnReference.getColumnName()));
        Assertions.assertEquals((Object)10000, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName(incomeSqlColumnReference.getColumnName()));
        tableColumnResolver.exitCurrentStatementContext();
    }

    @Test
    public void testInnerJoinWithAliases() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT e.name, d.department_name\nFROM Employees e\nJOIN Departments d ON e.department_id = d.department_id";
        QueryResult employees = new QueryResult(Arrays.asList("name", "department_id"), "employees");
        employees.addRow(Arrays.asList("name", "department_id"), "employees", Arrays.asList("John", 1));
        QueryResult departments = new QueryResult(Arrays.asList("department_id", "department_name"), "departments");
        departments.addRow(Arrays.asList("department_id", "department_name"), "departments", Arrays.asList(1, "Sales"));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{employees, departments});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlDistanceWithMetrics distanceWithMetrics = calculator.computeDistance(sqlCommand);
        Assertions.assertEquals((double)0.0, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testUnsupportedQuery() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "create cached local temporary table if not exists HT_feature_constraint (id bigint not null) on commit drop transactional";
        QueryResultSet queryResultSet = new QueryResultSet();
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlDistanceWithMetrics distanceWithMetrics = calculator.computeDistance(sqlCommand);
        Assertions.assertEquals((double)Double.MAX_VALUE, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testInnerJoinWithSubqueries() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT e.name, d.department_name\nFROM (SELECT name, department_id FROM Employees) e\nJOIN (SELECT department_id, department_name FROM Departments) d ON e.department_id = d.department_id";
        QueryResult employees = new QueryResult(Arrays.asList("name", "department_id"), "employees");
        employees.addRow(Arrays.asList("name", "department_id"), "employees", Arrays.asList("John", 1));
        QueryResult departments = new QueryResult(Arrays.asList("department_id", "department_name"), "departments");
        departments.addRow(Arrays.asList("department_id", "department_name"), "departments", Arrays.asList(1, "Sales"));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{employees, departments});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertTrue((boolean)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)2, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", null), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((Object)new VariableDescriptor("department_name", "department_name", null), heuristicResult.getQueryResult().seeVariableDescriptors().get(1));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)"John", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("name"));
        Assertions.assertEquals((Object)"Sales", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("department_name"));
    }

    @Test
    public void testDelete() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "DELETE FROM departments WHERE department_id=2";
        QueryResult departments = new QueryResult(Arrays.asList("department_id", "department_name"), "departments");
        departments.addRow(Arrays.asList("department_id", "department_name"), "departments", Arrays.asList(1, "Sales"));
        departments.addRow(Arrays.asList("department_id", "department_name"), "departments", Arrays.asList(2, "Marketing"));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{departments});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Delete)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertTrue((boolean)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)2, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("department_id", "department_id", "departments"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((Object)new VariableDescriptor("department_name", "department_name", "departments"), heuristicResult.getQueryResult().seeVariableDescriptors().get(1));
    }

    @Test
    public void testUpdate() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "UPDATE departments SET department_name='Telemarketing' WHERE department_name='Marketing'";
        QueryResult departments = new QueryResult(Arrays.asList("department_id", "department_name"), "departments");
        departments.addRow(Arrays.asList("department_id", "department_name"), "departments", Arrays.asList(1, "Sales"));
        departments.addRow(Arrays.asList("department_id", "department_name"), "departments", Arrays.asList(2, "Marketing"));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{departments});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Update)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertTrue((boolean)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)2, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("department_id", "department_id", "departments"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((Object)new VariableDescriptor("department_name", "department_name", "departments"), heuristicResult.getQueryResult().seeVariableDescriptors().get(1));
    }

    @Test
    public void testFailOnInsert() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "INSERT INTO departments (department_id,department_name) VALUES (3,'Telemarketing')";
        QueryResult departments = new QueryResult(Arrays.asList("department_id", "department_name"), "departments");
        departments.addRow(Arrays.asList("department_id", "department_name"), "departments", Arrays.asList(1, "Sales"));
        departments.addRow(Arrays.asList("department_id", "department_name"), "departments", Arrays.asList(2, "Marketing"));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{departments});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlDistanceWithMetrics distanceWithMetrics = calculator.computeDistance("INSERT INTO departments (department_id,department_name) VALUES (3,'Telemarketing')");
        Assertions.assertEquals((double)Double.MAX_VALUE, (double)distanceWithMetrics.sqlDistance);
    }

    @Test
    public void testDeleteNoWhere() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "DELETE FROM departments";
        QueryResult departments = new QueryResult(Arrays.asList("department_id", "department_name"), "departments");
        departments.addRow(Arrays.asList("department_id", "department_name"), "departments", Arrays.asList(1, "Sales"));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{departments});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Delete)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertTrue((boolean)heuristicResult.getTruthness().isTrue());
        Assertions.assertEquals((int)2, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("department_id", "department_id", "departments"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((Object)new VariableDescriptor("department_name", "department_name", "departments"), heuristicResult.getQueryResult().seeVariableDescriptors().get(1));
        Assertions.assertEquals((Object)1, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("department_id"));
        Assertions.assertEquals((Object)"Sales", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("department_name"));
    }

    @Test
    public void testSelectNoFromNoWhere() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT 24";
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((Object)true, (Object)heuristicResult.getTruthness().isTrue());
        QueryResult queryResult = heuristicResult.getQueryResult();
        Assertions.assertEquals((int)1, (int)queryResult.seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor(null, null, null), queryResult.seeVariableDescriptors().get(0));
        Assertions.assertEquals((int)1, (int)queryResult.seeRows().size());
        Assertions.assertEquals((int)24, (int)((Number)((DataRow)queryResult.seeRows().get(0)).getValueByName(null)).intValue());
    }

    @Test
    public void testUnionSelectNoFromNoWhere() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT 24 UNION SELECT 42";
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        QueryResult queryResult = heuristicResult.getQueryResult();
        Assertions.assertEquals((int)1, (int)queryResult.seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor(null, null, null), queryResult.seeVariableDescriptors().get(0));
        Assertions.assertEquals((int)2, (int)queryResult.seeRows().size());
        Assertions.assertEquals((int)24, (int)((Number)((DataRow)queryResult.seeRows().get(0)).getValueByName(null)).intValue());
        Assertions.assertEquals((int)42, (int)((Number)((DataRow)queryResult.seeRows().get(1)).getValueByName(null)).intValue());
    }

    @Test
    public void testSelectFromTableWithRowsNoWhere() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT name FROM Person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", 30, 50000)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "person"), heuristicResult.getQueryResult().seeVariableDescriptors().get(0));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        DataRow row = (DataRow)heuristicResult.getQueryResult().seeRows().get(0);
        Assertions.assertEquals((Object)"John", (Object)row.getValueByName("name"));
    }

    @Test
    public void testSelectFromTableWithRowsNoWhereUsingAlias() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT name AS person_name FROM Person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", 30, 50000)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        QueryResult queryResult = heuristicResult.getQueryResult();
        Assertions.assertEquals((int)1, (int)queryResult.seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "person_name", "person"), queryResult.seeVariableDescriptors().iterator().next());
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        DataRow row = (DataRow)heuristicResult.getQueryResult().seeRows().get(0);
        Assertions.assertEquals((Object)"John", (Object)row.getValueByName("person_name"));
    }

    @Test
    public void testSelectAllFromTable() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT * FROM Person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", 30, 50000)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        QueryResult queryResult = heuristicResult.getQueryResult();
        Assertions.assertEquals((int)3, (int)queryResult.seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "person"), queryResult.seeVariableDescriptors().get(0));
        Assertions.assertEquals((Object)new VariableDescriptor("age", "age", "person"), queryResult.seeVariableDescriptors().get(1));
        Assertions.assertEquals((Object)new VariableDescriptor("salary", "salary", "person"), queryResult.seeVariableDescriptors().get(2));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        DataRow row = (DataRow)heuristicResult.getQueryResult().seeRows().get(0);
        Assertions.assertEquals((Object)"John", (Object)row.getValueByName("name"));
        Assertions.assertEquals((Object)30, (Object)row.getValueByName("age"));
        Assertions.assertEquals((Object)50000, (Object)row.getValueByName("salary"));
    }

    @Test
    public void testSelectAllFromSubquery() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT * FROM (SELECT salary, age FROM (SELECT * FROM person))";
        QueryResult personQueryResult = new QueryResult(Arrays.asList("name", "age", "salary"), "person");
        personQueryResult.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", 30, 50000)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{personQueryResult});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        QueryResult queryResult = heuristicResult.getQueryResult();
        Assertions.assertEquals((int)2, (int)queryResult.seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("salary", "salary", null), queryResult.seeVariableDescriptors().get(0));
        Assertions.assertEquals((Object)new VariableDescriptor("age", "age", null), queryResult.seeVariableDescriptors().get(1));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        DataRow row = (DataRow)heuristicResult.getQueryResult().seeRows().get(0);
        Assertions.assertEquals((Object)30, (Object)row.getValueByName("age"));
        Assertions.assertEquals((Object)50000, (Object)row.getValueByName("salary"));
    }

    @Test
    public void testSelfJoin() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT\n  child.name AS category,\n  parent.name AS parent_category\nFROM categories child\nLEFT JOIN categories parent ON child.parent_id = parent.id;\n";
        QueryResult categoriesResultSet = new QueryResult(Arrays.asList("id", "name", "parent_id"), "categories");
        categoriesResultSet.addRow(new DataRow("categories", Arrays.asList("id", "name", "parent_id"), Arrays.asList(1, "Electronics", null)));
        categoriesResultSet.addRow(new DataRow("categories", Arrays.asList("id", "name", "parent_id"), Arrays.asList(2, "Computers", 1)));
        categoriesResultSet.addRow(new DataRow("categories", Arrays.asList("id", "name", "parent_id"), Arrays.asList(3, "Laptops", 2)));
        categoriesResultSet.addRow(new DataRow("categories", Arrays.asList("id", "name", "parent_id"), Arrays.asList(4, "Phones", 1)));
        categoriesResultSet.addRow(new DataRow("categories", Arrays.asList("id", "name", "parent_id"), Arrays.asList(5, "Accessories", 2)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{categoriesResultSet});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        QueryResult queryResult = heuristicResult.getQueryResult();
        Assertions.assertEquals((int)2, (int)queryResult.seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "category", "categories"), queryResult.seeVariableDescriptors().get(0));
        Assertions.assertEquals((Object)new VariableDescriptor("name", "parent_category", "categories"), queryResult.seeVariableDescriptors().get(1));
        List dataRows = heuristicResult.getQueryResult().seeRows();
        Assertions.assertEquals((int)5, (int)dataRows.size());
        Assertions.assertEquals((Object)"Electronics", (Object)((DataRow)dataRows.get(0)).getValueByName("category"));
        Assertions.assertEquals(null, (Object)((DataRow)dataRows.get(0)).getValueByName("parent_category"));
        Assertions.assertEquals((Object)"Computers", (Object)((DataRow)dataRows.get(1)).getValueByName("category"));
        Assertions.assertEquals((Object)"Electronics", (Object)((DataRow)dataRows.get(1)).getValueByName("parent_category"));
        Assertions.assertEquals((Object)"Laptops", (Object)((DataRow)dataRows.get(2)).getValueByName("category"));
        Assertions.assertEquals((Object)"Computers", (Object)((DataRow)dataRows.get(2)).getValueByName("parent_category"));
        Assertions.assertEquals((Object)"Phones", (Object)((DataRow)dataRows.get(3)).getValueByName("category"));
        Assertions.assertEquals((Object)"Electronics", (Object)((DataRow)dataRows.get(3)).getValueByName("parent_category"));
        Assertions.assertEquals((Object)"Accessories", (Object)((DataRow)dataRows.get(4)).getValueByName("category"));
        Assertions.assertEquals((Object)"Computers", (Object)((DataRow)dataRows.get(4)).getValueByName("parent_category"));
    }

    @Test
    public void testLeftJoinWithTable() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT\n  e.*\nFROM employees e\nLEFT JOIN projects p ON e.project_id = p.project_id;\n";
        QueryResult employees = new QueryResult(Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), "employees");
        employees.addRow(Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), "employees", Arrays.asList("John Doe", "John", null, 1, 50000));
        QueryResult projects = new QueryResult(Arrays.asList("project_id", "project_name"), "projects");
        projects.addRow(Arrays.asList("project_id", "project_name"), "projects", Arrays.asList(1, "ProjectX"));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{employees, projects});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        QueryResult queryResult = heuristicResult.getQueryResult();
        Assertions.assertEquals((int)5, (int)queryResult.seeVariableDescriptors().size());
        Assertions.assertEquals((Object)new VariableDescriptor("name", "name", "employees", "e"), queryResult.seeVariableDescriptors().get(0));
        Assertions.assertEquals((Object)new VariableDescriptor("first_name", "first_name", "employees", "e"), queryResult.seeVariableDescriptors().get(1));
        Assertions.assertEquals((Object)new VariableDescriptor("department_id", "department_id", "employees", "e"), queryResult.seeVariableDescriptors().get(2));
        Assertions.assertEquals((Object)new VariableDescriptor("project_id", "project_id", "employees", "e"), queryResult.seeVariableDescriptors().get(3));
        Assertions.assertEquals((Object)new VariableDescriptor("salary", "salary", "employees", "e"), queryResult.seeVariableDescriptors().get(4));
        List dataRows = heuristicResult.getQueryResult().seeRows();
        Assertions.assertEquals((int)1, (int)dataRows.size());
        Assertions.assertEquals((Object)"John Doe", (Object)((DataRow)dataRows.get(0)).getValueByName("name"));
        Assertions.assertEquals((Object)"John", (Object)((DataRow)dataRows.get(0)).getValueByName("first_name"));
        Assertions.assertEquals(null, (Object)((DataRow)dataRows.get(0)).getValueByName("department_id"));
        Assertions.assertEquals((Object)1, (Object)((DataRow)dataRows.get(0)).getValueByName("project_id"));
        Assertions.assertEquals((Object)50000, (Object)((DataRow)dataRows.get(0)).getValueByName("salary"));
    }

    @Test
    public void testNull() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT NULL AS null_value";
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
    }

    @Test
    public void testNullInSubquery() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT * FROM (SELECT NULL UNION ALL SELECT name FROM employees)";
        QueryResult employees = new QueryResult(Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), "employees");
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{employees});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withTableColumnResolver(new TableColumnResolver(schema)).withSourceQueryResultSet(queryResultSet).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals(null, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValue(0));
    }

    @Test
    public void testCaseWhen() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT \n    CASE \n      WHEN age < 18 THEN 'Minor'\n      ELSE 'Adult'\n    END AS age_group\n    FROM person;\n";
        QueryResult personQueryResult = new QueryResult(Arrays.asList("age"), "person");
        personQueryResult.addRow(new DataRow("Person", Arrays.asList("age"), Arrays.asList(17)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{personQueryResult});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withTableColumnResolver(new TableColumnResolver(schema)).withSourceQueryResultSet(queryResultSet).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)"Minor", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValue(0));
    }

    @Test
    public void testCaseWhenElse() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT \n    CASE \n      WHEN age < 18 THEN 'Minor'\n      ELSE 'Adult'\n    END AS age_group\n    FROM person;\n";
        QueryResult personQueryResult = new QueryResult(Arrays.asList("age"), "person");
        personQueryResult.addRow(new DataRow("Person", Arrays.asList("age"), Arrays.asList(21)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{personQueryResult});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withTableColumnResolver(new TableColumnResolver(schema)).withSourceQueryResultSet(queryResultSet).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)"Adult", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValue(0));
    }

    @Test
    public void testCaseSwitch() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT \n    CASE age \n      WHEN 1 THEN 'one year'\n      WHEN 2 THEN 'two years'\n      WHEN 3 THEN 'three years'\n      ELSE 'more than 3 years'\n    END AS age_group\n    FROM person;\n";
        QueryResult personQueryResult = new QueryResult(Arrays.asList("age"), "person");
        personQueryResult.addRow(new DataRow("Person", Arrays.asList("age"), Arrays.asList(2)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{personQueryResult});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withTableColumnResolver(new TableColumnResolver(schema)).withSourceQueryResultSet(queryResultSet).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)"two years", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValue(0));
    }

    @Test
    public void testCaseSwitchElse() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT \n    CASE age \n      WHEN 1 THEN 'one year'\n      WHEN 2 THEN 'two years'\n      WHEN 3 THEN 'three years'\n      ELSE 'more than 3 years'\n    END AS age_group\n    FROM person;\n";
        QueryResult personQueryResult = new QueryResult(Arrays.asList("age"), "person");
        personQueryResult.addRow(new DataRow("Person", Arrays.asList("age"), Arrays.asList(21)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{personQueryResult});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withTableColumnResolver(new TableColumnResolver(schema)).withSourceQueryResultSet(queryResultSet).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeVariableDescriptors().size());
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)"more than 3 years", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValue(0));
    }

    @Test
    public void testCountAllColumnsWhenNonEmpty() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT COUNT(*) AS number_of_persons FROM person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", 30, 50000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jack", 21, 20000)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)2L, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("number_of_persons"));
    }

    @Test
    public void testCountAllColumnsWhenEmpty() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT COUNT(*) AS number_of_persons FROM person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)0L, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("number_of_persons"));
    }

    @Test
    public void testCountAllColumnsWhenNullAndNonNulls() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT COUNT(*) AS number_of_persons FROM person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", 30, 50000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jack", 21, 20000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList(null, null, null)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)3L, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("number_of_persons"));
    }

    @Test
    public void testMaxNonNull() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT MAX(age) AS max_age FROM person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", 30, 50000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jack", 21, 20000)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)30, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("max_age"));
    }

    @Test
    public void testMaxOnlyNullValues() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT MAX(age) AS max_age FROM person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", null, 50000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jack", null, 20000)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals(null, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("max_age"));
    }

    @Test
    public void testMaxNonNullAndNullValues() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT MAX(age) AS max_age FROM person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", null, 50000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jack", 21, 20000)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)21, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("max_age"));
    }

    @Test
    public void testMaxEmptyReturnsNull() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT MAX(age) AS max_age FROM person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals(null, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("max_age"));
    }

    @Test
    public void testMinNonNull() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT MIN(age) AS min_age FROM person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", 30, 50000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jack", 21, 20000)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)21, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("min_age"));
    }

    @Test
    public void testSumOfRealNumbers() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT SUM(salary) AS sum_salary FROM person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", 30, 1000.5)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jack", 21, 500.5)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertNotNull((Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("sum_salary"));
        Assertions.assertTrue((boolean)(((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("sum_salary") instanceof Double));
        double actual = (Double)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("sum_salary");
        Assertions.assertEquals((Double)1501.0, (double)actual);
    }

    @Test
    public void testSumOfIntegerNumbers() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT SUM(salary) AS sum_salary FROM person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", 30, 50000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jack", 21, 20000)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertNotNull((Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("sum_salary"));
        Assertions.assertTrue((boolean)(((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("sum_salary") instanceof Long));
        long actual = (Long)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("sum_salary");
        Assertions.assertEquals((Long)70000L, (long)actual);
    }

    @Test
    public void testCountColumnWhenNonEmpty() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT COUNT(age) AS number_of_persons FROM person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", 30, 50000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jack", 21, 20000)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)2L, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("number_of_persons"));
    }

    @Test
    public void testCountColumnNullAndNonNull() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT COUNT(age) AS number_of_persons FROM person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", 30, 50000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jack", 21, 20000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", null, 20000)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)2L, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("number_of_persons"));
    }

    @Test
    public void testSumOfNullAndNonNullValues() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT SUM(salary) AS sum_salary FROM person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", 30, 50000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jack", 21, 20000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jane", 21, null)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertNotNull((Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("sum_salary"));
        Assertions.assertTrue((boolean)(((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("sum_salary") instanceof Long));
        long actual = (Long)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("sum_salary");
        Assertions.assertEquals((Long)70000L, (long)actual);
    }

    @Test
    public void testSumOfAllNullValues() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT SUM(salary) AS sum_salary FROM person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", 30, null)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jack", 21, null)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jane", 21, null)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertNull((Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("sum_salary"));
    }

    @Test
    public void testSumOfEmptyTable() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT SUM(salary) AS sum_salary FROM person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertNull((Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("sum_salary"));
    }

    @Test
    public void testAvgOfAllNullValues() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT AVG(age) AS avg_age FROM person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", 30, null)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jack", 21, null)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jane", 21, null)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)24L, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("avg_age"));
    }

    @Test
    public void testAvgEmptyTable() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT AVG(age) AS avg_age FROM person";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals(null, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("avg_age"));
    }

    @Test
    public void testMaxInWhere() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT name, salary FROM person WHERE salary=(SELECT MAX(salary) FROM person)";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", 21, 50000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jack", 23, 20000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jane", 31, 50000)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)2, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)"John", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("name"));
        Assertions.assertEquals((Object)50000, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("salary"));
        Assertions.assertEquals((Object)"Jane", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(1)).getValueByName("name"));
        Assertions.assertEquals((Object)50000, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(1)).getValueByName("salary"));
    }

    @Test
    public void testMaxInSelectItem() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT (SELECT MAX(salary) FROM person) AS max_salary, name FROM Person;";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", 21, 50000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jack", 23, 20000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jane", 31, 40000)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)3, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)"John", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("name"));
        Assertions.assertEquals((Object)50000, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("max_salary"));
        Assertions.assertEquals((Object)"Jack", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(1)).getValueByName("name"));
        Assertions.assertEquals((Object)50000, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(1)).getValueByName("max_salary"));
        Assertions.assertEquals((Object)"Jane", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(2)).getValueByName("name"));
        Assertions.assertEquals((Object)50000, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(2)).getValueByName("max_salary"));
    }

    @Test
    public void testMaxInSelectItemWithEmptyTable() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT (SELECT MAX(salary) FROM employees) AS max_salary, name FROM Person;";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", 21, 50000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jack", 23, 20000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jane", 31, 40000)));
        QueryResult employees = new QueryResult(Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), "employees");
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person, employees});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)3, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)"John", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("name"));
        Assertions.assertEquals(null, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("max_salary"));
        Assertions.assertEquals((Object)"Jack", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(1)).getValueByName("name"));
        Assertions.assertEquals(null, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(1)).getValueByName("max_salary"));
        Assertions.assertEquals((Object)"Jane", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(2)).getValueByName("name"));
        Assertions.assertEquals(null, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(2)).getValueByName("max_salary"));
    }

    @Test
    public void testCountInSelectItemWithEmptyTable() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT (SELECT COUNT(*) FROM employees) AS count_employees, name FROM Person;";
        QueryResult person = new QueryResult(Arrays.asList("name", "age", "salary"), "Person");
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("John", 21, 50000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jack", 23, 20000)));
        person.addRow(new DataRow("Person", Arrays.asList("name", "age", "salary"), Arrays.asList("Jane", 31, 40000)));
        QueryResult employees = new QueryResult(Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), "employees");
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{person, employees});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)3, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)"John", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("name"));
        Assertions.assertEquals((Object)0L, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("count_employees"));
        Assertions.assertEquals((Object)"Jack", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(1)).getValueByName("name"));
        Assertions.assertEquals((Object)0L, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(1)).getValueByName("count_employees"));
        Assertions.assertEquals((Object)"Jane", (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(2)).getValueByName("name"));
        Assertions.assertEquals((Object)0L, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(2)).getValueByName("count_employees"));
    }

    @Test
    public void testGroupBy() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT department_id, COUNT(*) As num_employees FROM employees GROUP BY department_id;";
        QueryResult employees = new QueryResult(Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), "employees");
        employees.addRow(new DataRow("employees", Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), Arrays.asList("John Doe", "John", 1, 2, 10000)));
        employees.addRow(new DataRow("employees", Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), Arrays.asList("Jack Doe", "Jack", 1, 3, 10000)));
        employees.addRow(new DataRow("employees", Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), Arrays.asList("Jane Doe", "Jane", 1, 1, 10000)));
        employees.addRow(new DataRow("employees", Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), Arrays.asList("Janet Doe", "Janet", 2, 1, 10000)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{employees});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)2, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((Object)1, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("department_id"));
        Assertions.assertEquals((Object)3L, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(0)).getValueByName("num_employees"));
        Assertions.assertEquals((Object)2, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(1)).getValueByName("department_id"));
        Assertions.assertEquals((Object)1L, (Object)((DataRow)heuristicResult.getQueryResult().seeRows().get(1)).getValueByName("num_employees"));
    }

    @Test
    public void testGroupByMoreThanOneField() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT department_id, project_id, COUNT(*) As employees_per_project FROM employees GROUP BY department_id, project_id;";
        QueryResult employees = new QueryResult(Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), "employees");
        employees.addRow(new DataRow("employees", Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), Arrays.asList("John Doe", "John", 1, 2, 10000)));
        employees.addRow(new DataRow("employees", Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), Arrays.asList("Jack Doe", "Jack", 1, 3, 10000)));
        employees.addRow(new DataRow("employees", Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), Arrays.asList("Jane Doe", "Jane", 1, 3, 10000)));
        employees.addRow(new DataRow("employees", Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), Arrays.asList("Janet Doe", "Janet", 2, 1, 10000)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{employees});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)3, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((long)1L, (long)heuristicResult.getQueryResult().seeRows().stream().filter(row -> row.getValueByName("department_id").equals(1)).filter(row -> row.getValueByName("project_id").equals(2)).filter(row -> row.getValueByName("employees_per_project").equals(1L)).count());
        Assertions.assertEquals((long)1L, (long)heuristicResult.getQueryResult().seeRows().stream().filter(row -> row.getValueByName("department_id").equals(1)).filter(row -> row.getValueByName("project_id").equals(3)).filter(row -> row.getValueByName("employees_per_project").equals(2L)).count());
        Assertions.assertEquals((long)1L, (long)heuristicResult.getQueryResult().seeRows().stream().filter(row -> row.getValueByName("department_id").equals(2)).filter(row -> row.getValueByName("project_id").equals(1)).filter(row -> row.getValueByName("employees_per_project").equals(1L)).count());
    }

    @Test
    public void testGroupByWithHaving() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT department_id, project_id, COUNT(*) As employees_per_project FROM employees GROUP BY department_id, project_id HAVING COUNT(*) > 1;";
        QueryResult employees = new QueryResult(Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), "employees");
        employees.addRow(new DataRow("employees", Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), Arrays.asList("John Doe", "John", 1, 2, 10000)));
        employees.addRow(new DataRow("employees", Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), Arrays.asList("Jack Doe", "Jack", 1, 3, 10000)));
        employees.addRow(new DataRow("employees", Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), Arrays.asList("Jane Doe", "Jane", 1, 3, 10000)));
        employees.addRow(new DataRow("employees", Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), Arrays.asList("Janet Doe", "Janet", 2, 1, 10000)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{employees});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)1, (int)heuristicResult.getQueryResult().seeRows().size());
        Assertions.assertEquals((long)1L, (long)heuristicResult.getQueryResult().seeRows().stream().filter(row -> row.getValueByName("department_id").equals(1)).filter(row -> row.getValueByName("project_id").equals(3)).filter(row -> row.getValueByName("employees_per_project").equals(2L)).count());
    }

    @Test
    public void testGroupByWithHavingNotSatisfied() {
        DbInfoDto schema = SqlHeuristicsCalculatorTest.buildSchema();
        String sqlCommand = "SELECT department_id, COUNT(*) As employees_per_department FROM employees GROUP BY department_id HAVING COUNT(*) = 2;";
        QueryResult employees = new QueryResult(Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), "employees");
        employees.addRow(new DataRow("employees", Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), Arrays.asList("John Doe", "John", 1, 2, 10000)));
        employees.addRow(new DataRow("employees", Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), Arrays.asList("Jack Doe", "Jack", 1, 3, 10000)));
        employees.addRow(new DataRow("employees", Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), Arrays.asList("Jane Doe", "Jane", 1, 3, 10000)));
        employees.addRow(new DataRow("employees", Arrays.asList("name", "first_name", "department_id", "project_id", "salary"), Arrays.asList("Janet Doe", "Janet", 2, 1, 10000)));
        QueryResultSet queryResultSet = QueryResultSet.build((QueryResult[])new QueryResult[]{employees});
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator calculator = builder.withSourceQueryResultSet(queryResultSet).withTableColumnResolver(new TableColumnResolver(schema)).build();
        SqlHeuristicResult heuristicResult = calculator.computeHeuristic((Select)SqlParserUtils.parseSqlCommand((String)sqlCommand));
        Assertions.assertEquals((int)0, (int)heuristicResult.getQueryResult().seeRows().size());
        Truthness expectedTruthness = TruthnessUtils.buildAndAggregationTruthness((Truthness[])new Truthness[]{new Truthness(1.0, 0.2), TruthnessUtils.buildOrAggregationTruthness((Truthness[])new Truthness[]{new Truthness(0.575, 1.0), new Truthness(0.575, 1.0)})});
        Assertions.assertEquals((double)expectedTruthness.getOfTrue(), (double)heuristicResult.getTruthness().getOfTrue());
        Assertions.assertEquals((double)expectedTruthness.getOfFalse(), (double)heuristicResult.getTruthness().getOfFalse());
    }
}

