/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.heuristic;

import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;
import org.evomaster.client.java.sql.heuristic.SqlBaseTableReference;
import org.evomaster.client.java.sql.heuristic.SqlDerivedTableReference;
import org.evomaster.client.java.sql.heuristic.SqlTableReference;
import org.evomaster.client.java.sql.heuristic.TableAliasResolver;
import org.evomaster.client.java.sql.internal.SqlTableId;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TableAliasResolverTest {
    TableAliasResolverTest() {
    }

    @Test
    public void resolvesSimpleTableAlias() throws Exception {
        String sql = "SELECT * FROM Employees e";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)select);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertEquals((Object)new SqlTableId("Employees"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("e")).getTableId());
        resolver.exitTableAliasContext();
        Assertions.assertEquals((int)0, (int)resolver.getContextDepth());
    }

    @Test
    public void resolvesAliasInSubquery() throws Exception {
        String sql = "SELECT * FROM (SELECT * FROM Employees) AS subquery";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)select);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("subquery"));
        SqlTableReference sqlTableReference = resolver.resolveTableReference("subquery");
        Assertions.assertTrue((boolean)(sqlTableReference instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"SELECT * FROM Employees", (Object)((SqlDerivedTableReference)sqlTableReference).getSelect().getPlainSelect().toString());
        ParenthesedSelect parenthesedSelect = (ParenthesedSelect)((SqlDerivedTableReference)sqlTableReference).getSelect();
        Assertions.assertEquals((Object)"subquery", (Object)parenthesedSelect.getAlias().getName());
        Assertions.assertEquals((int)1, (int)resolver.getContextDepth());
        resolver.enterTableAliasContext((Statement)parenthesedSelect.getPlainSelect());
        Assertions.assertEquals((int)2, (int)resolver.getContextDepth());
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("subquery"));
        resolver.exitTableAliasContext();
        resolver.exitTableAliasContext();
        Assertions.assertEquals((int)0, (int)resolver.getContextDepth());
    }

    @Test
    public void resolvesAliasInJoin() throws Exception {
        String sql = "SELECT * FROM Employees e JOIN Departments d ON e.department_id = d.department_id";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)select);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("d"));
        Assertions.assertEquals((Object)new SqlTableId("Employees"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("e")).getTableId());
        Assertions.assertEquals((Object)new SqlTableId("Departments"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("d")).getTableId());
        resolver.exitTableAliasContext();
        Assertions.assertEquals((int)0, (int)resolver.getContextDepth());
    }

    @Test
    public void resolvesAliasInNestedSubquery() throws Exception {
        String sql = "SELECT * FROM (SELECT * FROM (SELECT * FROM Employees) AS subquery1) AS subquery2";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)select);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("subquery2"));
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("subquery1"));
        Assertions.assertEquals((Object)"SELECT * FROM (SELECT * FROM Employees) AS subquery1", (Object)((SqlDerivedTableReference)resolver.resolveTableReference("subquery2")).getSelect().getPlainSelect().toString());
        PlainSelect subquery2 = ((SqlDerivedTableReference)resolver.resolveTableReference("subquery2")).getSelect().getPlainSelect();
        resolver.enterTableAliasContext((Statement)subquery2);
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("subquery2"));
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("subquery1"));
        Assertions.assertEquals((Object)"SELECT * FROM Employees", (Object)((SqlDerivedTableReference)resolver.resolveTableReference("subquery1")).getSelect().getPlainSelect().toString());
        PlainSelect selectFromEmployees = ((SqlDerivedTableReference)resolver.resolveTableReference("subquery1")).getSelect().getPlainSelect();
        resolver.enterTableAliasContext((Statement)selectFromEmployees);
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("subquery2"));
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("subquery1"));
        Assertions.assertEquals((int)3, (int)resolver.getContextDepth());
        resolver.exitTableAliasContext();
        resolver.exitTableAliasContext();
        resolver.exitTableAliasContext();
        Assertions.assertEquals((int)0, (int)resolver.getContextDepth());
    }

    @Test
    public void resolvesAliasInUnion() throws Exception {
        String sql = "SELECT * FROM Employees e UNION SELECT * FROM Departments d";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)select);
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("d"));
        resolver.enterTableAliasContext((Statement)select.getSetOperationList().getSelects().get(0));
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("d"));
        Assertions.assertEquals((Object)new SqlTableId("Employees"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("e")).getTableId());
        resolver.exitTableAliasContext();
        resolver.enterTableAliasContext((Statement)select.getSetOperationList().getSelects().get(1));
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("d"));
        Assertions.assertEquals((Object)new SqlTableId("Departments"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("d")).getTableId());
        resolver.exitTableAliasContext();
        resolver.exitTableAliasContext();
        Assertions.assertEquals((int)0, (int)resolver.getContextDepth());
    }

    @Test
    public void resolvesAliasInWithClause() throws Exception {
        String sql = "WITH subquery AS (SELECT * FROM Employees) SELECT * FROM subquery";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)select);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("subquery"));
        Select subquery = ((SqlDerivedTableReference)resolver.resolveTableReference("subquery")).getSelect();
        Assertions.assertEquals((Object)"(SELECT * FROM Employees)", (Object)subquery.toString());
        resolver.enterTableAliasContext((Statement)subquery);
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("subquery"));
        String innerSql = "SELECT * FROM subquery";
        Select innerSelect = (Select)CCJSqlParserUtil.parse((String)innerSql);
        resolver.exitTableAliasContext();
        resolver.enterTableAliasContext((Statement)innerSelect);
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("subquery"));
        resolver.exitTableAliasContext();
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("subquery"));
        resolver.exitTableAliasContext();
        Assertions.assertEquals((int)0, (int)resolver.getContextDepth());
    }

    @Test
    public void resolvesAliasInComplexJoin() throws Exception {
        String sql = "SELECT * FROM Employees e JOIN (SELECT * FROM Departments) d ON e.department_id = d.department_id";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)select);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("d"));
        Assertions.assertEquals((Object)new SqlTableId("Employees"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("e")).getTableId());
        Assertions.assertEquals((Object)"SELECT * FROM Departments", (Object)((SqlDerivedTableReference)resolver.resolveTableReference("d")).getSelect().getPlainSelect().toString());
        PlainSelect subSelect = ((SqlDerivedTableReference)resolver.resolveTableReference("d")).getSelect().getPlainSelect();
        resolver.enterTableAliasContext((Statement)subSelect);
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("d"));
        resolver.exitTableAliasContext();
        resolver.exitTableAliasContext();
        Assertions.assertEquals((int)0, (int)resolver.getContextDepth());
    }

    @Test
    public void resolvesAliasInMultipleWithClauses() throws Exception {
        String sql = "WITH subquery1 AS (SELECT * FROM Employees), subquery2 AS (SELECT * FROM Departments) SELECT * FROM subquery1, subquery2";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)select);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("subquery1"));
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("subquery2"));
        Select subquery1 = ((SqlDerivedTableReference)resolver.resolveTableReference("subquery1")).getSelect();
        Assertions.assertEquals((Object)"(SELECT * FROM Employees)", (Object)subquery1.toString());
        Select subquery2 = ((SqlDerivedTableReference)resolver.resolveTableReference("subquery2")).getSelect();
        Assertions.assertEquals((Object)"(SELECT * FROM Departments)", (Object)subquery2.toString());
        resolver.enterTableAliasContext((Statement)subquery1);
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("subquery1"));
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("subquery2"));
        resolver.exitTableAliasContext();
        resolver.enterTableAliasContext((Statement)subquery2);
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("subquery1"));
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("subquery2"));
        resolver.exitTableAliasContext();
        String query = "SELECT * FROM subquery1, subquery2";
        Select selectFrom = (Select)CCJSqlParserUtil.parse((String)query);
        resolver.enterTableAliasContext((Statement)selectFrom);
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("subquery1"));
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("subquery2"));
    }

    @Test
    public void resolvesAliasInNestedWithClauses() throws Exception {
        String sql = "WITH subquery1 AS (WITH subquery2 AS (SELECT * FROM Departments) SELECT * FROM subquery2) SELECT * FROM subquery1";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)select);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("subquery1"));
        Select subquery1 = ((SqlDerivedTableReference)resolver.resolveTableReference("subquery1")).getSelect();
        Assertions.assertEquals((Object)"(WITH subquery2 AS (SELECT * FROM Departments) SELECT * FROM subquery2)", (Object)subquery1.toString());
        resolver.enterTableAliasContext((Statement)subquery1.getPlainSelect());
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("subquery2"));
        Select subquery2 = ((SqlDerivedTableReference)resolver.resolveTableReference("subquery2")).getSelect();
        Assertions.assertEquals((Object)"(SELECT * FROM Departments)", (Object)subquery2.toString());
        resolver.exitTableAliasContext();
        resolver.exitTableAliasContext();
        Assertions.assertEquals((int)0, (int)resolver.getContextDepth());
    }

    @Test
    public void resolvesAliasInComplexUnion() throws Exception {
        String sql = "SELECT * FROM Employees e UNION SELECT * FROM (SELECT * FROM Departments) d";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)select);
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("d"));
        resolver.enterTableAliasContext((Statement)select.getSetOperationList().getSelects().get(0));
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("d"));
        Assertions.assertEquals((Object)new SqlTableId("Employees"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("e")).getTableId());
        resolver.exitTableAliasContext();
        resolver.enterTableAliasContext((Statement)select.getSetOperationList().getSelects().get(1));
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("d"));
        Assertions.assertEquals((Object)"SELECT * FROM Departments", (Object)((SqlDerivedTableReference)resolver.resolveTableReference("d")).getSelect().getPlainSelect().toString());
        PlainSelect subSelect = ((SqlDerivedTableReference)resolver.resolveTableReference("d")).getSelect().getPlainSelect();
        resolver.enterTableAliasContext((Statement)subSelect);
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("d"));
        Assertions.assertEquals((int)3, (int)resolver.getContextDepth());
        resolver.exitTableAliasContext();
        resolver.exitTableAliasContext();
        resolver.exitTableAliasContext();
        Assertions.assertEquals((int)0, (int)resolver.getContextDepth());
    }

    @Test
    public void resolvesAliasInSubqueryWithJoin() throws Exception {
        String sql = "SELECT * FROM (SELECT e.name, d.name FROM Employees e JOIN Departments d ON e.department_id = d.department_id) AS subquery";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)select);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("subquery"));
        PlainSelect subquery = ((SqlDerivedTableReference)resolver.resolveTableReference("subquery")).getSelect().getPlainSelect();
        Assertions.assertEquals((Object)"SELECT e.name, d.name FROM Employees e JOIN Departments d ON e.department_id = d.department_id", (Object)subquery.toString());
        resolver.enterTableAliasContext((Statement)subquery);
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("subquery"));
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("d"));
        Assertions.assertEquals((Object)new SqlTableId("Employees"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("e")).getTableId());
        Assertions.assertEquals((Object)new SqlTableId("Departments"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("d")).getTableId());
        resolver.exitTableAliasContext();
        resolver.exitTableAliasContext();
        Assertions.assertEquals((int)0, (int)resolver.getContextDepth());
    }

    @Test
    public void resolvesDuplicateAlias() throws Exception {
        String sql = "SELECT e.first_name, d.department_name FROM (     SELECT id, first_name, department_id     FROM employees e     WHERE e.status = 'active' ) e JOIN (     SELECT id, department_name     FROM departments e     WHERE e.is_active = 1 ) d ON e.department_id = d.id";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)select);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("d"));
        Assertions.assertTrue((boolean)(resolver.resolveTableReference("e") instanceof SqlDerivedTableReference));
        Assertions.assertTrue((boolean)(resolver.resolveTableReference("d") instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"SELECT id, first_name, department_id FROM employees e WHERE e.status = 'active'", (Object)((SqlDerivedTableReference)resolver.resolveTableReference("e")).getSelect().getPlainSelect().toString());
        Assertions.assertEquals((Object)"SELECT id, department_name FROM departments e WHERE e.is_active = 1", (Object)((SqlDerivedTableReference)resolver.resolveTableReference("d")).getSelect().getPlainSelect().toString());
        PlainSelect e = ((SqlDerivedTableReference)resolver.resolveTableReference("e")).getSelect().getPlainSelect();
        PlainSelect d = ((SqlDerivedTableReference)resolver.resolveTableReference("d")).getSelect().getPlainSelect();
        resolver.enterTableAliasContext((Statement)e);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("d"));
        Assertions.assertTrue((boolean)(resolver.resolveTableReference("e") instanceof SqlBaseTableReference));
        Assertions.assertEquals((Object)new SqlTableId("employees"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("e")).getTableId());
        resolver.exitTableAliasContext();
        resolver.enterTableAliasContext((Statement)d);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertFalse((boolean)resolver.isAliasDeclaredInCurrentContext("d"));
        Assertions.assertEquals((Object)new SqlTableId("departments"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("e")).getTableId());
        resolver.exitTableAliasContext();
        resolver.exitTableAliasContext();
        Assertions.assertEquals((int)0, (int)resolver.getContextDepth());
    }

    @Test
    public void resolvesAliasInDeleteStatement() throws Exception {
        String sql = "DELETE FROM Employees e WHERE e.department_id = 1";
        Delete delete = (Delete)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)delete);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertEquals((Object)new SqlTableId("Employees"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("e")).getTableId());
        resolver.exitTableAliasContext();
        Assertions.assertEquals((int)0, (int)resolver.getContextDepth());
    }

    @Test
    public void resolvesAliasInUpdateStatement() throws Exception {
        String sql = "UPDATE Employees e SET e.salary = e.salary * 1.1 WHERE e.department_id = 1";
        Update update = (Update)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)update);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertEquals((Object)new SqlTableId("Employees"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("e")).getTableId());
        resolver.exitTableAliasContext();
        Assertions.assertEquals((int)0, (int)resolver.getContextDepth());
    }

    @Test
    public void resolvesAliasInDeleteWithJoin() throws Exception {
        String sql = "DELETE e FROM Employees e JOIN Departments d ON e.department_id = d.id WHERE d.name = 'HR'";
        Delete delete = (Delete)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)delete);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("d"));
        Assertions.assertEquals((Object)new SqlTableId("Employees"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("e")).getTableId());
        Assertions.assertEquals((Object)new SqlTableId("Departments"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("d")).getTableId());
        resolver.exitTableAliasContext();
        Assertions.assertEquals((int)0, (int)resolver.getContextDepth());
    }

    @Test
    public void resolvesAliasInUpdateWithJoin() throws Exception {
        String sql = "UPDATE Employees e JOIN Departments d ON e.department_id = d.id SET e.salary = e.salary * 1.1 WHERE d.name = 'Engineering'";
        Update update = (Update)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)update);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("d"));
        Assertions.assertEquals((Object)new SqlTableId("Employees"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("e")).getTableId());
        Assertions.assertEquals((Object)new SqlTableId("Departments"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("d")).getTableId());
        resolver.exitTableAliasContext();
        Assertions.assertEquals((int)0, (int)resolver.getContextDepth());
    }

    @Test
    public void resolvesAliasInDeleteWithWithClause() throws Exception {
        String sql = "WITH dept_to_delete AS (SELECT id FROM Departments WHERE name = 'HR') DELETE FROM Employees e WHERE e.department_id IN (SELECT id FROM dept_to_delete)";
        Delete delete = (Delete)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)delete);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("dept_to_delete"));
        SqlTableReference withTableReference = resolver.resolveTableReference("dept_to_delete");
        Assertions.assertTrue((boolean)(withTableReference instanceof SqlDerivedTableReference));
        Assertions.assertEquals((Object)"SELECT id FROM Departments WHERE name = 'HR'", (Object)((SqlDerivedTableReference)withTableReference).getSelect().getPlainSelect().toString());
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertEquals((Object)new SqlTableId("Employees"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("e")).getTableId());
        resolver.exitTableAliasContext();
        Assertions.assertEquals((int)0, (int)resolver.getContextDepth());
    }

    @Test
    public void resolvesAliasInMultiTableDelete() throws Exception {
        String sql = "DELETE e, d FROM Employees e JOIN Departments d ON e.department_id = d.id WHERE d.name = 'HR'";
        Delete delete = (Delete)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)delete);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("d"));
        Assertions.assertEquals((Object)new SqlTableId("Employees"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("e")).getTableId());
        Assertions.assertEquals((Object)new SqlTableId("Departments"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("d")).getTableId());
        resolver.exitTableAliasContext();
        Assertions.assertEquals((int)0, (int)resolver.getContextDepth());
    }

    @Test
    public void resolvesAliasInSelectWithInSubquery() throws Exception {
        String sql = "SELECT e.first_name FROM Employees e WHERE e.department_id IN (SELECT d.id FROM Departments d WHERE d.name = 'HR')";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)select);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertEquals((Object)new SqlTableId("Employees"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("e")).getTableId());
        InExpression inExpression = (InExpression)((PlainSelect)select).getWhere();
        Select subquery = (Select)inExpression.getRightExpression();
        resolver.enterTableAliasContext((Statement)subquery);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("d"));
        Assertions.assertEquals((Object)new SqlTableId("Departments"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("d")).getTableId());
        resolver.exitTableAliasContext();
        resolver.exitTableAliasContext();
        Assertions.assertEquals((int)0, (int)resolver.getContextDepth());
    }

    @Test
    public void resolvesAliasCaseInsensitivity() throws Exception {
        String sql = "SELECT * FROM Employees e";
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        TableAliasResolver resolver = new TableAliasResolver();
        resolver.enterTableAliasContext((Statement)select);
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("e"));
        Assertions.assertTrue((boolean)resolver.isAliasDeclaredInCurrentContext("E"));
        Assertions.assertEquals((Object)new SqlTableId("Employees"), (Object)((SqlBaseTableReference)resolver.resolveTableReference("e")).getTableId());
        resolver.exitTableAliasContext();
        Assertions.assertEquals((int)0, (int)resolver.getContextDepth());
    }
}

