/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import org.evomaster.client.java.sql.internal.SqlParserUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class SqlParserUtilsTest {
    @Test
    public void testEscapeInput() {
        Assertions.assertTrue((boolean)SqlParserUtils.canParseSqlStatement((String)"SELECT * FROM Foo WHERE x LIKE '$a' ESCAPE '$'"));
        Assertions.assertTrue((boolean)SqlParserUtils.canParseSqlStatement((String)"SELECT * FROM Foo WHERE x LIKE  ?1 ESCAPE '$'"));
        Assertions.assertTrue((boolean)SqlParserUtils.canParseSqlStatement((String)"SELECT * FROM Foo WHERE x LIKE '$a' ESCAPE ?1"));
        Assertions.assertTrue((boolean)SqlParserUtils.canParseSqlStatement((String)"SELECT * FROM Foo WHERE x LIKE ?1 ESCAPE ?2"));
    }

    @Test
    public void testRestartSequence() {
        String sql = "ALTER SEQUENCE SYSTEM_SEQUENCE_40560F88_80C4_4F3B_BDAA_D18CC8D5C5AA RESTART WITH 1";
        boolean parsed = SqlParserUtils.canParseSqlStatement((String)sql);
        Assertions.assertTrue((boolean)parsed);
    }

    @Test
    public void testEmptyInsertValue() {
        String sql = "INSERT INTO Foo() VALUES()";
        boolean parsed = SqlParserUtils.canParseSqlStatement((String)sql);
        Assertions.assertFalse((boolean)parsed);
    }

    @ParameterizedTest
    @ValueSource(strings={"SELECT 1", "SELECT 1;", "Select    1;", "Select 1 ; "})
    public void testSelectOne(String sql) throws JSQLParserException {
        Statement s = CCJSqlParserUtil.parse((String)sql);
        Assertions.assertNotNull((Object)s);
        Expression where = SqlParserUtils.getWhere((Statement)s);
        Assertions.assertNull((Object)where);
        boolean isSelectOne = SqlParserUtils.isSelectOne((String)sql);
        Assertions.assertTrue((boolean)isSelectOne);
    }

    @Test
    public void testOnConflictPostgresql() {
        SqlParserUtils.parseSqlCommand((String)"INSERT INTO vets VALUES (1, 'James', 'Carter') ON CONFLICT DO NOTHING;");
    }

    @ParameterizedTest
    @ValueSource(strings={"SELECT -42;", "SELECT -1;", "Select 10;", "Select -0;", "SELECT 0;"})
    public void testMoreThanSelectOne(String sql) throws JSQLParserException {
        Statement s = CCJSqlParserUtil.parse((String)sql);
        Assertions.assertNotNull((Object)s);
        Expression where = SqlParserUtils.getWhere((Statement)s);
        Assertions.assertNull((Object)where);
        boolean isSelectOne = SqlParserUtils.isSelectOne((String)sql);
        Assertions.assertTrue((boolean)isSelectOne);
    }
}

