/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.VariableDescriptor;

public class QueryResultSet {
    private final Map<String, QueryResult> queryResults = new TreeMap<String, QueryResult>(String.CASE_INSENSITIVE_ORDER);

    public static QueryResultSet build(QueryResult ... data) {
        QueryResultSet queryResultSet = new QueryResultSet();
        for (QueryResult queryResult : data) {
            queryResultSet.addQueryResult(queryResult);
        }
        return queryResultSet;
    }

    private static boolean hasMultipleTableNames(QueryResult queryResult) {
        long distinctTableCount = queryResult.seeVariableDescriptors().stream().map(VariableDescriptor::getTableName).filter(Objects::nonNull).distinct().count();
        return distinctTableCount > 1L;
    }

    public void addQueryResult(QueryResult queryResult) {
        if (QueryResultSet.hasMultipleTableNames(queryResult)) {
            throw new IllegalArgumentException("Cannot add a query result with multiple table names");
        }
        String tableName = queryResult.seeVariableDescriptors().stream().findFirst().map(VariableDescriptor::getTableName).orElse(null);
        if (tableName == null) {
            throw new IllegalArgumentException("Cannot add a query result without table name");
        }
        this.handleNamedTable(tableName, queryResult);
    }

    private void handleNamedTable(String tableName, QueryResult queryResult) {
        Objects.requireNonNull(tableName);
        String lowerCaseTableName = tableName.toLowerCase();
        if (this.queryResults.containsKey(lowerCaseTableName)) {
            throw new IllegalArgumentException("Duplicate table in QueryResultSet: " + tableName);
        }
        this.queryResults.put(lowerCaseTableName, queryResult);
    }

    public QueryResult getQueryResultForNamedTable(String tableName) {
        Objects.requireNonNull(tableName);
        return this.queryResults.get(tableName.toLowerCase());
    }
}

