/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.heuristic;

import java.sql.Time;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Date;
import java.util.Objects;
import org.evomaster.client.java.distance.heuristics.Truthness;
import org.evomaster.client.java.sql.heuristic.SqlHeuristicsCalculator;
import org.evomaster.client.java.sql.internal.ColumnTypeParser;

public class ConversionHelper {
    public static Instant convertToInstant(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Time) {
            String timeAsString = object.toString();
            return ColumnTypeParser.getAsInstant(timeAsString);
        }
        if (object instanceof java.sql.Date) {
            String dateAsString = object.toString();
            return ColumnTypeParser.getAsInstant(dateAsString);
        }
        if (object instanceof Date) {
            return ((Date)object).toInstant();
        }
        if (object instanceof OffsetDateTime) {
            return ((OffsetDateTime)object).toInstant();
        }
        if (object instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)object;
            LocalDate localDate = LocalDate.of(1970, 1, 1);
            LocalDateTime localDateTime = LocalDateTime.of(localDate, offsetTime.toLocalTime());
            OffsetDateTime offsetDateTime = localDateTime.atOffset(offsetTime.getOffset());
            return offsetDateTime.toInstant();
        }
        if (object instanceof Long) {
            Long year = (Long)object;
            String yearAsDate = year + "-01-01";
            return ColumnTypeParser.getAsInstant(yearAsDate);
        }
        if (object instanceof String) {
            String objectAsString = (String)object;
            return ColumnTypeParser.getAsInstant(objectAsString);
        }
        throw new IllegalArgumentException("Argument must be date, local date time or string but got " + object.getClass().getName());
    }

    public static Double convertToDouble(Object object) {
        if (Objects.nonNull(object)) {
            return ConversionHelper.convertToNonNullDouble(object);
        }
        return null;
    }

    private static Double convertToNonNullDouble(Object object) {
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        if (object instanceof Date) {
            return ConversionHelper.convertToDouble(((Date)object).getTime());
        }
        throw new RuntimeException("Type must be number, boolean or date");
    }

    private static Boolean convertToNonNullBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ConversionHelper.convertToNonNullDouble(object) != 0.0;
        }
        throw new RuntimeException("Type must be boolean or number");
    }

    private static Truthness convertToNonNullTruthness(Object object) {
        if (object instanceof Truthness) {
            return (Truthness)object;
        }
        if (object instanceof Boolean || object instanceof Number) {
            return ConversionHelper.convertToNonNullBoolean(object) != false ? SqlHeuristicsCalculator.TRUE_TRUTHNESS : SqlHeuristicsCalculator.FALSE_TRUTHNESS;
        }
        throw new RuntimeException("Type must be truthness, boolean or number");
    }

    public static Truthness convertToTruthness(Object object) {
        if (Objects.nonNull(object)) {
            return ConversionHelper.convertToNonNullTruthness(object);
        }
        return SqlHeuristicsCalculator.FALSE_TRUTHNESS;
    }

    public static Boolean convertToBoolean(Object object) {
        if (Objects.nonNull(object)) {
            return ConversionHelper.convertToNonNullBoolean(object);
        }
        return null;
    }
}

