/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.heuristic;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.ParenthesedFromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;
import org.evomaster.client.java.controller.api.dto.database.schema.DbInfoDto;
import org.evomaster.client.java.sql.heuristic.SqlBaseTableReference;
import org.evomaster.client.java.sql.heuristic.SqlColumnReference;
import org.evomaster.client.java.sql.heuristic.SqlDerivedTableReference;
import org.evomaster.client.java.sql.heuristic.SqlTableReference;
import org.evomaster.client.java.sql.heuristic.TableAliasResolver;
import org.evomaster.client.java.sql.internal.SqlColumnId;
import org.evomaster.client.java.sql.internal.SqlParserUtils;
import org.evomaster.client.java.sql.internal.SqlTableId;

public class TableColumnResolver {
    private final TableAliasResolver tableAliasResolver;
    private final Deque<Statement> contextStatementStack = new ArrayDeque<Statement>();
    private final DbInfoDto schema;

    public TableColumnResolver(DbInfoDto schema) {
        Objects.requireNonNull(schema);
        this.schema = schema;
        this.tableAliasResolver = new TableAliasResolver();
    }

    public void enterStatementeContext(Statement statement) {
        this.tableAliasResolver.enterTableAliasContext(statement);
        this.contextStatementStack.push(statement);
    }

    public void exitCurrentStatementContext() {
        this.contextStatementStack.pop();
        this.tableAliasResolver.exitTableAliasContext();
    }

    private boolean equalNames(String l, String r) {
        Objects.requireNonNull(l);
        return l.equalsIgnoreCase(r);
    }

    private boolean isBaseTable(String tableName) {
        Objects.requireNonNull(tableName);
        return this.schema.tables.stream().filter(t -> this.equalNames(t.name, tableName)).count() > 0L;
    }

    private boolean hasColumn(SqlTableId sqlTableId, SqlColumnId sqlColumnId) {
        Objects.requireNonNull(sqlTableId);
        return this.schema.tables.stream().filter(t -> new SqlTableId(t.name).equals(sqlTableId)).flatMap(t -> t.columns.stream()).filter(c -> new SqlColumnId(c.name).equals(sqlColumnId)).count() > 0L;
    }

    public Statement getCurrentStatement() {
        return this.contextStatementStack.peek();
    }

    public SqlColumnReference resolve(Column column) {
        for (Statement contextStatement : this.contextStatementStack) {
            SqlColumnReference sqlColumnReference = this.resolveInContextStatement(column, contextStatement);
            if (sqlColumnReference == null) continue;
            return sqlColumnReference;
        }
        return null;
    }

    private SqlColumnReference resolveInContextStatement(Column column, Statement contextStatement) {
        SqlColumnId columnId = new SqlColumnId(column.getColumnName());
        if (contextStatement == null) {
            throw new IllegalStateException("No current select context");
        }
        if (column.getTable() != null) {
            SqlTableReference sqlTableReference = this.resolve(column.getTable());
            if (sqlTableReference != null) {
                if (sqlTableReference instanceof SqlBaseTableReference) {
                    SqlBaseTableReference sqlBaseTableReference = (SqlBaseTableReference)sqlTableReference;
                    if (this.hasColumn(sqlBaseTableReference.getTableId(), columnId)) {
                        return new SqlColumnReference(sqlBaseTableReference, column.getColumnName());
                    }
                } else if (sqlTableReference instanceof SqlDerivedTableReference) {
                    SqlDerivedTableReference sqlDerivedTableReference = (SqlDerivedTableReference)sqlTableReference;
                    if (this.findBaseTableColumnReference(sqlDerivedTableReference.getSelect(), column.getColumnName()) != null) {
                        return new SqlColumnReference(sqlDerivedTableReference, column.getColumnName());
                    }
                } else {
                    throw new IllegalArgumentException("Unknown table reference type: " + sqlTableReference.getClass().getName());
                }
            }
            return null;
        }
        return this.resolveInContextStatement(column.getColumnName(), contextStatement);
    }

    private Statement getContextStatement(int contextIndex) {
        if (contextIndex >= 0) {
            Iterator<Statement> iterator = this.contextStatementStack.iterator();
            for (int i = this.contextStatementStack.size() - (contextIndex + 1); i > 0; --i) {
                iterator.next();
            }
            return iterator.next();
        }
        return null;
    }

    private SqlColumnReference resolveInContextStatement(String columnName, Statement contextStatement) {
        Select select;
        Objects.requireNonNull(columnName);
        if (contextStatement instanceof Delete) {
            Delete delete = (Delete)contextStatement;
            if (delete.getTable() != null) {
                return this.findBaseTableColumnReference((FromItem)delete.getTable(), columnName);
            }
        } else if (contextStatement instanceof Update) {
            Update update = (Update)contextStatement;
            if (update.getTable() != null) {
                return this.findBaseTableColumnReference((FromItem)update.getTable(), columnName);
            }
        } else if (contextStatement instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)contextStatement;
            if (this.isColumnAlias(plainSelect, columnName)) {
                columnName = this.getBaseColumn(plainSelect, columnName).getColumnName();
            }
            for (FromItem fromItem : SqlParserUtils.getFromAndJoinItems((Select)plainSelect)) {
                if (this.findBaseTableColumnReference(fromItem, columnName) == null) continue;
                return this.createColumnReference(fromItem, columnName);
            }
        } else if (contextStatement instanceof Select && this.findBaseTableColumnReference(select = (Select)contextStatement, columnName) != null) {
            return new SqlColumnReference(new SqlDerivedTableReference(select), columnName);
        }
        return null;
    }

    private boolean isColumnAlias(PlainSelect plainSelect, String columnName) {
        Objects.requireNonNull(plainSelect);
        Objects.requireNonNull(columnName);
        for (SelectItem selectItem : plainSelect.getSelectItems()) {
            if (!(selectItem.getExpression() instanceof Column) || selectItem.getAlias() == null || !this.equalNames(selectItem.getAlias().getName(), columnName)) continue;
            return true;
        }
        return false;
    }

    private Column getBaseColumn(PlainSelect plainSelect, String aliasColumnName) {
        Objects.requireNonNull(plainSelect);
        Objects.requireNonNull(aliasColumnName);
        if (!this.isColumnAlias(plainSelect, aliasColumnName)) {
            throw new IllegalArgumentException("Column " + aliasColumnName + " not found in " + plainSelect.getSelectItems());
        }
        for (SelectItem selectItem : plainSelect.getSelectItems()) {
            if (!(selectItem.getExpression() instanceof Column) || selectItem.getAlias() == null || !this.equalNames(selectItem.getAlias().getName(), aliasColumnName)) continue;
            return (Column)selectItem.getExpression();
        }
        return null;
    }

    private SqlColumnReference createColumnReference(FromItem fromItem, String columnName) {
        if (fromItem instanceof Table) {
            Table table = (Table)fromItem;
            SqlTableReference sqlTableReference = this.resolve(table);
            return new SqlColumnReference(sqlTableReference, columnName);
        }
        if (fromItem instanceof ParenthesedFromItem) {
            ParenthesedFromItem parenthesedFromItem = (ParenthesedFromItem)fromItem;
            return this.createColumnReference(parenthesedFromItem.getFromItem(), columnName);
        }
        return new SqlColumnReference(new SqlDerivedTableReference((Select)fromItem), columnName);
    }

    public SqlTableReference resolve(Table table) {
        Objects.requireNonNull(table);
        Objects.requireNonNull(table.getName());
        String tableName = table.getName();
        if (this.tableAliasResolver.isAliasDeclaredInAnyContext(tableName)) {
            return this.tableAliasResolver.resolveTableReference(tableName);
        }
        if (this.isBaseTable(tableName)) {
            return new SqlBaseTableReference(tableName);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SqlColumnReference findBaseTableColumnReference(FromItem fromItem, String columnName) {
        Objects.requireNonNull(fromItem);
        Objects.requireNonNull(columnName);
        if (fromItem instanceof LateralSubSelect) {
            LateralSubSelect lateralSubSelect = (LateralSubSelect)fromItem;
            Select subquery = lateralSubSelect.getSelectBody();
            SqlColumnReference sqlColumnReference = this.findBaseTableColumnReference(subquery, columnName);
            if (sqlColumnReference == null) return null;
            return sqlColumnReference;
        }
        if (fromItem instanceof Table) {
            SqlTableReference sqlTableReference;
            Table table = (Table)fromItem;
            String tableName = table.getFullyQualifiedName();
            if (this.tableAliasResolver.isAliasDeclaredInAnyContext(tableName)) {
                sqlTableReference = this.tableAliasResolver.resolveTableReference(tableName);
            } else {
                if (!this.isBaseTable(tableName)) return null;
                sqlTableReference = new SqlBaseTableReference(table.getFullyQualifiedName());
            }
            if (sqlTableReference instanceof SqlBaseTableReference) {
                SqlBaseTableReference sqlBaseTableReference = (SqlBaseTableReference)sqlTableReference;
                SqlColumnId columnId = new SqlColumnId(columnName);
                if (!this.hasColumn(sqlBaseTableReference.getTableId(), columnId)) return null;
                return new SqlColumnReference(sqlTableReference, columnName);
            }
            if (!(sqlTableReference instanceof SqlDerivedTableReference)) return null;
            SqlDerivedTableReference sqlDerivedTableReference = (SqlDerivedTableReference)sqlTableReference;
            if (this.findBaseTableColumnReference(sqlDerivedTableReference.getSelect(), columnName) == null) return null;
            return new SqlColumnReference(sqlTableReference, columnName);
        }
        if (fromItem instanceof ParenthesedFromItem) {
            ParenthesedFromItem parenthesedFromItem = (ParenthesedFromItem)fromItem;
            SqlColumnReference sqlColumnReference = this.findBaseTableColumnReference(parenthesedFromItem.getFromItem(), columnName);
            if (sqlColumnReference == null) return null;
            return sqlColumnReference;
        }
        if (fromItem instanceof ParenthesedSelect) {
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)fromItem;
            Select subquery = parenthesedSelect.getSelect();
            SqlColumnReference sqlColumnReference = this.findBaseTableColumnReference(subquery, columnName);
            if (sqlColumnReference == null) return null;
            return sqlColumnReference;
        }
        if (fromItem instanceof WithItem) {
            WithItem withItem = (WithItem)fromItem;
            Select subquery = withItem.getSelect();
            SqlColumnReference sqlColumnReference = this.findBaseTableColumnReference(subquery, columnName);
            if (sqlColumnReference == null) return null;
            return sqlColumnReference;
        }
        if (!(fromItem instanceof TableFunction)) throw new IllegalArgumentException("Unsupported from item type: " + fromItem.getClass());
        TableFunction tableFunction = (TableFunction)fromItem;
        throw new UnsupportedOperationException("Implement handling of table functions" + tableFunction);
    }

    private SqlColumnReference findBaseTableColumnReference(List<FromItem> fromOrJoinItems, String columnName) {
        Objects.requireNonNull(fromOrJoinItems);
        Objects.requireNonNull(columnName);
        for (FromItem fromOrJoinItem : fromOrJoinItems) {
            SqlColumnReference sqlColumnReference = this.findBaseTableColumnReference(fromOrJoinItem, columnName);
            if (sqlColumnReference == null) continue;
            return sqlColumnReference;
        }
        return null;
    }

    private SqlColumnReference findBaseTableColumnReference(PlainSelect plainSelect, String columnName) {
        Objects.requireNonNull(plainSelect);
        Objects.requireNonNull(columnName);
        for (SelectItem selectItem : plainSelect.getSelectItems()) {
            Alias alias;
            if (selectItem.getExpression() instanceof AllColumns) {
                AllColumns allColumns = (AllColumns)selectItem.getExpression();
                List<FromItem> fromOrJoinItems = SqlParserUtils.getFromAndJoinItems((Select)plainSelect);
                return this.findBaseTableColumnReference(fromOrJoinItems, columnName);
            }
            if (selectItem.getExpression() instanceof AllTableColumns) {
                AllTableColumns allTableColumns = (AllTableColumns)selectItem.getExpression();
                Table table = allTableColumns.getTable();
                return this.findBaseTableColumnReference((FromItem)table, columnName);
            }
            if (selectItem.getExpression() instanceof Column) {
                SqlColumnReference sqlColumnReference;
                alias = selectItem.getAlias();
                Column selectItemColumn = (Column)selectItem.getExpression();
                Table columnTable = selectItemColumn.getTable();
                if (!this.equalNames(selectItemColumn.getColumnName(), columnName) && (alias == null || !this.equalNames(alias.getName(), columnName)) || (sqlColumnReference = columnTable != null ? this.findBaseTableColumnReference((FromItem)columnTable, selectItemColumn.getColumnName()) : this.findBaseTableColumnReference(SqlParserUtils.getFromAndJoinItems((Select)plainSelect), selectItemColumn.getColumnName())) == null) continue;
                return sqlColumnReference;
            }
            alias = selectItem.getAlias();
            if (alias == null || !this.equalNames(alias.getName(), columnName)) continue;
            return new SqlColumnReference(new SqlDerivedTableReference((Select)plainSelect), columnName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SqlColumnReference findBaseTableColumnReference(Select select, String columnName) {
        this.tableAliasResolver.enterTableAliasContext((Statement)select);
        try {
            ParenthesedSelect parenthesedSelect;
            Select subquery;
            SqlColumnReference sqlColumnReference;
            if (select instanceof PlainSelect) {
                PlainSelect plainSelect = (PlainSelect)select;
                SqlColumnReference sqlColumnReference2 = this.findBaseTableColumnReference(plainSelect, columnName);
                return sqlColumnReference2;
            }
            if (select instanceof SetOperationList) {
                SetOperationList setOperationList = (SetOperationList)select.getSelectBody();
                for (Select subquery2 : setOperationList.getSelects()) {
                    SqlColumnReference sqlColumnReference3 = this.findBaseTableColumnReference(subquery2, columnName);
                    if (sqlColumnReference3 == null) continue;
                    SqlColumnReference sqlColumnReference4 = sqlColumnReference3;
                    return sqlColumnReference4;
                }
            } else if (select instanceof WithItem) {
                WithItem withItem = (WithItem)select.getSelectBody();
                Select subquery3 = withItem.getSelect();
                SqlColumnReference sqlColumnReference5 = this.findBaseTableColumnReference(subquery3, columnName);
                if (sqlColumnReference5 != null) {
                    SqlColumnReference sqlColumnReference6 = sqlColumnReference5;
                    return sqlColumnReference6;
                }
            } else if (select instanceof ParenthesedSelect && (sqlColumnReference = this.findBaseTableColumnReference(subquery = (parenthesedSelect = (ParenthesedSelect)select.getSelectBody()).getSelect(), columnName)) != null) {
                SqlColumnReference sqlColumnReference7 = sqlColumnReference;
                return sqlColumnReference7;
            }
            SqlColumnReference sqlColumnReference8 = null;
            return sqlColumnReference8;
        }
        finally {
            this.tableAliasResolver.exitTableAliasContext();
        }
    }
}

