/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.database.operations.InsertionDto;
import org.evomaster.client.java.controller.api.dto.database.operations.InsertionEntryDto;
import org.evomaster.client.java.controller.api.dto.database.schema.ColumnDto;
import org.evomaster.client.java.controller.api.dto.database.schema.DbInfoDto;
import org.evomaster.client.java.controller.api.dto.database.schema.TableDto;
import org.evomaster.client.java.sql.DataRow;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.QueryResultSet;
import org.evomaster.client.java.sql.SqlDataType;
import org.evomaster.client.java.sql.VariableDescriptor;
import org.evomaster.client.java.sql.internal.ColumnTypeParser;
import org.evomaster.client.java.sql.internal.SqlColumnId;
import org.evomaster.client.java.sql.internal.SqlDatabaseDtoUtils;
import org.evomaster.client.java.sql.internal.SqlTableId;

public class QueryResultTransformer {
    public static QueryResult[] convertInsertionDtosToQueryResults(List<InsertionDto> insertionDtos, Map<SqlTableId, Set<SqlColumnId>> columns, DbInfoDto schemaDto) {
        HashMap maps = new HashMap();
        for (SqlTableId tableId : columns.keySet()) {
            ArrayList kresults = new ArrayList();
            insertionDtos.stream().filter(d -> d.targetTable.equalsIgnoreCase(tableId.getTableId())).forEach(insertionDto -> {
                QueryResult qr = QueryResultTransformer.convertInsertionDtoToQueryResult(insertionDto, tableId, (Set)columns.get(tableId), schemaDto, kresults);
                if (qr != null && !qr.isEmpty()) {
                    kresults.add(qr);
                }
            });
            if (kresults.isEmpty()) continue;
            maps.put(tableId, kresults);
        }
        List qrPerTable = QueryResultTransformer.cartesianProduct(maps.keySet().stream().sorted().map(maps::get).collect(Collectors.toList()));
        if (qrPerTable == null) {
            return null;
        }
        return (QueryResult[])qrPerTable.stream().map(QueryResultTransformer::mergeQueryResultsByCartesianProductDataRows).filter(Objects::nonNull).toArray(QueryResult[]::new);
    }

    private static QueryResult mergeQueryResultsByCartesianProductDataRows(List<QueryResult> queryResults) {
        Objects.requireNonNull(queryResults);
        for (QueryResult qr : queryResults) {
            Objects.requireNonNull(qr);
        }
        if (queryResults.isEmpty()) {
            return null;
        }
        if (queryResults.size() == 1) {
            return queryResults.get(0);
        }
        ArrayList<VariableDescriptor> variableDescriptors = new ArrayList<VariableDescriptor>();
        ArrayList datarowList = new ArrayList();
        for (QueryResult qr : queryResults) {
            if (qr.isEmpty()) continue;
            variableDescriptors.addAll(qr.seeVariableDescriptors());
            datarowList.add(qr.seeRows());
        }
        QueryResult merged = new QueryResult(variableDescriptors);
        List results = QueryResultTransformer.cartesianProduct(datarowList);
        if (results != null && !results.isEmpty()) {
            for (List<DataRow> list : results) {
                ArrayList<Object> mergedValues = new ArrayList<Object>();
                list.forEach(d -> mergedValues.addAll(d.seeValues()));
                DataRow mdatarow = new DataRow(variableDescriptors, mergedValues);
                merged.addRow(mdatarow);
            }
        }
        return merged;
    }

    public static <T> List<List<T>> cartesianProduct(List<List<T>> values) {
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        values.forEach(Objects::requireNonNull);
        int[] counts = values.stream().mapToInt(s -> s.size() - 1).toArray();
        int[] indexes = values.stream().mapToInt(s -> s.isEmpty() ? -1 : 0).toArray();
        ArrayList<List<T>> results = new ArrayList<List<T>>();
        boolean isLast = false;
        block0: while (!isLast) {
            if (Arrays.equals(counts, indexes)) {
                isLast = true;
            }
            ArrayList<T> row = new ArrayList<T>();
            for (int i = 0; i < counts.length; ++i) {
                if (indexes[i] < 0) continue;
                row.add(values.get(i).get(indexes[i]));
            }
            results.add(row);
            for (int j = indexes.length - 1; !isLast && j >= 0; --j) {
                if (indexes[j] < 0 || indexes[j] >= counts[j]) continue;
                indexes[j] = indexes[j] + 1;
                for (int t = j + 1; t < indexes.length; ++t) {
                    if (indexes[t] == -1) continue;
                    indexes[t] = 0;
                }
                continue block0;
            }
        }
        return results;
    }

    private static QueryResult convertInsertionDtoToQueryResult(InsertionDto insertionDto, SqlTableId tableId, Set<SqlColumnId> relatedColumns, DbInfoDto dto, List<QueryResult> existingQueryResults) {
        List<String> relatedColumnNames = SqlDatabaseDtoUtils.extractColumnNamesUsedInTheInsertion(insertionDto, relatedColumns);
        if (!relatedColumnNames.isEmpty()) {
            ArrayList<Object> values;
            QueryResult existingQueryResult = !existingQueryResults.isEmpty() ? (QueryResult)existingQueryResults.stream().filter(qr -> qr.sameVariableNames(relatedColumnNames, tableId.getTableId())).findAny().orElse(null) : null;
            QueryResult queryResult = existingQueryResult == null ? new QueryResult(relatedColumnNames, tableId.getTableId()) : existingQueryResult;
            Optional<TableDto> foundTableSchema = dto.tables.stream().filter(t -> t.name.equalsIgnoreCase(tableId.getTableId())).findFirst();
            if (foundTableSchema.isPresent()) {
                TableDto tableDto = foundTableSchema.get();
                List<String> printableValue = SqlDatabaseDtoUtils.extractColumnPrintableValues(insertionDto, relatedColumns);
                assert (printableValue.size() == relatedColumnNames.size());
                values = new ArrayList<Object>();
                for (int i = 0; i < printableValue.size(); ++i) {
                    ColumnDto columnDto = SqlDatabaseDtoUtils.extractColumnInfo(tableDto, relatedColumnNames.get(i));
                    if (columnDto == null) {
                        throw new IllegalArgumentException("Cannot find column schema of " + relatedColumnNames.get(i) + " in Table " + tableId);
                    }
                    values.add(QueryResultTransformer.getColumnValueBasedOnPrintableValue(printableValue.get(i), columnDto));
                }
            } else {
                throw new IllegalArgumentException("Cannot find table schema of " + tableId);
            }
            queryResult.addRow(relatedColumnNames, tableId.getTableId(), values);
            if (existingQueryResult != null) {
                return null;
            }
            return queryResult;
        }
        return null;
    }

    private static Object getColumnValueBasedOnPrintableValue(String printableValue, ColumnDto dto) {
        Instant instant;
        if (printableValue == null) {
            return null;
        }
        String dtoDataTypeName = dto.type;
        SqlDataType dataType = SqlDataType.fromString(dtoDataTypeName);
        if (SqlDataType.isBooleanType(dataType)) {
            return Boolean.valueOf(printableValue);
        }
        if (SqlDataType.isIntegerType(dataType)) {
            return Integer.valueOf(printableValue);
        }
        if (SqlDataType.isShortType(dataType)) {
            return Short.valueOf(printableValue);
        }
        if (SqlDataType.isByteType(dataType)) {
            return Byte.valueOf(printableValue);
        }
        if (SqlDataType.isLongType(dataType)) {
            return Long.valueOf(printableValue);
        }
        if (SqlDataType.isDoubleType(dataType)) {
            return Double.valueOf(printableValue);
        }
        if (SqlDataType.isDateTimeType(dataType) && (instant = ColumnTypeParser.getAsInstant(printableValue)) != null) {
            return instant;
        }
        if (SqlDataType.isStringType(dataType)) {
            return String.valueOf(printableValue);
        }
        return printableValue;
    }

    public static QueryResultSet translateInsertionDtos(List<InsertionDto> insertionDtos, Map<SqlTableId, Set<SqlColumnId>> columns, DbInfoDto schema) {
        QueryResultSet queryResultSet = new QueryResultSet();
        for (SqlTableId tableId : columns.keySet()) {
            TableDto tableDto = schema.tables.stream().filter(t -> t.name.equalsIgnoreCase(tableId.getTableId())).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find table schema of " + tableId));
            List<VariableDescriptor> variableDescriptors = tableDto.columns.stream().map(c -> new VariableDescriptor(c.name, c.name, c.table, c.table)).collect(Collectors.toList());
            QueryResult queryResult = new QueryResult(variableDescriptors);
            for (InsertionDto dto : insertionDtos) {
                if (!tableId.getTableId().equalsIgnoreCase(dto.targetTable)) continue;
                ArrayList<Object> concreteValues = new ArrayList<Object>();
                for (VariableDescriptor variableDescriptor : variableDescriptors) {
                    Object concreteValueOrNull = QueryResultTransformer.findConcreteValueOrNull(variableDescriptor.getColumnName(), tableDto, dto.data);
                    concreteValues.add(concreteValueOrNull);
                }
                DataRow dataRow = new DataRow(variableDescriptors, concreteValues);
                queryResult.addRow(dataRow);
            }
            queryResultSet.addQueryResult(queryResult);
        }
        return queryResultSet;
    }

    private static Object findConcreteValueOrNull(String columnName, TableDto tableDto, List<InsertionEntryDto> entries) {
        for (InsertionEntryDto entry : entries) {
            if (!entry.variableName.equalsIgnoreCase(columnName)) continue;
            ColumnDto columnDto = SqlDatabaseDtoUtils.extractColumnInfo(tableDto, entry.variableName);
            if (columnDto == null) {
                throw new IllegalArgumentException("Cannot find column schema of " + entry.variableName + " in Table " + tableDto.name);
            }
            return QueryResultTransformer.getColumnValueBasedOnPrintableValue(entry.printableValue, columnDto);
        }
        return null;
    }
}

