/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql;

import java.util.Arrays;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.QueryResultSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class QueryResultSetTest {
    QueryResultSetTest() {
    }

    @Test
    void testAddNamedTableQueryResult() {
        QueryResult queryResult = new QueryResult(Arrays.asList("UserId", "UserName"), "Users");
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.addQueryResult(queryResult);
        QueryResult actualQueryResult = queryResultSet.getQueryResultForNamedTable("Users");
        Assertions.assertNotNull((Object)actualQueryResult);
        Assertions.assertEquals((Object)queryResult, (Object)actualQueryResult);
    }

    @Test
    void testDuplicateNamedTableThrowsException() {
        QueryResult queryResult1 = new QueryResult(Arrays.asList("UserId", "UserName"), "Users");
        QueryResult queryResult2 = new QueryResult(Arrays.asList("UserId", "UserName"), "Users");
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.addQueryResult(queryResult1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> queryResultSet.addQueryResult(queryResult2));
    }

    @Test
    void testDuplicatedTableThrowsException() {
        QueryResult queryResult1 = new QueryResult(Arrays.asList("UserId", "UserName"), "Users");
        QueryResult queryResult2 = new QueryResult(Arrays.asList("userId", "userName"), "users");
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.addQueryResult(queryResult1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> queryResultSet.addQueryResult(queryResult2));
    }

    @Test
    void testCaseInsensitiveTableNames() {
        QueryResultSet caseInsensitiveSet = new QueryResultSet();
        QueryResult queryResult = new QueryResult(Arrays.asList("UserId", "UserName"), "Users");
        caseInsensitiveSet.addQueryResult(queryResult);
        Assertions.assertNotNull((Object)caseInsensitiveSet.getQueryResultForNamedTable("users"));
    }
}

