/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.heuristic;

import org.evomaster.client.java.sql.heuristic.SqlStringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SqlStringUtilsTest {
    SqlStringUtilsTest() {
    }

    @Test
    void testRemovesSingleQuotes() {
        String input = "'Hello'";
        String expected = "Hello";
        String actual = SqlStringUtils.removeEnclosingQuotes((String)input);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testRemovesDoubleQuotes() {
        String input = "\"Hello\"";
        String expected = "Hello";
        String actual = SqlStringUtils.removeEnclosingQuotes((String)input);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testRemovesSingleQuotesWithSpaces() {
        String input = "' Hello '";
        String expected = " Hello ";
        String actual = SqlStringUtils.removeEnclosingQuotes((String)input);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testRemovesDoubleQuotesWithSpaces() {
        String input = "\" Hello \"";
        String expected = " Hello ";
        String actual = SqlStringUtils.removeEnclosingQuotes((String)input);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testNoQuotesToRemove() {
        String input = "Hello";
        String expected = "Hello";
        String actual = SqlStringUtils.removeEnclosingQuotes((String)input);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testEmptyString() {
        String input = "";
        String expected = "";
        String actual = SqlStringUtils.removeEnclosingQuotes((String)input);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testNullInput() {
        String input = null;
        String actual = SqlStringUtils.removeEnclosingQuotes(input);
        Assertions.assertNull((Object)actual);
    }

    @Test
    void testSingleCharacter() {
        String input = "'";
        String expected = "'";
        String actual = SqlStringUtils.removeEnclosingQuotes((String)input);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testOnlyStartingQuote() {
        String input = "'Hello";
        String expected = "'Hello";
        String actual = SqlStringUtils.removeEnclosingQuotes((String)input);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testOnlyEndingQuote() {
        String input = "Hello'";
        String expected = "Hello'";
        String actual = SqlStringUtils.removeEnclosingQuotes((String)input);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testMixedQuotesNoRemoval() {
        String input = "'Hello\"";
        String expected = "'Hello\"";
        String actual = SqlStringUtils.removeEnclosingQuotes((String)input);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testSingleCharacterDoubleQuote() {
        String input = "\"";
        String expected = "\"";
        String actual = SqlStringUtils.removeEnclosingQuotes((String)input);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testBothNull() {
        Assertions.assertTrue((boolean)SqlStringUtils.nullSafeEqualsIgnoreCase(null, null));
    }

    @Test
    void testFirstNullSecondNotNull() {
        Assertions.assertFalse((boolean)SqlStringUtils.nullSafeEqualsIgnoreCase(null, (String)"test"));
    }

    @Test
    void testFirstNotNullSecondNull() {
        Assertions.assertFalse((boolean)SqlStringUtils.nullSafeEqualsIgnoreCase((String)"test", null));
    }

    @Test
    void testBothEqualIgnoreCase() {
        Assertions.assertTrue((boolean)SqlStringUtils.nullSafeEqualsIgnoreCase((String)"test", (String)"TEST"));
    }

    @Test
    void testBothNotEqual() {
        Assertions.assertFalse((boolean)SqlStringUtils.nullSafeEqualsIgnoreCase((String)"test", (String)"different"));
    }

    @Test
    void testEmptyStrings() {
        Assertions.assertTrue((boolean)SqlStringUtils.nullSafeEqualsIgnoreCase((String)"", (String)""));
    }

    @Test
    void testOneEmptyOneNonEmpty() {
        Assertions.assertFalse((boolean)SqlStringUtils.nullSafeEqualsIgnoreCase((String)"", (String)"nonempty"));
    }
}

